/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.launch;

import java.io.File;
import java.util.function.Predicate;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.Level;
import org.eclipse.glsp.server.launch.CLIParser;
import org.eclipse.glsp.server.utils.LaunchUtil;

public class DefaultCLIParser
extends CLIParser {
    public static final String OPTION_HELP = "help";
    public static final String OPTION_PORT = "port";
    public static final String OPTION_HOST_NAME = "host";
    public static final String OPTION_CONSOLE_LOG = "consoleLog";
    public static final String OPTION_FILE_LOG = "fileLog";
    public static final String OPTION_LOG_LEVEL = "logLevel";
    public static final String OPTION_LOG_DIR = "logDir";

    public DefaultCLIParser(String[] args, String processName) throws ParseException {
        this(args, DefaultCLIParser.getDefaultOptions(), processName);
    }

    public DefaultCLIParser(String[] args, Options options, String processName) throws ParseException {
        super(args, options, processName);
    }

    public int parsePort() {
        Predicate<Integer> validator = port -> LaunchUtil.isValidPort(port);
        return this.parseIntOption(OPTION_PORT, 0, validator);
    }

    public String parseHostname() {
        return this.parseOption(OPTION_HOST_NAME, "127.0.0.1");
    }

    public String parseLogDir() {
        Predicate<String> validator = logDirArg -> {
            File file = new File((String)logDirArg);
            return file.exists() && file.isDirectory();
        };
        String logDir = this.parseOption(OPTION_LOG_DIR, LaunchUtil.DefaultOptions.LOG_DIR, validator);
        return new File(logDir).getAbsolutePath();
    }

    public Level parseLogLevel() {
        String levelArg = this.parseOption(OPTION_LOG_LEVEL, LaunchUtil.DefaultOptions.LOG_LEVEL.toString());
        return Level.toLevel((String)levelArg, (Level)LaunchUtil.DefaultOptions.LOG_LEVEL);
    }

    public boolean isConsoleLog() {
        return this.parseBoolOption(OPTION_CONSOLE_LOG, true);
    }

    public boolean isFileLog() {
        return this.parseBoolOption(OPTION_FILE_LOG, false);
    }

    public boolean isHelp() {
        return this.hasOption(OPTION_HELP);
    }

    public static Options getDefaultOptions() {
        Options options = new Options();
        options.addOption("h", OPTION_HELP, false, "Display usage information about GLSPServerLauncher");
        options.addOption("n", OPTION_HOST_NAME, true, String.format("Set server host name. [default='%s']", "127.0.0.1"));
        options.addOption("p", OPTION_PORT, true, String.format("Set server port. [default='%s']", 0));
        options.addOption("c", OPTION_CONSOLE_LOG, true, String.format("Enable/Disable console logging. [default='%s']", true));
        options.addOption("f", OPTION_FILE_LOG, true, String.format("Enable/Disable file logging. [default='%s']", false));
        options.addOption("d", OPTION_LOG_DIR, true, String.format("Set the directory for log files (File logging has to be enabled)", LaunchUtil.DefaultOptions.LOG_DIR));
        options.addOption("l", OPTION_LOG_LEVEL, true, String.format("Set the log level. [default='%s']", LaunchUtil.DefaultOptions.LOG_LEVEL));
        return options;
    }
}

