/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.viewer;

import org.eclipse.jface.viewers.IColorDecorator;
import org.eclipse.jface.viewers.IDelayedLabelDecorator;
import org.eclipse.jface.viewers.IFontDecorator;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class CompositeLabelDecorator
implements ILabelDecorator,
IFontDecorator,
IColorDecorator,
IDelayedLabelDecorator {
    private ILabelDecorator[] decorators;

    public CompositeLabelDecorator(ILabelDecorator ... decorators) {
        ILabelDecorator[] iLabelDecoratorArray = decorators;
        int n = decorators.length;
        int n2 = 0;
        while (n2 < n) {
            ILabelDecorator decorator = iLabelDecoratorArray[n2];
            if (decorator == null) {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
        this.decorators = decorators;
    }

    public void addListener(ILabelProviderListener listener) {
        ILabelDecorator[] iLabelDecoratorArray = this.decorators;
        int n = this.decorators.length;
        int n2 = 0;
        while (n2 < n) {
            ILabelDecorator decorator = iLabelDecoratorArray[n2];
            decorator.addListener(listener);
            ++n2;
        }
    }

    public void removeListener(ILabelProviderListener listener) {
        ILabelDecorator[] iLabelDecoratorArray = this.decorators;
        int n = this.decorators.length;
        int n2 = 0;
        while (n2 < n) {
            ILabelDecorator decorator = iLabelDecoratorArray[n2];
            decorator.removeListener(listener);
            ++n2;
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        ILabelDecorator[] iLabelDecoratorArray = this.decorators;
        int n = this.decorators.length;
        int n2 = 0;
        while (n2 < n) {
            ILabelDecorator decorator = iLabelDecoratorArray[n2];
            if (decorator.isLabelProperty(element, property)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void dispose() {
        ILabelDecorator[] iLabelDecoratorArray = this.decorators;
        int n = this.decorators.length;
        int n2 = 0;
        while (n2 < n) {
            ILabelDecorator decorator = iLabelDecoratorArray[n2];
            decorator.dispose();
            ++n2;
        }
    }

    public String decorateText(String text, Object element) {
        ILabelDecorator[] iLabelDecoratorArray = this.decorators;
        int n = this.decorators.length;
        int n2 = 0;
        while (n2 < n) {
            ILabelDecorator decorator = iLabelDecoratorArray[n2];
            String newText = decorator.decorateText(text, element);
            if (newText != null) {
                text = newText;
            }
            ++n2;
        }
        return text;
    }

    public Image decorateImage(Image image, Object element) {
        ILabelDecorator[] iLabelDecoratorArray = this.decorators;
        int n = this.decorators.length;
        int n2 = 0;
        while (n2 < n) {
            ILabelDecorator decorator = iLabelDecoratorArray[n2];
            Image newImage = decorator.decorateImage(image, element);
            if (newImage != null) {
                image = newImage;
            }
            ++n2;
        }
        return image;
    }

    public Font decorateFont(Object element) {
        ILabelDecorator[] iLabelDecoratorArray = this.decorators;
        int n = this.decorators.length;
        int n2 = 0;
        while (n2 < n) {
            Font font;
            ILabelDecorator decorator = iLabelDecoratorArray[n2];
            if (decorator instanceof IFontDecorator && (font = ((IFontDecorator)decorator).decorateFont(element)) != null) {
                return font;
            }
            ++n2;
        }
        return null;
    }

    public Color decorateForeground(Object element) {
        ILabelDecorator[] iLabelDecoratorArray = this.decorators;
        int n = this.decorators.length;
        int n2 = 0;
        while (n2 < n) {
            Color color;
            ILabelDecorator decorator = iLabelDecoratorArray[n2];
            if (decorator instanceof IColorDecorator && (color = ((IColorDecorator)decorator).decorateForeground(element)) != null) {
                return color;
            }
            ++n2;
        }
        return null;
    }

    public Color decorateBackground(Object element) {
        ILabelDecorator[] iLabelDecoratorArray = this.decorators;
        int n = this.decorators.length;
        int n2 = 0;
        while (n2 < n) {
            Color color;
            ILabelDecorator decorator = iLabelDecoratorArray[n2];
            if (decorator instanceof IColorDecorator && (color = ((IColorDecorator)decorator).decorateBackground(element)) != null) {
                return color;
            }
            ++n2;
        }
        return null;
    }

    public boolean prepareDecoration(Object element, String originalText) {
        boolean isReady = true;
        ILabelDecorator[] iLabelDecoratorArray = this.decorators;
        int n = this.decorators.length;
        int n2 = 0;
        while (n2 < n) {
            ILabelDecorator decorator = iLabelDecoratorArray[n2];
            if (decorator instanceof IDelayedLabelDecorator && !((IDelayedLabelDecorator)decorator).prepareDecoration(element, originalText)) {
                isReady = false;
            }
            ++n2;
        }
        return isReady;
    }
}

