/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.callhierarchy;

import java.text.MessageFormat;
import org.eclipse.handly.internal.ui.Activator;
import org.eclipse.handly.ui.callhierarchy.ICallHierarchyNode;
import org.eclipse.handly.ui.callhierarchy.Messages;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class CallHierarchyLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private final ILabelProvider delegate;
    private ResourceManager resourceManager;

    public CallHierarchyLabelProvider(ILabelProvider delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException();
        }
        this.delegate = delegate;
    }

    public void dispose() {
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
            this.resourceManager = null;
        }
    }

    public Image getImage(Object element) {
        if (element instanceof ICallHierarchyNode) {
            ICallHierarchyNode node = (ICallHierarchyNode)element;
            return this.decorateNodeImage(this.delegate.getImage(node.getElement()), node);
        }
        return this.delegate.getImage(element);
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof ICallHierarchyNode) {
            ICallHierarchyNode node = (ICallHierarchyNode)element;
            return this.decorateNodeStyledText(this.getDelegateStyledText(node.getElement()), node);
        }
        return this.getDelegateStyledText(element);
    }

    public String getText(Object element) {
        return this.getStyledText(element).getString();
    }

    protected Image decorateNodeImage(Image image, ICallHierarchyNode node) {
        if (image == null) {
            return null;
        }
        if (node.isRecursive()) {
            return (Image)this.getResourceManager().get((DeviceResourceDescriptor)new DecorationOverlayIcon(image, Activator.getImageDescriptor("org.eclipse.handly.ui/ovr16/recursive.png"), 2));
        }
        return image;
    }

    protected StyledString decorateNodeStyledText(StyledString styledText, ICallHierarchyNode node) {
        int nMatches = node.getCallLocations().length;
        if (nMatches > 1) {
            return StyledCellLabelProvider.styleDecoratedString((String)MessageFormat.format(Messages.CallHierarchyLabelProvider_Element__0__matches__1, styledText, nMatches), (StyledString.Styler)StyledString.COUNTER_STYLER, (StyledString)styledText);
        }
        return styledText;
    }

    protected final ILabelProvider getDelegate() {
        return this.delegate;
    }

    protected final ResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.resourceManager;
    }

    private StyledString getDelegateStyledText(Object element) {
        if (this.delegate instanceof DelegatingStyledCellLabelProvider.IStyledLabelProvider) {
            return ((DelegatingStyledCellLabelProvider.IStyledLabelProvider)this.delegate).getStyledText(element);
        }
        return CallHierarchyLabelProvider.newStyledString(this.delegate.getText(element));
    }

    private static StyledString newStyledString(String string) {
        return string != null ? new StyledString(string) : new StyledString();
    }
}

