/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.buffer;

import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.handly.buffer.Buffer;
import org.eclipse.handly.buffer.BufferChange;
import org.eclipse.handly.buffer.BufferChangeOperation;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.buffer.IBufferChange;
import org.eclipse.handly.buffer.SaveMode;
import org.eclipse.handly.snapshot.DocumentSnapshot;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.StaleSnapshotException;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class BufferChangeOperationTest
extends TestCase {
    private IBuffer buffer;

    protected void setUp() throws Exception {
        super.setUp();
        this.buffer = new Buffer();
    }

    public void test1() throws Exception {
        BufferChange change = new BufferChange((TextEdit)new InsertEdit(0, "foo"));
        IBufferChange undoChange = new BufferChangeOperation(this.buffer, (IBufferChange)change).execute((IProgressMonitor)new NullProgressMonitor());
        BufferChangeOperationTest.assertEquals((String)"foo", (String)this.buffer.getDocument().get());
        BufferChangeOperationTest.assertFalse((boolean)this.buffer.isDirty());
        IBufferChange redoChange = new BufferChangeOperation(this.buffer, undoChange).execute((IProgressMonitor)new NullProgressMonitor());
        BufferChangeOperationTest.assertEquals((String)"", (String)this.buffer.getDocument().get());
        BufferChangeOperationTest.assertFalse((boolean)this.buffer.isDirty());
        new BufferChangeOperation(this.buffer, redoChange).execute((IProgressMonitor)new NullProgressMonitor());
        BufferChangeOperationTest.assertEquals((String)"foo", (String)this.buffer.getDocument().get());
        BufferChangeOperationTest.assertFalse((boolean)this.buffer.isDirty());
    }

    public void test2() throws Exception {
        BufferChange change = new BufferChange((TextEdit)new InsertEdit(0, "foo"));
        change.setStyle(0);
        change.setSaveMode(SaveMode.LEAVE_UNSAVED);
        BufferChangeOperationTest.assertNull((Object)new BufferChangeOperation(this.buffer, (IBufferChange)change).execute((IProgressMonitor)new NullProgressMonitor()));
        BufferChangeOperationTest.assertEquals((String)"foo", (String)this.buffer.getDocument().get());
        BufferChangeOperationTest.assertTrue((boolean)this.buffer.isDirty());
        change = new BufferChange((TextEdit)new ReplaceEdit(0, 3, "bar"));
        new BufferChangeOperation(this.buffer, (IBufferChange)change).execute((IProgressMonitor)new NullProgressMonitor());
        BufferChangeOperationTest.assertEquals((String)"bar", (String)this.buffer.getDocument().get());
        BufferChangeOperationTest.assertTrue((boolean)this.buffer.isDirty());
        change = new BufferChange((TextEdit)new DeleteEdit(0, 3));
        change.setSaveMode(SaveMode.FORCE_SAVE);
        new BufferChangeOperation(this.buffer, (IBufferChange)change).execute((IProgressMonitor)new NullProgressMonitor());
        BufferChangeOperationTest.assertEquals((String)"", (String)this.buffer.getDocument().get());
        BufferChangeOperationTest.assertFalse((boolean)this.buffer.isDirty());
    }

    public void test3() throws Exception {
        BufferChange change = new BufferChange((TextEdit)new InsertEdit(0, "foo"));
        change.setBase((ISnapshot)new DocumentSnapshot(this.buffer.getDocument()));
        this.buffer.getDocument().set("bar");
        try {
            new BufferChangeOperation(this.buffer, (IBufferChange)change).execute((IProgressMonitor)new NullProgressMonitor());
            BufferChangeOperationTest.fail();
        }
        catch (StaleSnapshotException staleSnapshotException) {
            // empty catch block
        }
    }

    public void test4() throws Exception {
        BufferChange change = new BufferChange((TextEdit)new InsertEdit(0, "foo"));
        IBufferChange undoChange = new BufferChangeOperation(this.buffer, (IBufferChange)change).execute((IProgressMonitor)new NullProgressMonitor());
        this.buffer.getDocument().set("");
        try {
            new BufferChangeOperation(this.buffer, undoChange).execute((IProgressMonitor)new NullProgressMonitor());
            BufferChangeOperationTest.fail();
        }
        catch (StaleSnapshotException staleSnapshotException) {
            // empty catch block
        }
    }
}

