/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.cli;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.dns.AddressResolverOptions;
import org.eclipse.hono.application.client.ApplicationClient;
import org.eclipse.hono.application.client.amqp.AmqpMessageContext;
import org.eclipse.hono.application.client.amqp.ProtonBasedApplicationClient;
import org.eclipse.hono.application.client.kafka.KafkaMessageContext;
import org.eclipse.hono.application.client.kafka.impl.KafkaApplicationClientImpl;
import org.eclipse.hono.client.HonoConnection;
import org.eclipse.hono.client.kafka.CommonKafkaClientConfigProperties;
import org.eclipse.hono.client.kafka.consumer.MessagingKafkaConsumerConfigProperties;
import org.eclipse.hono.client.kafka.producer.CachingKafkaProducerFactory;
import org.eclipse.hono.client.kafka.producer.KafkaProducerFactory;
import org.eclipse.hono.client.kafka.producer.MessagingKafkaProducerConfigProperties;
import org.eclipse.hono.config.ClientConfigProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
public class AppConfiguration {
    @Bean
    public Vertx vertx() {
        VertxOptions options = new VertxOptions().setWarningExceptionTime(1500000000L).setAddressResolverOptions(this.addressResolverOptions());
        return Vertx.vertx((VertxOptions)options);
    }

    @ConfigurationProperties(prefix="address.resolver")
    @Bean
    public AddressResolverOptions addressResolverOptions() {
        AddressResolverOptions addressResolverOptions = new AddressResolverOptions();
        return addressResolverOptions;
    }

    @ConfigurationProperties(prefix="hono.client")
    @Bean
    public ClientConfigProperties honoClientConfig() {
        ClientConfigProperties config = new ClientConfigProperties();
        return config;
    }

    @ConfigurationProperties(prefix="hono.kafka")
    @Bean
    public CommonKafkaClientConfigProperties commonKafkaClientConfig() {
        return new CommonKafkaClientConfigProperties();
    }

    @ConfigurationProperties(prefix="hono.kafka.consumer")
    @Profile(value={"kafka"})
    @Bean
    public MessagingKafkaConsumerConfigProperties messagingKafkaConsumerConfig(CommonKafkaClientConfigProperties commonKafkaClientConfig) {
        MessagingKafkaConsumerConfigProperties configProperties = new MessagingKafkaConsumerConfigProperties();
        configProperties.setCommonClientConfig(commonKafkaClientConfig);
        return configProperties;
    }

    @ConfigurationProperties(prefix="hono.kafka.producer")
    @Profile(value={"kafka"})
    @Bean
    public MessagingKafkaProducerConfigProperties messagingKafkaProducerConfig(CommonKafkaClientConfigProperties commonKafkaClientConfig) {
        MessagingKafkaProducerConfigProperties configProperties = new MessagingKafkaProducerConfigProperties();
        configProperties.setCommonClientConfig(commonKafkaClientConfig);
        return configProperties;
    }

    @Profile(value={"kafka"})
    @Bean
    public KafkaProducerFactory<String, Buffer> kafkaProducerFactory() {
        return CachingKafkaProducerFactory.sharedFactory((Vertx)this.vertx());
    }

    @Profile(value={"!kafka"})
    @Bean
    public ApplicationClient<AmqpMessageContext> amqpApplicationClient(Vertx vertx, ClientConfigProperties clientConfig) {
        return new ProtonBasedApplicationClient(HonoConnection.newConnection((Vertx)vertx, (ClientConfigProperties)clientConfig));
    }

    @Profile(value={"kafka"})
    @Bean
    public ApplicationClient<KafkaMessageContext> kafkaApplicationClient(Vertx vertx, MessagingKafkaConsumerConfigProperties kafkaConsumerConfigProperties, KafkaProducerFactory<String, Buffer> producerFactory, MessagingKafkaProducerConfigProperties kafkaProducerConfigProperties) {
        return new KafkaApplicationClientImpl(vertx, kafkaConsumerConfigProperties, producerFactory, kafkaProducerConfigProperties);
    }
}

