/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.cli.app;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.buffer.Buffer;
import java.time.Duration;
import java.util.Optional;
import java.util.Scanner;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.eclipse.hono.application.client.DownstreamMessage;
import org.eclipse.hono.application.client.amqp.AmqpApplicationClient;
import org.eclipse.hono.cli.app.AbstractApplicationClient;
import org.eclipse.hono.cli.app.Commander;
import org.eclipse.hono.client.ServerErrorException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"command"})
public class Commander
extends AbstractApplicationClient {
    private final Scanner scanner = new Scanner(System.in);
    @Value(value="${command.timeoutInSeconds}")
    private int commandTimeOutInSeconds;
    @Value(value="${device.id}")
    private String deviceId;
    private WorkerExecutor workerExecutor;

    @PostConstruct
    void start() {
        this.workerExecutor = this.vertx.createSharedWorkerExecutor("user-input-pool", 3, TimeUnit.HOURS.toNanos(1L));
        this.client.start().onSuccess(v -> {
            if (this.client instanceof AmqpApplicationClient) {
                ((AmqpApplicationClient)this.client).addReconnectListener(c -> this.startCommandClient());
            }
        }).compose(v -> this.startCommandClient()).onFailure(arg_0 -> this.close(arg_0));
    }

    private Future<Void> startCommandClient() {
        return this.getCommandFromUser().compose(arg_0 -> this.processCommand(arg_0)).onComplete(sendAttempt -> this.startCommandClient());
    }

    private Future<Void> processCommand(Command command) {
        Future sendResult;
        if (command.isOneWay()) {
            this.log.info("Command sent to device");
            sendResult = this.client.sendOneWayCommand(this.tenantId, this.deviceId, command.getName(), command.getContentType(), Buffer.buffer((String)command.getPayload()), null, null);
        } else {
            this.log.info("Command sent to device... [waiting for response for max. {} seconds]", (Object)this.commandTimeOutInSeconds);
            sendResult = this.client.sendCommand(this.tenantId, this.deviceId, command.getName(), command.getContentType(), Buffer.buffer((String)command.getPayload()), UUID.randomUUID().toString(), null, Duration.ofSeconds(this.commandTimeOutInSeconds), null).map(arg_0 -> this.printResponse(arg_0));
        }
        return sendResult.otherwise(error -> {
            if (ServerErrorException.extractStatusCode((Throwable)error) == 503) {
                this.log.error("Error sending command (error code 503). Is the device really waiting for a command? (device [{}] in tenant [{}])", (Object)this.deviceId, (Object)this.tenantId);
            } else {
                this.log.error("Error sending command: {}", (Object)error.getMessage());
            }
            return null;
        });
    }

    private Void printResponse(DownstreamMessage<?> result) {
        this.log.info("Received Command response : {}", (Object)Optional.ofNullable(result.getPayload()).orElseGet(Buffer::buffer));
        return null;
    }

    private Future<Command> getCommandFromUser() {
        Promise result = Promise.promise();
        this.workerExecutor.executeBlocking(userInputFuture -> {
            System.out.println();
            System.out.println();
            System.out.printf(">>>>>>>>> Enter name of command for device [%s] in tenant [%s] (prefix with 'ow:' to send one-way command):", this.deviceId, this.tenantId);
            System.out.println();
            String honoCmd = this.scanner.nextLine();
            System.out.println(">>>>>>>>> Enter command payload:");
            String honoPayload = this.scanner.nextLine();
            System.out.println(">>>>>>>>> Enter content type:");
            String honoContentType = this.scanner.nextLine();
            System.out.println();
            userInputFuture.complete((Object)new Command(honoCmd, honoPayload, honoContentType));
        }, (Handler)result);
        return result.future();
    }

    private void close(Throwable t) {
        this.workerExecutor.close();
        this.vertx.close();
        this.client.stop();
        this.log.error("Error: {}", (Object)t.getMessage());
    }
}

