/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.proton.streams.impl;

import io.vertx.proton.ProtonReceiver;
import io.vertx.proton.streams.Delivery;
import io.vertx.proton.streams.ProtonPublisher;
import io.vertx.proton.streams.impl.ProtonPublisherImpl;
import java.util.Objects;
import org.apache.qpid.proton.amqp.transport.Source;
import org.apache.qpid.proton.amqp.transport.Target;
import org.apache.qpid.proton.message.Message;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class ProtonPublisherWrapperImpl
implements ProtonPublisher<Message> {
    private ProtonPublisherImpl delegate;

    public ProtonPublisherWrapperImpl(ProtonPublisherImpl delegate) {
        this.delegate = delegate;
    }

    @Override
    public void subscribe(Subscriber<? super Message> subscriber) {
        Objects.requireNonNull(subscriber, "A subscriber must be supplied");
        this.delegate.subscribe(new AmqpSubscriberWrapperImpl(subscriber));
    }

    public boolean isEmitOnConnectionEnd() {
        return this.delegate.isEmitOnConnectionEnd();
    }

    public void setEmitOnConnectionEnd(boolean emitOnConnectionEnd) {
        this.delegate.setEmitOnConnectionEnd(emitOnConnectionEnd);
    }

    public ProtonReceiver getLink() {
        return this.delegate.getLink();
    }

    @Override
    public String getRemoteAddress() {
        return this.delegate.getRemoteAddress();
    }

    @Override
    public ProtonPublisher<Message> setSource(Source source) {
        this.delegate.setSource(source);
        return this;
    }

    @Override
    public Source getSource() {
        return this.delegate.getSource();
    }

    @Override
    public ProtonPublisher<Message> setTarget(Target target) {
        this.delegate.setTarget(target);
        return this;
    }

    @Override
    public Target getTarget() {
        return this.delegate.getTarget();
    }

    @Override
    public Source getRemoteSource() {
        return this.delegate.getRemoteSource();
    }

    @Override
    public Target getRemoteTarget() {
        return this.delegate.getRemoteTarget();
    }

    private static class AmqpSubscriberWrapperImpl
    implements Subscriber<Delivery> {
        private Subscriber<? super Message> delegateSub;

        public AmqpSubscriberWrapperImpl(Subscriber<? super Message> subscriber) {
            this.delegateSub = subscriber;
        }

        @Override
        public void onSubscribe(Subscription s) {
            this.delegateSub.onSubscribe(s);
        }

        @Override
        public void onNext(Delivery d) {
            Message m = d.message();
            this.delegateSub.onNext(m);
            d.accept();
        }

        @Override
        public void onError(Throwable t) {
            this.delegateSub.onError(t);
        }

        @Override
        public void onComplete() {
            this.delegateSub.onComplete();
        }
    }
}

