/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.Lock;
import io.quarkus.arc.LockException;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;

@Lock
@Interceptor
@Priority(value=0)
public class LockInterceptor {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    @AroundInvoke
    Object lock(InvocationContext ctx) throws Exception {
        Lock lock = this.getLock(ctx);
        switch (lock.value()) {
            case WRITE: {
                return this.writeLock(lock, ctx);
            }
            case READ: {
                return this.readLock(lock, ctx);
            }
            case NONE: {
                return ctx.proceed();
            }
        }
        throw new LockException("Unsupported @Lock type found on business method " + ctx.getMethod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object writeLock(Lock lock, InvocationContext ctx) throws Exception {
        boolean locked = false;
        long time = lock.time();
        try {
            if (time > 0L) {
                locked = this.readWriteLock.writeLock().tryLock(time, lock.unit());
                if (!locked) {
                    throw new LockException("Write lock not acquired in " + lock.unit().toMillis(time) + " ms");
                }
            } else {
                this.readWriteLock.writeLock().lock();
                locked = true;
            }
            Object object = ctx.proceed();
            return object;
        }
        finally {
            if (locked) {
                this.readWriteLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readLock(Lock lock, InvocationContext ctx) throws Exception {
        boolean locked = false;
        long time = lock.time();
        try {
            if (time > 0L) {
                locked = this.readWriteLock.readLock().tryLock(time, lock.unit());
                if (!locked) {
                    throw new LockException("Read lock not acquired in " + lock.unit().toMillis(time) + " ms");
                }
            } else {
                this.readWriteLock.readLock().lock();
                locked = true;
            }
            Object object = ctx.proceed();
            return object;
        }
        finally {
            if (locked) {
                this.readWriteLock.readLock().unlock();
            }
        }
    }

    Lock getLock(InvocationContext ctx) {
        Set bindings = (Set)ctx.getContextData().get("io.quarkus.arc.interceptorBindings");
        for (Annotation annotation : bindings) {
            if (!annotation.annotationType().equals(Lock.class)) continue;
            return (Lock)annotation;
        }
        throw new LockException("@Lock binding not found on business method " + ctx.getMethod());
    }
}

