/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.operators.uni.UniOperatorProcessor;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.function.BiFunction;

public class UniOnItemOrFailureFlatMap<I, O>
extends UniOperator<I, O> {
    private final BiFunction<? super I, Throwable, Uni<? extends O>> mapper;

    public UniOnItemOrFailureFlatMap(Uni<I> upstream, BiFunction<? super I, Throwable, Uni<? extends O>> mapper) {
        super(upstream);
        this.mapper = mapper;
    }

    @Override
    public void subscribe(UniSubscriber<? super O> subscriber) {
        AbstractUni.subscribe(this.upstream(), new UniOnItemOrFailureFlatMapProcessor(subscriber));
    }

    private class UniOnItemOrFailureFlatMapProcessor
    extends UniOperatorProcessor<I, O> {
        private volatile UniSubscription innerSubscription;

        public UniOnItemOrFailureFlatMapProcessor(UniSubscriber<? super O> downstream) {
            super(downstream);
        }

        @Override
        public void onSubscribe(UniSubscription subscription) {
            if (this.getCurrentUpstreamSubscription() == null) {
                super.onSubscribe(subscription);
            } else if (this.innerSubscription == null) {
                this.innerSubscription = subscription;
            } else {
                subscription.cancel();
            }
        }

        @Override
        public void onItem(I item) {
            if (!this.isCancelled()) {
                if (this.innerSubscription == null) {
                    this.performInnerSubscription(item, null);
                } else {
                    this.downstream.onItem(item);
                }
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            if (!this.isCancelled()) {
                if (this.innerSubscription == null) {
                    this.performInnerSubscription(null, failure);
                } else {
                    this.downstream.onFailure(failure);
                }
            } else {
                Infrastructure.handleDroppedException(failure);
            }
        }

        @Override
        public void cancel() {
            if (this.innerSubscription != null) {
                this.innerSubscription.cancel();
            }
            super.cancel();
        }

        private void performInnerSubscription(I item, Throwable failure) {
            Uni uni;
            try {
                uni = (Uni)UniOnItemOrFailureFlatMap.this.mapper.apply(item, failure);
            }
            catch (Throwable err) {
                if (failure != null) {
                    this.downstream.onFailure(new CompositeException(failure, err));
                } else {
                    this.downstream.onFailure(err);
                }
                return;
            }
            if (uni == null) {
                this.downstream.onFailure(new NullPointerException("The mapper returned `null`"));
                return;
            }
            AbstractUni.subscribe(uni, this);
        }
    }
}

