/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.vertx.codegen.lang;

import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.codegen.lang.ConditionalCodeWriter;
import io.vertx.codegen.ClassModel;
import io.vertx.codegen.Helper;
import io.vertx.codegen.TypeParamInfo;
import java.io.PrintWriter;
import java.util.List;
import java.util.stream.Collectors;

public class DelegateFieldCodeWriter
implements ConditionalCodeWriter {
    @Override
    public void generate(ClassModel model, PrintWriter writer) {
        writer.print("  private final ");
        writer.print(Helper.getNonGenericType(model.getIfaceFQCN()));
        List<TypeParamInfo.Class> typeParams = model.getTypeParams();
        if (typeParams.size() > 0) {
            writer.print(typeParams.stream().map(TypeParamInfo::getName).collect(Collectors.joining(",", "<", ">")));
        }
        writer.println(" delegate;");
        for (TypeParamInfo.Class typeParam : typeParams) {
            writer.print("  public final " + TypeArg.class.getName() + "<");
            writer.print(typeParam.getName());
            writer.print("> __typeArg_");
            writer.print(typeParam.getIndex());
            writer.println(";");
        }
        writer.println("  ");
    }

    @Override
    public boolean test(ClassModel classModel) {
        return classModel.isConcrete();
    }
}

