/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.AsyncFile;
import io.vertx.core.http.HttpClosedException;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import java.nio.channels.ClosedChannelException;
import java.security.cert.Certificate;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;

class HttpNetSocket
implements NetSocket {
    private final ConnectionBase conn;
    private final ContextInternal context;
    private final ReadStream<Buffer> readStream;
    private final WriteStream<Buffer> writeStream;
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> closeHandler;
    private Handler<Void> endHandler;
    private Handler<Buffer> dataHandler;

    static HttpNetSocket netSocket(ConnectionBase conn, ContextInternal context, ReadStream<Buffer> readStream, WriteStream<Buffer> writeStream) {
        HttpNetSocket sock = new HttpNetSocket(conn, context, readStream, writeStream);
        readStream.handler(sock::handleData);
        readStream.endHandler(sock::handleEnd);
        readStream.exceptionHandler(sock::handleException);
        return sock;
    }

    private HttpNetSocket(ConnectionBase conn, ContextInternal context, ReadStream<Buffer> readStream, WriteStream<Buffer> writeStream) {
        this.conn = conn;
        this.context = context;
        this.readStream = readStream;
        this.writeStream = writeStream;
    }

    private void handleEnd(Void v) {
        Handler<Void> closeHandler;
        Handler<Void> endHandler = this.endHandler();
        if (endHandler != null) {
            endHandler.handle(null);
        }
        if ((closeHandler = this.closeHandler()) != null) {
            closeHandler.handle(null);
        }
    }

    private void handleData(Buffer buf) {
        Handler<Buffer> handler = this.handler();
        if (handler != null) {
            handler.handle(buf);
        }
    }

    private void handleException(Throwable cause) {
        if (cause instanceof HttpClosedException || cause.getClass() == ClosedChannelException.class) {
            Handler<Void> closeHandler;
            Handler<Void> endHandler = this.endHandler();
            if (endHandler != null) {
                endHandler.handle(null);
            }
            if ((closeHandler = this.closeHandler()) != null) {
                closeHandler.handle(null);
            }
        } else {
            Handler<Throwable> handler = this.exceptionHandler();
            if (handler != null) {
                handler.handle(cause);
            }
        }
    }

    @Override
    public synchronized NetSocket exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    synchronized Handler<Throwable> exceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public synchronized NetSocket handler(Handler<Buffer> handler) {
        this.dataHandler = handler;
        return this;
    }

    synchronized Handler<Buffer> handler() {
        return this.dataHandler;
    }

    @Override
    public NetSocket fetch(long amount) {
        this.readStream.fetch(amount);
        return this;
    }

    @Override
    public NetSocket pause() {
        this.readStream.pause();
        return this;
    }

    @Override
    public NetSocket resume() {
        this.readStream.resume();
        return this;
    }

    @Override
    public synchronized NetSocket endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        return this;
    }

    synchronized Handler<Void> endHandler() {
        return this.endHandler;
    }

    @Override
    public NetSocket setWriteQueueMaxSize(int maxSize) {
        this.writeStream.setWriteQueueMaxSize(maxSize);
        return this;
    }

    @Override
    public NetSocket drainHandler(Handler<Void> handler) {
        this.writeStream.drainHandler(handler);
        return this;
    }

    @Override
    public boolean writeQueueFull() {
        return this.writeStream.writeQueueFull();
    }

    @Override
    public String writeHandlerID() {
        return null;
    }

    @Override
    public Future<Void> write(Buffer data) {
        return this.writeStream.write(data);
    }

    @Override
    public void write(Buffer data, Handler<AsyncResult<Void>> handler) {
        this.writeStream.write(data, handler);
    }

    @Override
    public Future<Void> write(String str, String enc) {
        return this.write(Buffer.buffer(str, enc));
    }

    @Override
    public void write(String str, String enc, Handler<AsyncResult<Void>> handler) {
        this.writeStream.write(Buffer.buffer(str, enc), handler);
    }

    @Override
    public Future<Void> write(String str) {
        return this.writeStream.write(Buffer.buffer(str));
    }

    @Override
    public void write(String str, Handler<AsyncResult<Void>> handler) {
        this.writeStream.write(Buffer.buffer(str), handler);
    }

    @Override
    public Future<Void> end(Buffer data) {
        return this.writeStream.end(data);
    }

    @Override
    public void end(Buffer buffer, Handler<AsyncResult<Void>> handler) {
        this.writeStream.end(buffer, handler);
    }

    @Override
    public Future<Void> end() {
        return this.writeStream.end();
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.writeStream.end(handler);
    }

    @Override
    public Future<Void> sendFile(String filename, long offset, long length) {
        PromiseInternal<Void> promise = this.context.promise();
        this.sendFile(filename, offset, length, promise);
        return promise.future();
    }

    @Override
    public NetSocket sendFile(String filename, long offset, long length, Handler<AsyncResult<Void>> resultHandler) {
        Handler<AsyncResult> h;
        VertxInternal vertx = this.conn.getContext().owner();
        if (resultHandler != null) {
            ContextInternal resultCtx = vertx.getOrCreateContext();
            h = ar -> resultCtx.runOnContext(v -> resultHandler.handle((AsyncResult<Void>)ar));
        } else {
            h = ar -> {};
        }
        HttpUtils.resolveFile(vertx, filename, offset, length, ar -> {
            if (ar.succeeded()) {
                AsyncFile file = (AsyncFile)ar.result();
                file.pipe().endOnComplete(false).to(this, ar1 -> file.close(ar2 -> {
                    Throwable failure;
                    Throwable throwable = ar1.failed() ? ar1.cause() : (failure = ar2.failed() ? ar2.cause() : null);
                    if (failure == null) {
                        h.handle((AsyncResult)ar1);
                    } else {
                        h.handle(Future.failedFuture(failure));
                    }
                }));
            } else {
                h.handle(ar.mapEmpty());
            }
        });
        return this;
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.conn.remoteAddress();
    }

    @Override
    public SocketAddress localAddress() {
        return this.conn.localAddress();
    }

    @Override
    public Future<Void> close() {
        return this.end();
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        this.end(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetSocket closeHandler(@Nullable Handler<Void> handler) {
        ConnectionBase connectionBase = this.conn;
        synchronized (connectionBase) {
            this.closeHandler = handler;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Handler<Void> closeHandler() {
        ConnectionBase connectionBase = this.conn;
        synchronized (connectionBase) {
            return this.closeHandler;
        }
    }

    @Override
    public NetSocket upgradeToSsl(Handler<AsyncResult<Void>> handler) {
        handler.handle(this.upgradeToSsl());
        return this;
    }

    @Override
    public NetSocket upgradeToSsl(String serverName, Handler<AsyncResult<Void>> handler) {
        handler.handle(this.upgradeToSsl(serverName));
        return this;
    }

    @Override
    public Future<Void> upgradeToSsl() {
        return Future.failedFuture("Cannot upgrade stream to SSL");
    }

    @Override
    public Future<Void> upgradeToSsl(String serverName) {
        return Future.failedFuture("Cannot upgrade stream to SSL");
    }

    @Override
    public boolean isSsl() {
        return this.conn.isSsl();
    }

    @Override
    public SSLSession sslSession() {
        return this.conn.sslSession();
    }

    @Override
    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        return this.conn.peerCertificateChain();
    }

    @Override
    public List<Certificate> peerCertificates() throws SSLPeerUnverifiedException {
        return this.conn.peerCertificates();
    }

    @Override
    public String indicatedServerName() {
        return this.conn.indicatedServerName();
    }

    @Override
    public String applicationLayerProtocol() {
        return null;
    }
}

