/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.util;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.util.ExecutionContext;

public abstract class MapBasedExecutionContext
implements ExecutionContext {
    private Map<String, Object> data;
    private final Span span;

    public MapBasedExecutionContext(Span span) {
        this.span = Objects.requireNonNull(span);
    }

    @Override
    public final <T> T get(String key) {
        return this.get(key, null);
    }

    @Override
    public final <T> T get(String key, T defaultValue) {
        return (T)Optional.ofNullable(this.getData().get(key)).map(value -> value).orElse(defaultValue);
    }

    @Override
    public final void put(String key, Object value) {
        this.getData().put(key, value);
    }

    @Override
    public final Span getTracingSpan() {
        return this.span;
    }

    @Override
    public final SpanContext getTracingContext() {
        return this.span.context();
    }

    private Map<String, Object> getData() {
        return Optional.ofNullable(this.data).orElseGet(() -> {
            this.data = new HashMap<String, Object>();
            return this.data;
        });
    }
}

