/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;
import io.fabric8.kubernetes.api.model.TypedLocalObjectReference;
import io.fabric8.kubernetes.api.model.extensions.IngressBackend;
import io.fabric8.kubernetes.api.model.extensions.IngressBackendFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class IngressBackendFluentImpl<A extends IngressBackendFluent<A>>
extends BaseFluent<A>
implements IngressBackendFluent<A> {
    private TypedLocalObjectReference resource;
    private String serviceName;
    private IntOrStringBuilder servicePort;
    private Map<String, Object> additionalProperties;

    public IngressBackendFluentImpl() {
    }

    public IngressBackendFluentImpl(IngressBackend instance) {
        this.withResource(instance.getResource());
        this.withServiceName(instance.getServiceName());
        this.withServicePort(instance.getServicePort());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public TypedLocalObjectReference getResource() {
        return this.resource;
    }

    @Override
    public A withResource(TypedLocalObjectReference resource) {
        this.resource = resource;
        return (A)this;
    }

    @Override
    public Boolean hasResource() {
        return this.resource != null;
    }

    @Override
    public A withNewResource(String apiGroup, String kind, String name) {
        return this.withResource(new TypedLocalObjectReference(apiGroup, kind, name));
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public A withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return (A)this;
    }

    @Override
    public Boolean hasServiceName() {
        return this.serviceName != null;
    }

    @Override
    @Deprecated
    public IntOrString getServicePort() {
        return this.servicePort != null ? this.servicePort.build() : null;
    }

    @Override
    public IntOrString buildServicePort() {
        return this.servicePort != null ? this.servicePort.build() : null;
    }

    @Override
    public A withServicePort(IntOrString servicePort) {
        this._visitables.get("servicePort").remove(this.servicePort);
        if (servicePort != null) {
            this.servicePort = new IntOrStringBuilder(servicePort);
            this._visitables.get("servicePort").add(this.servicePort);
        } else {
            this.servicePort = null;
            this._visitables.get("servicePort").remove(this.servicePort);
        }
        return (A)this;
    }

    @Override
    public Boolean hasServicePort() {
        return this.servicePort != null;
    }

    @Override
    public A withNewServicePort(Object value) {
        return this.withServicePort(new IntOrString(value));
    }

    @Override
    public IngressBackendFluent.ServicePortNested<A> withNewServicePort() {
        return new ServicePortNestedImpl();
    }

    @Override
    public IngressBackendFluent.ServicePortNested<A> withNewServicePortLike(IntOrString item) {
        return new ServicePortNestedImpl(item);
    }

    @Override
    public IngressBackendFluent.ServicePortNested<A> editServicePort() {
        return this.withNewServicePortLike(this.getServicePort());
    }

    @Override
    public IngressBackendFluent.ServicePortNested<A> editOrNewServicePort() {
        return this.withNewServicePortLike(this.getServicePort() != null ? this.getServicePort() : new IntOrStringBuilder().build());
    }

    @Override
    public IngressBackendFluent.ServicePortNested<A> editOrNewServicePortLike(IntOrString item) {
        return this.withNewServicePortLike(this.getServicePort() != null ? this.getServicePort() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngressBackendFluentImpl that = (IngressBackendFluentImpl)o;
        if (this.resource != null ? !this.resource.equals(that.resource) : that.resource != null) {
            return false;
        }
        if (this.serviceName != null ? !this.serviceName.equals(that.serviceName) : that.serviceName != null) {
            return false;
        }
        if (this.servicePort != null ? !this.servicePort.equals(that.servicePort) : that.servicePort != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.resource, this.serviceName, this.servicePort, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.resource != null) {
            sb.append("resource:");
            sb.append(this.resource + ",");
        }
        if (this.serviceName != null) {
            sb.append("serviceName:");
            sb.append(this.serviceName + ",");
        }
        if (this.servicePort != null) {
            sb.append("servicePort:");
            sb.append(this.servicePort + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class ServicePortNestedImpl<N>
    extends IntOrStringFluentImpl<IngressBackendFluent.ServicePortNested<N>>
    implements IngressBackendFluent.ServicePortNested<N>,
    Nested<N> {
        IntOrStringBuilder builder;

        ServicePortNestedImpl(IntOrString item) {
            this.builder = new IntOrStringBuilder(this, item);
        }

        ServicePortNestedImpl() {
            this.builder = new IntOrStringBuilder(this);
        }

        @Override
        public N and() {
            return (N)IngressBackendFluentImpl.this.withServicePort(this.builder.build());
        }

        @Override
        public N endServicePort() {
            return this.and();
        }
    }
}

