/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.util;

import io.smallrye.config.SmallRyeConfig;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public final class ContainerRuntimeUtil {
    private static final Logger log = Logger.getLogger(ContainerRuntimeUtil.class);
    private static final String CONTAINER_EXECUTABLE = ConfigProvider.getConfig().unwrap(SmallRyeConfig.class).getOptionalValue("quarkus.native.container-runtime", String.class).orElse(null);
    private static final String CONTAINER_RUNTIME_SYS_PROP = "quarkus-local-container-runtime";

    private ContainerRuntimeUtil() {
    }

    public static ContainerRuntime detectContainerRuntime() {
        return ContainerRuntimeUtil.detectContainerRuntime(true);
    }

    public static ContainerRuntime detectContainerRuntime(boolean required) {
        String podmanVersionOutput;
        boolean podmanAvailable;
        String dockerVersionOutput;
        boolean dockerAvailable;
        ContainerRuntime containerRuntime = ContainerRuntimeUtil.loadContainerRuntimeFromSystemProperty();
        if (containerRuntime != null) {
            return containerRuntime;
        }
        if (CONTAINER_EXECUTABLE != null) {
            if (CONTAINER_EXECUTABLE.trim().equalsIgnoreCase("docker") && (dockerAvailable = (dockerVersionOutput = ContainerRuntimeUtil.getVersionOutputFor(ContainerRuntime.DOCKER)).contains("Docker version"))) {
                ContainerRuntimeUtil.storeContainerRuntimeInSystemProperty(ContainerRuntime.DOCKER);
                return ContainerRuntime.DOCKER;
            }
            if (CONTAINER_EXECUTABLE.trim().equalsIgnoreCase("podman") && (podmanAvailable = (podmanVersionOutput = ContainerRuntimeUtil.getVersionOutputFor(ContainerRuntime.PODMAN)).startsWith("podman version"))) {
                ContainerRuntimeUtil.storeContainerRuntimeInSystemProperty(ContainerRuntime.PODMAN);
                return ContainerRuntime.PODMAN;
            }
            log.warn("quarkus.native.container-runtime config property must be set to either podman or docker and the executable must be available. Ignoring it.");
        }
        if (dockerAvailable = (dockerVersionOutput = ContainerRuntimeUtil.getVersionOutputFor(ContainerRuntime.DOCKER)).contains("Docker version")) {
            if (dockerVersionOutput.startsWith("podman version") || dockerVersionOutput.startsWith("podman.exe version")) {
                ContainerRuntimeUtil.storeContainerRuntimeInSystemProperty(ContainerRuntime.PODMAN);
                return ContainerRuntime.PODMAN;
            }
            ContainerRuntimeUtil.storeContainerRuntimeInSystemProperty(ContainerRuntime.DOCKER);
            return ContainerRuntime.DOCKER;
        }
        podmanVersionOutput = ContainerRuntimeUtil.getVersionOutputFor(ContainerRuntime.PODMAN);
        boolean bl = podmanAvailable = podmanVersionOutput.startsWith("podman version") || podmanVersionOutput.startsWith("podman.exe version");
        if (podmanAvailable) {
            ContainerRuntimeUtil.storeContainerRuntimeInSystemProperty(ContainerRuntime.PODMAN);
            return ContainerRuntime.PODMAN;
        }
        ContainerRuntimeUtil.storeContainerRuntimeInSystemProperty(ContainerRuntime.UNAVAILABLE);
        if (required) {
            throw new IllegalStateException("No container runtime was found. Make sure you have either Docker or Podman installed in your environment.");
        }
        return ContainerRuntime.UNAVAILABLE;
    }

    private static ContainerRuntime loadContainerRuntimeFromSystemProperty() {
        String runtime = System.getProperty(CONTAINER_RUNTIME_SYS_PROP);
        if (runtime == null) {
            return null;
        }
        ContainerRuntime containerRuntime = ContainerRuntime.valueOf(runtime);
        if (containerRuntime == null) {
            log.warnf("System property %s contains an unknown value %s. Ignoring it.", (Object)CONTAINER_RUNTIME_SYS_PROP, (Object)runtime);
        }
        return containerRuntime;
    }

    private static void storeContainerRuntimeInSystemProperty(ContainerRuntime containerRuntime) {
        System.setProperty(CONTAINER_RUNTIME_SYS_PROP, containerRuntime.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getVersionOutputFor(ContainerRuntime containerRuntime) {
        Process versionProcess = null;
        try {
            ProcessBuilder pb = new ProcessBuilder(containerRuntime.getExecutableName(), "--version").redirectErrorStream(true);
            versionProcess = pb.start();
            int timeoutS = 10;
            if (versionProcess.waitFor(10L, TimeUnit.SECONDS)) {
                String string = new String(versionProcess.getInputStream().readAllBytes(), StandardCharsets.UTF_8);
                return string;
            }
            log.debugf("Failure. It took command %s more than %d seconds to execute.", (Object)containerRuntime.getExecutableName(), (Object)10);
            String string = "";
            return string;
        }
        catch (IOException | InterruptedException e) {
            log.debugf((Throwable)e, "Failure to read version output from %s", (Object)containerRuntime.getExecutableName());
            String string = "";
            return string;
        }
        finally {
            if (versionProcess != null) {
                versionProcess.destroy();
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static boolean getRootlessStateFor(ContainerRuntime containerRuntime) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ boolean lambda$getRootlessStateFor$1(String line) {
        return line.trim().equals("rootless: true");
    }

    private static /* synthetic */ boolean lambda$getRootlessStateFor$0(String line) {
        return line.trim().equals("rootless");
    }

    public static enum ContainerRuntime {
        DOCKER,
        PODMAN,
        UNAVAILABLE;

        private Boolean rootless;

        public String getExecutableName() {
            if (this == UNAVAILABLE) {
                throw new IllegalStateException("Cannot get an executable name when no container runtime is available");
            }
            return this.name().toLowerCase();
        }

        public boolean isRootless() {
            if (this.rootless != null) {
                return this.rootless;
            }
            if (this == UNAVAILABLE) {
                throw new IllegalStateException("No container runtime was found. Make sure you have either Docker or Podman installed in your environment.");
            }
            this.rootless = ContainerRuntimeUtil.getRootlessStateFor(this);
            return this.rootless;
        }

        public static ContainerRuntime of(String value) {
            for (ContainerRuntime containerRuntime : ContainerRuntime.values()) {
                if (!containerRuntime.name().equalsIgnoreCase(value)) continue;
                return containerRuntime;
            }
            return null;
        }
    }
}

