/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.runtime.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.netty.buffer.ByteBufInputStream;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.vertx.runtime.jackson.BufferDeserializer;
import io.quarkus.vertx.runtime.jackson.BufferSerializer;
import io.quarkus.vertx.runtime.jackson.ByteArrayDeserializer;
import io.quarkus.vertx.runtime.jackson.ByteArraySerializer;
import io.quarkus.vertx.runtime.jackson.InstantDeserializer;
import io.quarkus.vertx.runtime.jackson.InstantSerializer;
import io.quarkus.vertx.runtime.jackson.JsonArraySerializer;
import io.quarkus.vertx.runtime.jackson.JsonObjectSerializer;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.EncodeException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.json.JsonCodec;
import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.time.Instant;
import java.util.List;
import java.util.Map;

class QuarkusJacksonJsonCodec
implements JsonCodec {
    private static final ObjectMapper mapper;
    private static volatile ObjectMapper prettyMapper;

    QuarkusJacksonJsonCodec() {
    }

    private ObjectMapper prettyMapper() {
        if (prettyMapper == null) {
            prettyMapper = mapper.copy();
            prettyMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        }
        return prettyMapper;
    }

    @Override
    public <T> T fromValue(Object json, Class<T> clazz) {
        Object value = mapper.convertValue(json, clazz);
        if (clazz == Object.class) {
            value = QuarkusJacksonJsonCodec.adapt(value);
        }
        return value;
    }

    @Override
    public <T> T fromString(String str, Class<T> clazz) throws DecodeException {
        return QuarkusJacksonJsonCodec.fromParser(QuarkusJacksonJsonCodec.createParser(str), clazz);
    }

    @Override
    public <T> T fromBuffer(Buffer buf, Class<T> clazz) throws DecodeException {
        return QuarkusJacksonJsonCodec.fromParser(QuarkusJacksonJsonCodec.createParser(buf), clazz);
    }

    public static JsonParser createParser(Buffer buf) {
        try {
            return mapper.getFactory().createParser(new ByteBufInputStream(buf.getByteBuf()));
        }
        catch (IOException e) {
            throw new DecodeException("Failed to decode:" + e.getMessage(), e);
        }
    }

    public static JsonParser createParser(String str) {
        try {
            return mapper.getFactory().createParser(str);
        }
        catch (IOException e) {
            throw new DecodeException("Failed to decode:" + e.getMessage(), e);
        }
    }

    public static <T> T fromParser(JsonParser parser, Class<T> type) throws DecodeException {
        JsonToken remaining;
        Object value;
        try {
            value = mapper.readValue(parser, type);
            remaining = parser.nextToken();
        }
        catch (Exception e) {
            throw new DecodeException("Failed to decode:" + e.getMessage(), e);
        }
        finally {
            QuarkusJacksonJsonCodec.close(parser);
        }
        if (remaining != null) {
            throw new DecodeException("Unexpected trailing token");
        }
        if (type == Object.class) {
            value = QuarkusJacksonJsonCodec.adapt(value);
        }
        return value;
    }

    @Override
    public String toString(Object object, boolean pretty) throws EncodeException {
        try {
            ObjectMapper mapper = pretty ? this.prettyMapper() : QuarkusJacksonJsonCodec.mapper;
            return mapper.writeValueAsString(object);
        }
        catch (Exception e) {
            throw new EncodeException("Failed to encode as JSON: " + e.getMessage(), e);
        }
    }

    @Override
    public Buffer toBuffer(Object object, boolean pretty) throws EncodeException {
        try {
            ObjectMapper mapper = pretty ? this.prettyMapper() : QuarkusJacksonJsonCodec.mapper;
            return Buffer.buffer(mapper.writeValueAsBytes(object));
        }
        catch (Exception e) {
            throw new EncodeException("Failed to encode as JSON: " + e.getMessage(), e);
        }
    }

    private static void close(Closeable parser) {
        try {
            parser.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Object adapt(Object o) {
        try {
            if (o instanceof List) {
                List list = (List)o;
                return new JsonArray(list);
            }
            if (o instanceof Map) {
                Map map = (Map)o;
                return new JsonObject(map);
            }
            return o;
        }
        catch (Exception e) {
            throw new DecodeException("Failed to decode: " + e.getMessage());
        }
    }

    static {
        ArcContainer container = Arc.container();
        if (container == null) {
            mapper = new ObjectMapper();
        } else {
            ObjectMapper managedMapper = container.instance(ObjectMapper.class, new Annotation[0]).get();
            if (managedMapper == null) {
                throw new IllegalStateException("There was no ObjectMapper bean configured");
            }
            mapper = managedMapper.copy();
        }
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        SimpleModule module = new SimpleModule("vertx-module");
        module.addSerializer(JsonObject.class, new JsonObjectSerializer());
        module.addSerializer(JsonArray.class, new JsonArraySerializer());
        module.addSerializer(Instant.class, new InstantSerializer());
        module.addDeserializer(Instant.class, new InstantDeserializer());
        module.addSerializer(byte[].class, new ByteArraySerializer());
        module.addDeserializer(byte[].class, new ByteArrayDeserializer());
        module.addSerializer(Buffer.class, new BufferSerializer());
        module.addDeserializer(Buffer.class, new BufferDeserializer());
        mapper.registerModule(module);
    }
}

