/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigMappingInterface;
import io.smallrye.config.ConfigMappingLoader;
import io.smallrye.config.ConfigMappingObject;
import io.smallrye.config.ConfigValidationException;
import io.smallrye.config.Converters;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.common.utils.StringUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.IntFunction;
import org.eclipse.microprofile.config.spi.Converter;

public final class ConfigMappingContext {
    private final Map<Class<?>, Map<String, Map<Object, Object>>> enclosedThings = new IdentityHashMap();
    private final Map<Class<?>, Map<String, ConfigMappingObject>> roots = new IdentityHashMap();
    private final Map<Class<?>, Map<String, Converter<?>>> convertersByTypeAndField = new IdentityHashMap();
    private final List<Map<Class<?>, Map<String, Converter<?>>>> keyConvertersByDegreeTypeAndField = new ArrayList();
    private final Map<Class<?>, Converter<?>> converterInstances = new IdentityHashMap();
    private final List<ConfigMappingObject> allInstances = new ArrayList<ConfigMappingObject>();
    private final SmallRyeConfig config;
    private final StringBuilder stringBuilder = new StringBuilder();
    private final Set<String> unknownProperties = new HashSet<String>();
    private final List<ConfigValidationException.Problem> problems = new ArrayList<ConfigValidationException.Problem>();
    private ConfigMappingInterface.NamingStrategy namingStrategy = null;

    ConfigMappingContext(SmallRyeConfig config) {
        this.config = config;
    }

    public ConfigMappingObject getRoot(Class<?> rootType, String rootPath) {
        return (ConfigMappingObject)this.roots.getOrDefault(rootType, Collections.emptyMap()).get(rootPath);
    }

    public void registerRoot(Class<?> rootType, String rootPath, ConfigMappingObject root) {
        this.roots.computeIfAbsent(rootType, x -> new HashMap()).put(rootPath, root);
    }

    public Object getEnclosedField(Class<?> enclosingType, String key, Object enclosingObject) {
        return this.enclosedThings.getOrDefault(enclosingType, Collections.emptyMap()).getOrDefault(key, Collections.emptyMap()).get(enclosingObject);
    }

    public void registerEnclosedField(Class<?> enclosingType, String key, Object enclosingObject, Object value) {
        this.enclosedThings.computeIfAbsent(enclosingType, x -> new HashMap()).computeIfAbsent(key, x -> new IdentityHashMap()).put(enclosingObject, value);
    }

    public <T> T constructRoot(Class<T> interfaceType) {
        this.namingStrategy = ConfigMappingInterface.getConfigurationInterface(interfaceType).getNamingStrategy();
        return this.constructGroup(interfaceType);
    }

    public <T> T constructGroup(Class<T> interfaceType) {
        T mappingObject = ConfigMappingLoader.configMappingObject(interfaceType, this);
        this.allInstances.add((ConfigMappingObject)mappingObject);
        return mappingObject;
    }

    public <T> Converter<T> getValueConverter(Class<?> enclosingType, String field) {
        return this.convertersByTypeAndField.computeIfAbsent(enclosingType, x -> new HashMap()).computeIfAbsent(field, x -> {
            ConfigMappingInterface ci = ConfigMappingInterface.getConfigurationInterface(enclosingType);
            ConfigMappingInterface.Property property = ci.getProperty(field);
            return this.getConverter(property);
        });
    }

    private Converter<?> getConverter(ConfigMappingInterface.Property property) {
        boolean optional = property.isOptional();
        if (property.isLeaf() || optional && property.asOptional().getNestedProperty().isLeaf()) {
            ConfigMappingInterface.LeafProperty leafProperty;
            ConfigMappingInterface.LeafProperty leafProperty2 = leafProperty = optional ? property.asOptional().getNestedProperty().asLeaf() : property.asLeaf();
            if (leafProperty.hasConvertWith()) {
                Class<? extends Converter<?>> convertWith = leafProperty.getConvertWith();
                return this.getConverterInstance(convertWith);
            }
            Class<?> valueRawType = leafProperty.getValueRawType();
            if (valueRawType == List.class) {
                return this.config.requireConverter(ConfigMappingInterface.rawTypeOf(ConfigMappingInterface.typeOfParameter(leafProperty.getValueType(), 0)));
            }
            if (valueRawType == Set.class) {
                return this.config.requireConverter(ConfigMappingInterface.rawTypeOf(ConfigMappingInterface.typeOfParameter(leafProperty.getValueType(), 0)));
            }
            return this.config.requireConverter(valueRawType);
        }
        if (property.isPrimitive()) {
            ConfigMappingInterface.PrimitiveProperty primitiveProperty = property.asPrimitive();
            if (primitiveProperty.hasConvertWith()) {
                return this.getConverterInstance(primitiveProperty.getConvertWith());
            }
            return this.config.requireConverter(primitiveProperty.getBoxType());
        }
        if (property.isCollection() || optional && property.asOptional().getNestedProperty().isCollection()) {
            ConfigMappingInterface.CollectionProperty collectionProperty = optional ? property.asOptional().getNestedProperty().asCollection() : property.asCollection();
            return this.getConverter(collectionProperty.getElement());
        }
        throw new IllegalStateException();
    }

    public <T> Converter<T> getKeyConverter(Class<?> enclosingType, String field, int degree) {
        List<Map<Class<?>, Map<String, Converter<?>>>> list = this.keyConvertersByDegreeTypeAndField;
        while (list.size() <= degree) {
            list.add(new IdentityHashMap());
        }
        Map<Class<?>, Map<String, Converter<?>>> map = list.get(degree);
        return map.computeIfAbsent(enclosingType, x -> new HashMap()).computeIfAbsent(field, x -> {
            ConfigMappingInterface.MapProperty mapProperty;
            ConfigMappingInterface ci = ConfigMappingInterface.getConfigurationInterface(enclosingType);
            ConfigMappingInterface.Property property = ci.getProperty(field);
            if (property.isMap()) {
                mapProperty = property.asMap();
            } else if (property.isCollection()) {
                mapProperty = property.asCollection().getElement().asMap();
            } else {
                throw new IllegalStateException();
            }
            while (degree + 1 < mapProperty.getLevels()) {
                mapProperty = mapProperty.getValueProperty().asMap();
            }
            if (mapProperty.hasKeyConvertWith()) {
                return this.getConverterInstance(mapProperty.getKeyConvertWith());
            }
            Class<?> valueRawType = mapProperty.getKeyRawType();
            if (valueRawType == List.class) {
                return Converters.newCollectionConverter(this.config.requireConverter(ConfigMappingInterface.rawTypeOf(ConfigMappingInterface.typeOfParameter(mapProperty.getKeyType(), 0))), ArrayList::new);
            }
            if (valueRawType == Set.class) {
                return Converters.newCollectionConverter(this.config.requireConverter(ConfigMappingInterface.rawTypeOf(ConfigMappingInterface.typeOfParameter(mapProperty.getKeyType(), 0))), HashSet::new);
            }
            return this.config.requireConverter(valueRawType);
        });
    }

    public <T> Converter<T> getConverterInstance(Class<? extends Converter<? extends T>> converterType) {
        return this.converterInstances.computeIfAbsent(converterType, t -> {
            try {
                return (Converter)t.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (InstantiationException e) {
                throw new InstantiationError(e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new IllegalAccessError(e.getMessage());
            }
            catch (InvocationTargetException e) {
                try {
                    throw e.getCause();
                }
                catch (Error | RuntimeException e2) {
                    throw e2;
                }
                catch (Throwable t2) {
                    throw new UndeclaredThrowableException(t2);
                }
            }
            catch (NoSuchMethodException e) {
                throw new NoSuchMethodError(e.getMessage());
            }
        });
    }

    void applyNamingStrategy(ConfigMappingInterface.NamingStrategy namingStrategy) {
        if (!namingStrategy.isDefault()) {
            this.namingStrategy = namingStrategy;
        }
    }

    public String applyNamingStrategy(String name) {
        return (String)this.namingStrategy.apply(name);
    }

    public static IntFunction<Collection<?>> createCollectionFactory(Class<?> type) {
        if (type == List.class) {
            return ArrayList::new;
        }
        if (type == Set.class) {
            return HashSet::new;
        }
        throw new IllegalArgumentException();
    }

    public NoSuchElementException noSuchElement(Class<?> type) {
        return new NoSuchElementException("A required configuration group of type " + type.getName() + " was not provided");
    }

    void unknownProperty(String unknownProperty) {
        this.unknownProperties.add(unknownProperty);
    }

    void validateUnknown(boolean validateUnknown) {
        HashSet<String> usedProperties = new HashSet<String>();
        for (String property : this.config.getPropertyNames()) {
            if (this.unknownProperties.contains(property)) continue;
            usedProperties.add(StringUtil.replaceNonAlphanumericByUnderscores(property));
        }
        usedProperties.removeAll(this.unknownProperties);
        for (String property : this.unknownProperties) {
            boolean found = false;
            String envProperty = StringUtil.replaceNonAlphanumericByUnderscores(property);
            for (String usedProperty : usedProperties) {
                if (!usedProperty.equalsIgnoreCase(envProperty)) continue;
                found = true;
                break;
            }
            if (found || !validateUnknown) continue;
            this.problems.add(new ConfigValidationException.Problem(property + " does not map to any root"));
        }
    }

    void fillInOptionals() {
        for (ConfigMappingObject instance : this.allInstances) {
            instance.fillInOptionals(this);
        }
    }

    public SmallRyeConfig getConfig() {
        return this.config;
    }

    public StringBuilder getStringBuilder() {
        return this.stringBuilder;
    }

    public void reportProblem(RuntimeException problem) {
        this.problems.add(new ConfigValidationException.Problem(problem.toString()));
    }

    List<ConfigValidationException.Problem> getProblems() {
        return this.problems;
    }

    Map<Class<?>, Map<String, ConfigMappingObject>> getRootsMap() {
        return this.roots;
    }
}

