/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.vertx.codegen.methods;

import io.smallrye.mutiny.vertx.ReadStreamSubscriber;
import io.smallrye.mutiny.vertx.codegen.lang.CodeGenHelper;
import io.smallrye.mutiny.vertx.codegen.methods.MutinyMethodDescriptor;
import io.smallrye.mutiny.vertx.codegen.methods.MutinyMethodGenerator;
import io.vertx.codegen.ClassModel;
import io.vertx.codegen.Helper;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.PrimitiveTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;

public class SimpleMethodGenerator
extends MutinyMethodGenerator {
    private final List<String> cacheDecls;
    private final Map<MethodInfo, Map<TypeInfo, String>> methodTypeArgMap;

    public SimpleMethodGenerator(PrintWriter writer, List<String> cacheDecls, Map<MethodInfo, Map<TypeInfo, String>> methodTypeArgMap) {
        super(writer);
        this.cacheDecls = cacheDecls;
        this.methodTypeArgMap = methodTypeArgMap;
    }

    public void generateDeclaration(MethodInfo method) {
        MutinyMethodDescriptor consumerMethod = this.computeMethodInfoOther(method);
        this.generateJavadoc(consumerMethod);
        this.generateMethodDeclaration(consumerMethod);
        this.writer.println(";");
        this.writer.println();
    }

    public void generate(ClassModel model, MethodInfo method) {
        MutinyMethodDescriptor simpleMethod = this.computeMethodInfo(method);
        this.generateJavadoc(simpleMethod);
        this.generateMethodDeclaration(simpleMethod);
        this.generateBody(model, simpleMethod);
        this.writer.println();
    }

    private void generateBody(ClassModel model, MutinyMethodDescriptor descriptor) {
        this.writer.println(" { ");
        MethodInfo original = descriptor.getOriginalMethod();
        if (descriptor.isFluent()) {
            this.writer.print("    ");
            this.writer.print(this.genInvokeDelegate(model, original));
            this.writer.println(";");
            if (original.getReturnType().isVariable()) {
                this.writer.print("    return (");
                this.writer.print(original.getReturnType().getName());
                this.writer.println(") this;");
            } else {
                this.writer.println("    return this;");
            }
        } else if (original.getReturnType().getName().equals("void")) {
            this.writer.print("    ");
            this.writer.print(this.genInvokeDelegate(model, original));
            this.writer.println(";");
        } else {
            if (original.isCacheReturn()) {
                this.writer.print("    if (cached_");
                this.writer.print(this.cacheDecls.size());
                this.writer.println(" != null) {");
                this.writer.print("      return cached_");
                this.writer.print(this.cacheDecls.size());
                this.writer.println(";");
                this.writer.println("    }");
            }
            TypeInfo returnType = original.getReturnType();
            String cachedType = original.getReturnType().getKind() == ClassKind.PRIMITIVE ? ((PrimitiveTypeInfo)returnType).getBoxed().getName() : CodeGenHelper.genTranslatedTypeName(returnType);
            this.writer.print("    ");
            this.writer.print(CodeGenHelper.genTranslatedTypeName(returnType));
            this.writer.print(" ret = ");
            this.writer.print(CodeGenHelper.genConvReturn(this.methodTypeArgMap, returnType, original, this.genInvokeDelegate(model, original)));
            this.writer.println(";");
            if (original.isCacheReturn()) {
                this.writer.print("    cached_");
                this.writer.print(this.cacheDecls.size());
                this.writer.println(" = ret;");
                this.cacheDecls.add("private" + (original.isStaticMethod() ? " static" : "") + " " + cachedType + " cached_" + this.cacheDecls.size());
            }
            this.writer.println("    return ret;");
        }
        this.writer.println("  }");
    }

    private MutinyMethodDescriptor computeMethodInfo(MethodInfo method) {
        return new MutinyMethodDescriptor(method.copy().setName("__" + method.getName()), method, MutinyMethodDescriptor.MutinyKind.SIMPLE, method.isFluent(), true);
    }

    private MutinyMethodDescriptor computeMethodInfoOther(MethodInfo method) {
        return new MutinyMethodDescriptor(method.copy(), method, MutinyMethodDescriptor.MutinyKind.SIMPLE, method.isFluent());
    }

    public String genInvokeDelegate(ClassModel model, MethodInfo method) {
        StringBuilder ret = method.isStaticMethod() ? new StringBuilder(Helper.getNonGenericType(model.getIfaceFQCN())) : new StringBuilder("delegate");
        ret.append(".").append(method.getName()).append("(");
        int index = 0;
        for (ParamInfo param : method.getParams()) {
            TypeInfo type;
            if (index > 0) {
                ret.append(", ");
            }
            if ((type = param.getType()).isParameterized() && type.getRaw().getName().equals("org.reactivestreams.Publisher")) {
                ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)type;
                String adapterFunction = parameterizedType.getArg(0).isVariable() ? "java.util.function.Function.identity()" : "obj -> (" + parameterizedType.getArg(0).getRaw().getName() + ")obj.getDelegate()";
                ret.append(ReadStreamSubscriber.class.getName()).append(".asReadStream(").append(param.getName()).append(",").append(adapterFunction).append(").resume()");
            } else {
                ret.append(CodeGenHelper.genConvParam(this.methodTypeArgMap, type, method, param.getName()));
            }
            ++index;
        }
        ret.append(")");
        return ret.toString();
    }

    public void generateOther(ClassModel model, MethodInfo method) {
        MutinyMethodDescriptor simpleMethod = this.computeMethodInfoOther(method);
        this.generateJavadoc(simpleMethod);
        this.generateMethodDeclaration(simpleMethod);
        this.generateBody(model, simpleMethod);
        this.writer.println();
    }
}

