/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.CSPHandler;
import io.vertx.ext.web.handler.HttpException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CSPHandlerImpl
implements CSPHandler {
    private static final List<String> MUST_BE_QUOTED = Arrays.asList("none", "self", "unsafe-inline", "unsafe-eval");
    private final Map<String, String> policy = new LinkedHashMap<String, String>();
    private String policyString;
    private boolean reportOnly;

    public CSPHandlerImpl() {
        this.addDirective("default-src", "self");
    }

    @Override
    public synchronized CSPHandler setDirective(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (value == null) {
            this.policy.remove(name);
        }
        if (MUST_BE_QUOTED.contains(value)) {
            value = "'" + value + "'";
        }
        this.policy.put(name, value);
        this.policyString = null;
        return this;
    }

    @Override
    public CSPHandler addDirective(String name, String value) {
        String previous;
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (value == null) {
            this.policy.remove(name);
        }
        if (MUST_BE_QUOTED.contains(value)) {
            value = "'" + value + "'";
        }
        if ((previous = this.policy.get(name)) == null || "".equals(previous)) {
            this.policy.put(name, value);
        } else {
            this.policy.put(name, previous + " " + value);
        }
        this.policyString = null;
        return this;
    }

    @Override
    public CSPHandler setReportOnly(boolean reportOnly) {
        this.reportOnly = reportOnly;
        return this;
    }

    private String getPolicyString() {
        if (this.policyString == null) {
            StringBuilder buffer = new StringBuilder();
            for (Map.Entry<String, String> entry : this.policy.entrySet()) {
                if (buffer.length() > 0) {
                    buffer.append("; ");
                }
                buffer.append(entry.getKey()).append(' ').append(entry.getValue());
            }
            this.policyString = buffer.toString();
        }
        return this.policyString;
    }

    @Override
    public void handle(RoutingContext ctx) {
        String policyString = this.getPolicyString();
        if (this.reportOnly) {
            if (!this.policy.containsKey("report-uri")) {
                ctx.fail(new HttpException(500, "Please disable CSP reportOnly or add a report-uri policy."));
            } else {
                ctx.response().putHeader("Content-Security-Policy-Report-Only", policyString);
                ctx.next();
            }
        } else {
            ctx.response().putHeader("Content-Security-Policy", policyString);
            ctx.next();
        }
    }
}

