/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core.net;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.DelegatingHandler;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.mutiny.core.metrics.Measured;
import io.vertx.mutiny.core.net.NetSocket;
import io.vertx.mutiny.core.net.SocketAddress;

@MutinyGen(value=io.vertx.core.net.NetClient.class)
public class NetClient
implements Measured {
    public static final TypeArg<NetClient> __TYPE_ARG = new TypeArg<NetClient>(obj -> new NetClient((io.vertx.core.net.NetClient)obj), NetClient::getDelegate);
    private final io.vertx.core.net.NetClient delegate;

    public NetClient(io.vertx.core.net.NetClient delegate) {
        this.delegate = delegate;
    }

    public NetClient(Object delegate) {
        this.delegate = (io.vertx.core.net.NetClient)delegate;
    }

    NetClient() {
        this.delegate = null;
    }

    @Override
    public io.vertx.core.net.NetClient getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetClient that = (NetClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    @CheckReturnValue
    public Uni<NetSocket> connect(int port, String host) {
        return AsyncResultUni.toUni(connectHandler -> this.delegate.connect(port, host, new DelegatingHandler<AsyncResult, AsyncResult>((Handler<AsyncResult>)connectHandler, ar -> ar.map(event -> NetSocket.newInstance(event)))));
    }

    public NetSocket connectAndAwait(int port, String host) {
        return this.connect(port, host).await().indefinitely();
    }

    @Fluent
    public NetClient connectAndForget(int port, String host) {
        this.connect(port, host).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<NetSocket> connect(int port, String host, String serverName) {
        return AsyncResultUni.toUni(connectHandler -> this.delegate.connect(port, host, serverName, new DelegatingHandler<AsyncResult, AsyncResult>((Handler<AsyncResult>)connectHandler, ar -> ar.map(event -> NetSocket.newInstance(event)))));
    }

    public NetSocket connectAndAwait(int port, String host, String serverName) {
        return this.connect(port, host, serverName).await().indefinitely();
    }

    @Fluent
    public NetClient connectAndForget(int port, String host, String serverName) {
        this.connect(port, host, serverName).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<NetSocket> connect(SocketAddress remoteAddress) {
        return AsyncResultUni.toUni(connectHandler -> this.delegate.connect(remoteAddress.getDelegate(), new DelegatingHandler<AsyncResult, AsyncResult>((Handler<AsyncResult>)connectHandler, ar -> ar.map(event -> NetSocket.newInstance(event)))));
    }

    public NetSocket connectAndAwait(SocketAddress remoteAddress) {
        return this.connect(remoteAddress).await().indefinitely();
    }

    @Fluent
    public NetClient connectAndForget(SocketAddress remoteAddress) {
        this.connect(remoteAddress).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<NetSocket> connect(SocketAddress remoteAddress, String serverName) {
        return AsyncResultUni.toUni(connectHandler -> this.delegate.connect(remoteAddress.getDelegate(), serverName, new DelegatingHandler<AsyncResult, AsyncResult>((Handler<AsyncResult>)connectHandler, ar -> ar.map(event -> NetSocket.newInstance(event)))));
    }

    public NetSocket connectAndAwait(SocketAddress remoteAddress, String serverName) {
        return this.connect(remoteAddress, serverName).await().indefinitely();
    }

    @Fluent
    public NetClient connectAndForget(SocketAddress remoteAddress, String serverName) {
        this.connect(remoteAddress, serverName).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> close() {
        return AsyncResultUni.toUni(handler -> this.delegate.close((Handler<AsyncResult<Void>>)handler));
    }

    public Void closeAndAwait() {
        return this.close().await().indefinitely();
    }

    public void closeAndForget() {
        this.close().subscribe().with(UniHelper.NOOP);
    }

    public static NetClient newInstance(io.vertx.core.net.NetClient arg) {
        return arg != null ? new NetClient(arg) : null;
    }
}

