/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class LeaderAndIsrRequestData
implements ApiMessage {
    int controllerId;
    int controllerEpoch;
    long brokerEpoch;
    byte type;
    List<LeaderAndIsrPartitionState> ungroupedPartitionStates;
    List<LeaderAndIsrTopicState> topicStates;
    List<LeaderAndIsrLiveLeader> liveLeaders;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("controller_id", Type.INT32, "The current controller ID."), new Field("controller_epoch", Type.INT32, "The current controller epoch."), new Field("ungrouped_partition_states", new ArrayOf(LeaderAndIsrPartitionState.SCHEMA_0), "The state of each partition, in a v0 or v1 message."), new Field("live_leaders", new ArrayOf(LeaderAndIsrLiveLeader.SCHEMA_0), "The current live leaders."));
    public static final Schema SCHEMA_1 = new Schema(new Field("controller_id", Type.INT32, "The current controller ID."), new Field("controller_epoch", Type.INT32, "The current controller epoch."), new Field("ungrouped_partition_states", new ArrayOf(LeaderAndIsrPartitionState.SCHEMA_1), "The state of each partition, in a v0 or v1 message."), new Field("live_leaders", new ArrayOf(LeaderAndIsrLiveLeader.SCHEMA_0), "The current live leaders."));
    public static final Schema SCHEMA_2 = new Schema(new Field("controller_id", Type.INT32, "The current controller ID."), new Field("controller_epoch", Type.INT32, "The current controller epoch."), new Field("broker_epoch", Type.INT64, "The current broker epoch."), new Field("topic_states", new ArrayOf(LeaderAndIsrTopicState.SCHEMA_2), "Each topic."), new Field("live_leaders", new ArrayOf(LeaderAndIsrLiveLeader.SCHEMA_0), "The current live leaders."));
    public static final Schema SCHEMA_3 = new Schema(new Field("controller_id", Type.INT32, "The current controller ID."), new Field("controller_epoch", Type.INT32, "The current controller epoch."), new Field("broker_epoch", Type.INT64, "The current broker epoch."), new Field("topic_states", new ArrayOf(LeaderAndIsrTopicState.SCHEMA_3), "Each topic."), new Field("live_leaders", new ArrayOf(LeaderAndIsrLiveLeader.SCHEMA_0), "The current live leaders."));
    public static final Schema SCHEMA_4 = new Schema(new Field("controller_id", Type.INT32, "The current controller ID."), new Field("controller_epoch", Type.INT32, "The current controller epoch."), new Field("broker_epoch", Type.INT64, "The current broker epoch."), new Field("topic_states", new CompactArrayOf(LeaderAndIsrTopicState.SCHEMA_4), "Each topic."), new Field("live_leaders", new CompactArrayOf(LeaderAndIsrLiveLeader.SCHEMA_4), "The current live leaders."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema SCHEMA_5 = new Schema(new Field("controller_id", Type.INT32, "The current controller ID."), new Field("controller_epoch", Type.INT32, "The current controller epoch."), new Field("broker_epoch", Type.INT64, "The current broker epoch."), new Field("type", Type.INT8, "The type that indicates whether all topics are included in the request"), new Field("topic_states", new CompactArrayOf(LeaderAndIsrTopicState.SCHEMA_5), "Each topic."), new Field("live_leaders", new CompactArrayOf(LeaderAndIsrLiveLeader.SCHEMA_4), "The current live leaders."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema SCHEMA_6 = new Schema(new Field("controller_id", Type.INT32, "The current controller ID."), new Field("controller_epoch", Type.INT32, "The current controller epoch."), new Field("broker_epoch", Type.INT64, "The current broker epoch."), new Field("type", Type.INT8, "The type that indicates whether all topics are included in the request"), new Field("topic_states", new CompactArrayOf(LeaderAndIsrTopicState.SCHEMA_6), "Each topic."), new Field("live_leaders", new CompactArrayOf(LeaderAndIsrLiveLeader.SCHEMA_4), "The current live leaders."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 6;

    public LeaderAndIsrRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public LeaderAndIsrRequestData() {
        this.controllerId = 0;
        this.controllerEpoch = 0;
        this.brokerEpoch = -1L;
        this.type = 0;
        this.ungroupedPartitionStates = new ArrayList<LeaderAndIsrPartitionState>(0);
        this.topicStates = new ArrayList<LeaderAndIsrTopicState>(0);
        this.liveLeaders = new ArrayList<LeaderAndIsrLiveLeader>(0);
    }

    @Override
    public short apiKey() {
        return 4;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 6;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int i;
        ArrayList<LeaderAndIsrPartitionState> newCollection;
        int arrayLength;
        this.controllerId = _readable.readInt();
        this.controllerEpoch = _readable.readInt();
        this.brokerEpoch = _version >= 2 ? _readable.readLong() : -1L;
        this.type = _version >= 5 ? _readable.readByte() : (byte)0;
        if (_version <= 1) {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field ungroupedPartitionStates was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList<LeaderAndIsrPartitionState>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new LeaderAndIsrPartitionState(_readable, _version));
            }
            this.ungroupedPartitionStates = newCollection;
        } else {
            this.ungroupedPartitionStates = new ArrayList<LeaderAndIsrPartitionState>(0);
        }
        if (_version >= 2) {
            if (_version >= 4) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field topicStates was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add((LeaderAndIsrPartitionState)((Object)new LeaderAndIsrTopicState(_readable, _version)));
                }
                this.topicStates = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field topicStates was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add((LeaderAndIsrPartitionState)((Object)new LeaderAndIsrTopicState(_readable, _version)));
                }
                this.topicStates = newCollection;
            }
        } else {
            this.topicStates = new ArrayList<LeaderAndIsrTopicState>(0);
        }
        if (_version >= 4) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field liveLeaders was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((LeaderAndIsrPartitionState)((Object)new LeaderAndIsrLiveLeader(_readable, _version)));
            }
            this.liveLeaders = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field liveLeaders was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((LeaderAndIsrPartitionState)((Object)new LeaderAndIsrLiveLeader(_readable, _version)));
            }
            this.liveLeaders = newCollection;
        }
        this._unknownTaggedFields = null;
        if (_version >= 4) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.controllerId);
        _writable.writeInt(this.controllerEpoch);
        if (_version >= 2) {
            _writable.writeLong(this.brokerEpoch);
        }
        if (_version >= 5) {
            _writable.writeByte(this.type);
        } else if (this.type != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default type at version " + _version);
        }
        if (_version <= 1) {
            _writable.writeInt(this.ungroupedPartitionStates.size());
            for (LeaderAndIsrPartitionState ungroupedPartitionStatesElement : this.ungroupedPartitionStates) {
                ungroupedPartitionStatesElement.write(_writable, _cache, _version);
            }
        } else if (!this.ungroupedPartitionStates.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default ungroupedPartitionStates at version " + _version);
        }
        if (_version >= 2) {
            if (_version >= 4) {
                _writable.writeUnsignedVarint(this.topicStates.size() + 1);
                for (LeaderAndIsrTopicState topicStatesElement : this.topicStates) {
                    topicStatesElement.write(_writable, _cache, _version);
                }
            } else {
                _writable.writeInt(this.topicStates.size());
                for (LeaderAndIsrTopicState topicStatesElement : this.topicStates) {
                    topicStatesElement.write(_writable, _cache, _version);
                }
            }
        } else if (!this.topicStates.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default topicStates at version " + _version);
        }
        if (_version >= 4) {
            _writable.writeUnsignedVarint(this.liveLeaders.size() + 1);
            for (LeaderAndIsrLiveLeader liveLeadersElement : this.liveLeaders) {
                liveLeadersElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.liveLeaders.size());
            for (LeaderAndIsrLiveLeader liveLeadersElement : this.liveLeaders) {
                liveLeadersElement.write(_writable, _cache, _version);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 4) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(4);
        if (_version >= 2) {
            _size.addBytes(8);
        }
        if (_version >= 5) {
            _size.addBytes(1);
        }
        if (_version <= 1) {
            _size.addBytes(4);
            for (LeaderAndIsrPartitionState ungroupedPartitionStatesElement : this.ungroupedPartitionStates) {
                ungroupedPartitionStatesElement.addSize(_size, _cache, _version);
            }
        }
        if (_version >= 2) {
            if (_version >= 4) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topicStates.size() + 1));
            } else {
                _size.addBytes(4);
            }
            for (LeaderAndIsrTopicState topicStatesElement : this.topicStates) {
                topicStatesElement.addSize(_size, _cache, _version);
            }
        }
        if (_version >= 4) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.liveLeaders.size() + 1));
        } else {
            _size.addBytes(4);
        }
        for (LeaderAndIsrLiveLeader liveLeadersElement : this.liveLeaders) {
            liveLeadersElement.addSize(_size, _cache, _version);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 4) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LeaderAndIsrRequestData)) {
            return false;
        }
        LeaderAndIsrRequestData other = (LeaderAndIsrRequestData)obj;
        if (this.controllerId != other.controllerId) {
            return false;
        }
        if (this.controllerEpoch != other.controllerEpoch) {
            return false;
        }
        if (this.brokerEpoch != other.brokerEpoch) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        if (this.ungroupedPartitionStates == null ? other.ungroupedPartitionStates != null : !this.ungroupedPartitionStates.equals(other.ungroupedPartitionStates)) {
            return false;
        }
        if (this.topicStates == null ? other.topicStates != null : !this.topicStates.equals(other.topicStates)) {
            return false;
        }
        if (this.liveLeaders == null ? other.liveLeaders != null : !this.liveLeaders.equals(other.liveLeaders)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.controllerId;
        hashCode = 31 * hashCode + this.controllerEpoch;
        hashCode = 31 * hashCode + ((int)(this.brokerEpoch >> 32) ^ (int)this.brokerEpoch);
        hashCode = 31 * hashCode + this.type;
        hashCode = 31 * hashCode + (this.ungroupedPartitionStates == null ? 0 : this.ungroupedPartitionStates.hashCode());
        hashCode = 31 * hashCode + (this.topicStates == null ? 0 : this.topicStates.hashCode());
        hashCode = 31 * hashCode + (this.liveLeaders == null ? 0 : this.liveLeaders.hashCode());
        return hashCode;
    }

    @Override
    public LeaderAndIsrRequestData duplicate() {
        LeaderAndIsrRequestData _duplicate = new LeaderAndIsrRequestData();
        _duplicate.controllerId = this.controllerId;
        _duplicate.controllerEpoch = this.controllerEpoch;
        _duplicate.brokerEpoch = this.brokerEpoch;
        _duplicate.type = this.type;
        ArrayList<LeaderAndIsrPartitionState> newUngroupedPartitionStates = new ArrayList<LeaderAndIsrPartitionState>(this.ungroupedPartitionStates.size());
        for (LeaderAndIsrPartitionState leaderAndIsrPartitionState : this.ungroupedPartitionStates) {
            newUngroupedPartitionStates.add(leaderAndIsrPartitionState.duplicate());
        }
        _duplicate.ungroupedPartitionStates = newUngroupedPartitionStates;
        ArrayList<LeaderAndIsrTopicState> newTopicStates = new ArrayList<LeaderAndIsrTopicState>(this.topicStates.size());
        for (LeaderAndIsrTopicState _element : this.topicStates) {
            newTopicStates.add(_element.duplicate());
        }
        _duplicate.topicStates = newTopicStates;
        ArrayList<LeaderAndIsrLiveLeader> arrayList = new ArrayList<LeaderAndIsrLiveLeader>(this.liveLeaders.size());
        for (LeaderAndIsrLiveLeader _element : this.liveLeaders) {
            arrayList.add(_element.duplicate());
        }
        _duplicate.liveLeaders = arrayList;
        return _duplicate;
    }

    public String toString() {
        return "LeaderAndIsrRequestData(controllerId=" + this.controllerId + ", controllerEpoch=" + this.controllerEpoch + ", brokerEpoch=" + this.brokerEpoch + ", type=" + this.type + ", ungroupedPartitionStates=" + MessageUtil.deepToString(this.ungroupedPartitionStates.iterator()) + ", topicStates=" + MessageUtil.deepToString(this.topicStates.iterator()) + ", liveLeaders=" + MessageUtil.deepToString(this.liveLeaders.iterator()) + ")";
    }

    public int controllerId() {
        return this.controllerId;
    }

    public int controllerEpoch() {
        return this.controllerEpoch;
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    public byte type() {
        return this.type;
    }

    public List<LeaderAndIsrPartitionState> ungroupedPartitionStates() {
        return this.ungroupedPartitionStates;
    }

    public List<LeaderAndIsrTopicState> topicStates() {
        return this.topicStates;
    }

    public List<LeaderAndIsrLiveLeader> liveLeaders() {
        return this.liveLeaders;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public LeaderAndIsrRequestData setControllerId(int v) {
        this.controllerId = v;
        return this;
    }

    public LeaderAndIsrRequestData setControllerEpoch(int v) {
        this.controllerEpoch = v;
        return this;
    }

    public LeaderAndIsrRequestData setBrokerEpoch(long v) {
        this.brokerEpoch = v;
        return this;
    }

    public LeaderAndIsrRequestData setType(byte v) {
        this.type = v;
        return this;
    }

    public LeaderAndIsrRequestData setUngroupedPartitionStates(List<LeaderAndIsrPartitionState> v) {
        this.ungroupedPartitionStates = v;
        return this;
    }

    public LeaderAndIsrRequestData setTopicStates(List<LeaderAndIsrTopicState> v) {
        this.topicStates = v;
        return this;
    }

    public LeaderAndIsrRequestData setLiveLeaders(List<LeaderAndIsrLiveLeader> v) {
        this.liveLeaders = v;
        return this;
    }

    public static class LeaderAndIsrPartitionState
    implements Message {
        String topicName;
        int partitionIndex;
        int controllerEpoch;
        int leader;
        int leaderEpoch;
        List<Integer> isr;
        int partitionEpoch;
        List<Integer> replicas;
        List<Integer> addingReplicas;
        List<Integer> removingReplicas;
        boolean isNew;
        byte leaderRecoveryState;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("topic_name", Type.STRING, "The topic name.  This is only present in v0 or v1."), new Field("partition_index", Type.INT32, "The partition index."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("leader", Type.INT32, "The broker ID of the leader."), new Field("leader_epoch", Type.INT32, "The leader epoch."), new Field("isr", new ArrayOf(Type.INT32), "The in-sync replica IDs."), new Field("partition_epoch", Type.INT32, "The current epoch for the partition. The epoch is a monotonically increasing value which is incremented after every partition change. (Since the LeaderAndIsr request is only used by the legacy controller, this corresponds to the zkVersion)"), new Field("replicas", new ArrayOf(Type.INT32), "The replica IDs."));
        public static final Schema SCHEMA_1 = new Schema(new Field("topic_name", Type.STRING, "The topic name.  This is only present in v0 or v1."), new Field("partition_index", Type.INT32, "The partition index."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("leader", Type.INT32, "The broker ID of the leader."), new Field("leader_epoch", Type.INT32, "The leader epoch."), new Field("isr", new ArrayOf(Type.INT32), "The in-sync replica IDs."), new Field("partition_epoch", Type.INT32, "The current epoch for the partition. The epoch is a monotonically increasing value which is incremented after every partition change. (Since the LeaderAndIsr request is only used by the legacy controller, this corresponds to the zkVersion)"), new Field("replicas", new ArrayOf(Type.INT32), "The replica IDs."), new Field("is_new", Type.BOOLEAN, "Whether the replica should have existed on the broker or not."));
        public static final Schema SCHEMA_2 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("leader", Type.INT32, "The broker ID of the leader."), new Field("leader_epoch", Type.INT32, "The leader epoch."), new Field("isr", new ArrayOf(Type.INT32), "The in-sync replica IDs."), new Field("partition_epoch", Type.INT32, "The current epoch for the partition. The epoch is a monotonically increasing value which is incremented after every partition change. (Since the LeaderAndIsr request is only used by the legacy controller, this corresponds to the zkVersion)"), new Field("replicas", new ArrayOf(Type.INT32), "The replica IDs."), new Field("is_new", Type.BOOLEAN, "Whether the replica should have existed on the broker or not."));
        public static final Schema SCHEMA_3 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("leader", Type.INT32, "The broker ID of the leader."), new Field("leader_epoch", Type.INT32, "The leader epoch."), new Field("isr", new ArrayOf(Type.INT32), "The in-sync replica IDs."), new Field("partition_epoch", Type.INT32, "The current epoch for the partition. The epoch is a monotonically increasing value which is incremented after every partition change. (Since the LeaderAndIsr request is only used by the legacy controller, this corresponds to the zkVersion)"), new Field("replicas", new ArrayOf(Type.INT32), "The replica IDs."), new Field("adding_replicas", new ArrayOf(Type.INT32), "The replica IDs that we are adding this partition to, or null if no replicas are being added."), new Field("removing_replicas", new ArrayOf(Type.INT32), "The replica IDs that we are removing this partition from, or null if no replicas are being removed."), new Field("is_new", Type.BOOLEAN, "Whether the replica should have existed on the broker or not."));
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 6;

        public LeaderAndIsrPartitionState(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public LeaderAndIsrPartitionState() {
            this.topicName = "";
            this.partitionIndex = 0;
            this.controllerEpoch = 0;
            this.leader = 0;
            this.leaderEpoch = 0;
            this.isr = new ArrayList<Integer>(0);
            this.partitionEpoch = 0;
            this.replicas = new ArrayList<Integer>(0);
            this.addingReplicas = new ArrayList<Integer>(0);
            this.removingReplicas = new ArrayList<Integer>(0);
            this.isNew = false;
            this.leaderRecoveryState = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        @Override
        public void read(Readable _readable, short _version) {
            int i;
            if (_version <= 1) {
                short length = _readable.readShort();
                if (length < 0) {
                    throw new RuntimeException("non-nullable field topicName was serialized as null");
                }
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field topicName had invalid length " + length);
                }
                this.topicName = _readable.readString(length);
            } else {
                this.topicName = "";
            }
            this.partitionIndex = _readable.readInt();
            this.controllerEpoch = _readable.readInt();
            this.leader = _readable.readInt();
            this.leaderEpoch = _readable.readInt();
            int arrayLength = _version >= 4 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field isr was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.isr = newCollection;
            this.partitionEpoch = _readable.readInt();
            arrayLength = _version >= 4 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field replicas was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.replicas = newCollection;
            if (_version >= 3) {
                arrayLength = _version >= 4 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field addingReplicas was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(_readable.readInt());
                }
                this.addingReplicas = newCollection;
            } else {
                this.addingReplicas = new ArrayList<Integer>(0);
            }
            if (_version >= 3) {
                arrayLength = _version >= 4 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field removingReplicas was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(_readable.readInt());
                }
                this.removingReplicas = newCollection;
            } else {
                this.removingReplicas = new ArrayList<Integer>(0);
            }
            this.isNew = _version >= 1 ? _readable.readByte() != 0 : false;
            this.leaderRecoveryState = _version >= 6 ? _readable.readByte() : (byte)0;
            this._unknownTaggedFields = null;
            if (_version >= 4) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            Object _stringBytes;
            int _numTaggedFields = 0;
            if (_version <= 1) {
                _stringBytes = _cache.getSerializedValue(this.topicName);
                _writable.writeShort((short)((byte[])_stringBytes).length);
                _writable.writeByteArray((byte[])_stringBytes);
            }
            _writable.writeInt(this.partitionIndex);
            _writable.writeInt(this.controllerEpoch);
            _writable.writeInt(this.leader);
            _writable.writeInt(this.leaderEpoch);
            if (_version >= 4) {
                _writable.writeUnsignedVarint(this.isr.size() + 1);
            } else {
                _writable.writeInt(this.isr.size());
            }
            _stringBytes = this.isr.iterator();
            while (_stringBytes.hasNext()) {
                Integer isrElement = (Integer)_stringBytes.next();
                _writable.writeInt(isrElement);
            }
            _writable.writeInt(this.partitionEpoch);
            if (_version >= 4) {
                _writable.writeUnsignedVarint(this.replicas.size() + 1);
            } else {
                _writable.writeInt(this.replicas.size());
            }
            for (Integer replicasElement : this.replicas) {
                _writable.writeInt(replicasElement);
            }
            if (_version >= 3) {
                if (_version >= 4) {
                    _writable.writeUnsignedVarint(this.addingReplicas.size() + 1);
                } else {
                    _writable.writeInt(this.addingReplicas.size());
                }
                for (Integer addingReplicasElement : this.addingReplicas) {
                    _writable.writeInt(addingReplicasElement);
                }
            }
            if (_version >= 3) {
                if (_version >= 4) {
                    _writable.writeUnsignedVarint(this.removingReplicas.size() + 1);
                } else {
                    _writable.writeInt(this.removingReplicas.size());
                }
                for (Integer removingReplicasElement : this.removingReplicas) {
                    _writable.writeInt(removingReplicasElement);
                }
            }
            if (_version >= 1) {
                _writable.writeByte(this.isNew ? (byte)1 : 0);
            }
            if (_version >= 6) {
                _writable.writeByte(this.leaderRecoveryState);
            } else if (this.leaderRecoveryState != 0) {
                throw new UnsupportedVersionException("Attempted to write a non-default leaderRecoveryState at version " + _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 4) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version <= 1) {
                byte[] _stringBytes = this.topicName.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'topicName' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.topicName, _stringBytes);
                _size.addBytes(_stringBytes.length + 2);
            }
            _size.addBytes(4);
            _size.addBytes(4);
            _size.addBytes(4);
            _size.addBytes(4);
            if (_version >= 4) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.isr.size() + 1));
            } else {
                _size.addBytes(4);
            }
            _size.addBytes(this.isr.size() * 4);
            _size.addBytes(4);
            if (_version >= 4) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.replicas.size() + 1));
            } else {
                _size.addBytes(4);
            }
            _size.addBytes(this.replicas.size() * 4);
            if (_version >= 3) {
                if (_version >= 4) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.addingReplicas.size() + 1));
                } else {
                    _size.addBytes(4);
                }
                _size.addBytes(this.addingReplicas.size() * 4);
            }
            if (_version >= 3) {
                if (_version >= 4) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.removingReplicas.size() + 1));
                } else {
                    _size.addBytes(4);
                }
                _size.addBytes(this.removingReplicas.size() * 4);
            }
            if (_version >= 1) {
                _size.addBytes(1);
            }
            if (_version >= 6) {
                _size.addBytes(1);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 4) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LeaderAndIsrPartitionState)) {
                return false;
            }
            LeaderAndIsrPartitionState other = (LeaderAndIsrPartitionState)obj;
            if (this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName)) {
                return false;
            }
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.controllerEpoch != other.controllerEpoch) {
                return false;
            }
            if (this.leader != other.leader) {
                return false;
            }
            if (this.leaderEpoch != other.leaderEpoch) {
                return false;
            }
            if (this.isr == null ? other.isr != null : !this.isr.equals(other.isr)) {
                return false;
            }
            if (this.partitionEpoch != other.partitionEpoch) {
                return false;
            }
            if (this.replicas == null ? other.replicas != null : !this.replicas.equals(other.replicas)) {
                return false;
            }
            if (this.addingReplicas == null ? other.addingReplicas != null : !this.addingReplicas.equals(other.addingReplicas)) {
                return false;
            }
            if (this.removingReplicas == null ? other.removingReplicas != null : !this.removingReplicas.equals(other.removingReplicas)) {
                return false;
            }
            if (this.isNew != other.isNew) {
                return false;
            }
            if (this.leaderRecoveryState != other.leaderRecoveryState) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topicName == null ? 0 : this.topicName.hashCode());
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.controllerEpoch;
            hashCode = 31 * hashCode + this.leader;
            hashCode = 31 * hashCode + this.leaderEpoch;
            hashCode = 31 * hashCode + (this.isr == null ? 0 : this.isr.hashCode());
            hashCode = 31 * hashCode + this.partitionEpoch;
            hashCode = 31 * hashCode + (this.replicas == null ? 0 : this.replicas.hashCode());
            hashCode = 31 * hashCode + (this.addingReplicas == null ? 0 : this.addingReplicas.hashCode());
            hashCode = 31 * hashCode + (this.removingReplicas == null ? 0 : this.removingReplicas.hashCode());
            hashCode = 31 * hashCode + (this.isNew ? 1231 : 1237);
            hashCode = 31 * hashCode + this.leaderRecoveryState;
            return hashCode;
        }

        @Override
        public LeaderAndIsrPartitionState duplicate() {
            LeaderAndIsrPartitionState _duplicate = new LeaderAndIsrPartitionState();
            _duplicate.topicName = this.topicName;
            _duplicate.partitionIndex = this.partitionIndex;
            _duplicate.controllerEpoch = this.controllerEpoch;
            _duplicate.leader = this.leader;
            _duplicate.leaderEpoch = this.leaderEpoch;
            ArrayList<Integer> newIsr = new ArrayList<Integer>(this.isr.size());
            for (Integer n : this.isr) {
                newIsr.add(n);
            }
            _duplicate.isr = newIsr;
            _duplicate.partitionEpoch = this.partitionEpoch;
            ArrayList<Integer> newReplicas = new ArrayList<Integer>(this.replicas.size());
            for (Integer n : this.replicas) {
                newReplicas.add(n);
            }
            _duplicate.replicas = newReplicas;
            ArrayList<Integer> arrayList = new ArrayList<Integer>(this.addingReplicas.size());
            for (Integer _element : this.addingReplicas) {
                arrayList.add(_element);
            }
            _duplicate.addingReplicas = arrayList;
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>(this.removingReplicas.size());
            for (Integer _element : this.removingReplicas) {
                arrayList2.add(_element);
            }
            _duplicate.removingReplicas = arrayList2;
            _duplicate.isNew = this.isNew;
            _duplicate.leaderRecoveryState = this.leaderRecoveryState;
            return _duplicate;
        }

        public String toString() {
            return "LeaderAndIsrPartitionState(topicName=" + (this.topicName == null ? "null" : "'" + this.topicName.toString() + "'") + ", partitionIndex=" + this.partitionIndex + ", controllerEpoch=" + this.controllerEpoch + ", leader=" + this.leader + ", leaderEpoch=" + this.leaderEpoch + ", isr=" + MessageUtil.deepToString(this.isr.iterator()) + ", partitionEpoch=" + this.partitionEpoch + ", replicas=" + MessageUtil.deepToString(this.replicas.iterator()) + ", addingReplicas=" + MessageUtil.deepToString(this.addingReplicas.iterator()) + ", removingReplicas=" + MessageUtil.deepToString(this.removingReplicas.iterator()) + ", isNew=" + (this.isNew ? "true" : "false") + ", leaderRecoveryState=" + this.leaderRecoveryState + ")";
        }

        public String topicName() {
            return this.topicName;
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public int controllerEpoch() {
            return this.controllerEpoch;
        }

        public int leader() {
            return this.leader;
        }

        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        public List<Integer> isr() {
            return this.isr;
        }

        public int partitionEpoch() {
            return this.partitionEpoch;
        }

        public List<Integer> replicas() {
            return this.replicas;
        }

        public List<Integer> addingReplicas() {
            return this.addingReplicas;
        }

        public List<Integer> removingReplicas() {
            return this.removingReplicas;
        }

        public boolean isNew() {
            return this.isNew;
        }

        public byte leaderRecoveryState() {
            return this.leaderRecoveryState;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public LeaderAndIsrPartitionState setTopicName(String v) {
            this.topicName = v;
            return this;
        }

        public LeaderAndIsrPartitionState setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public LeaderAndIsrPartitionState setControllerEpoch(int v) {
            this.controllerEpoch = v;
            return this;
        }

        public LeaderAndIsrPartitionState setLeader(int v) {
            this.leader = v;
            return this;
        }

        public LeaderAndIsrPartitionState setLeaderEpoch(int v) {
            this.leaderEpoch = v;
            return this;
        }

        public LeaderAndIsrPartitionState setIsr(List<Integer> v) {
            this.isr = v;
            return this;
        }

        public LeaderAndIsrPartitionState setPartitionEpoch(int v) {
            this.partitionEpoch = v;
            return this;
        }

        public LeaderAndIsrPartitionState setReplicas(List<Integer> v) {
            this.replicas = v;
            return this;
        }

        public LeaderAndIsrPartitionState setAddingReplicas(List<Integer> v) {
            this.addingReplicas = v;
            return this;
        }

        public LeaderAndIsrPartitionState setRemovingReplicas(List<Integer> v) {
            this.removingReplicas = v;
            return this;
        }

        public LeaderAndIsrPartitionState setIsNew(boolean v) {
            this.isNew = v;
            return this;
        }

        public LeaderAndIsrPartitionState setLeaderRecoveryState(byte v) {
            this.leaderRecoveryState = v;
            return this;
        }

        static {
            SCHEMA_5 = SCHEMA_4 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("leader", Type.INT32, "The broker ID of the leader."), new Field("leader_epoch", Type.INT32, "The leader epoch."), new Field("isr", new CompactArrayOf(Type.INT32), "The in-sync replica IDs."), new Field("partition_epoch", Type.INT32, "The current epoch for the partition. The epoch is a monotonically increasing value which is incremented after every partition change. (Since the LeaderAndIsr request is only used by the legacy controller, this corresponds to the zkVersion)"), new Field("replicas", new CompactArrayOf(Type.INT32), "The replica IDs."), new Field("adding_replicas", new CompactArrayOf(Type.INT32), "The replica IDs that we are adding this partition to, or null if no replicas are being added."), new Field("removing_replicas", new CompactArrayOf(Type.INT32), "The replica IDs that we are removing this partition from, or null if no replicas are being removed."), new Field("is_new", Type.BOOLEAN, "Whether the replica should have existed on the broker or not."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMA_6 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("leader", Type.INT32, "The broker ID of the leader."), new Field("leader_epoch", Type.INT32, "The leader epoch."), new Field("isr", new CompactArrayOf(Type.INT32), "The in-sync replica IDs."), new Field("partition_epoch", Type.INT32, "The current epoch for the partition. The epoch is a monotonically increasing value which is incremented after every partition change. (Since the LeaderAndIsr request is only used by the legacy controller, this corresponds to the zkVersion)"), new Field("replicas", new CompactArrayOf(Type.INT32), "The replica IDs."), new Field("adding_replicas", new CompactArrayOf(Type.INT32), "The replica IDs that we are adding this partition to, or null if no replicas are being added."), new Field("removing_replicas", new CompactArrayOf(Type.INT32), "The replica IDs that we are removing this partition from, or null if no replicas are being removed."), new Field("is_new", Type.BOOLEAN, "Whether the replica should have existed on the broker or not."), new Field("leader_recovery_state", Type.INT8, "1 if the partition is recovering from an unclean leader election; 0 otherwise."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6};
        }
    }

    public static class LeaderAndIsrLiveLeader
    implements Message {
        int brokerId;
        String hostName;
        int port;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 6;

        public LeaderAndIsrLiveLeader(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public LeaderAndIsrLiveLeader() {
            this.brokerId = 0;
            this.hostName = "";
            this.port = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 6;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 6) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of LeaderAndIsrLiveLeader");
            }
            this.brokerId = _readable.readInt();
            int length = _version >= 4 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field hostName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field hostName had invalid length " + length);
            }
            this.hostName = _readable.readString(length);
            this.port = _readable.readInt();
            this._unknownTaggedFields = null;
            if (_version >= 4) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.brokerId);
            byte[] _stringBytes = _cache.getSerializedValue(this.hostName);
            if (_version >= 4) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            _writable.writeInt(this.port);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 4) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 6) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of LeaderAndIsrLiveLeader");
            }
            _size.addBytes(4);
            byte[] _stringBytes = this.hostName.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'hostName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.hostName, _stringBytes);
            if (_version >= 4) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            _size.addBytes(4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 4) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LeaderAndIsrLiveLeader)) {
                return false;
            }
            LeaderAndIsrLiveLeader other = (LeaderAndIsrLiveLeader)obj;
            if (this.brokerId != other.brokerId) {
                return false;
            }
            if (this.hostName == null ? other.hostName != null : !this.hostName.equals(other.hostName)) {
                return false;
            }
            if (this.port != other.port) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.brokerId;
            hashCode = 31 * hashCode + (this.hostName == null ? 0 : this.hostName.hashCode());
            hashCode = 31 * hashCode + this.port;
            return hashCode;
        }

        @Override
        public LeaderAndIsrLiveLeader duplicate() {
            LeaderAndIsrLiveLeader _duplicate = new LeaderAndIsrLiveLeader();
            _duplicate.brokerId = this.brokerId;
            _duplicate.hostName = this.hostName;
            _duplicate.port = this.port;
            return _duplicate;
        }

        public String toString() {
            return "LeaderAndIsrLiveLeader(brokerId=" + this.brokerId + ", hostName=" + (this.hostName == null ? "null" : "'" + this.hostName.toString() + "'") + ", port=" + this.port + ")";
        }

        public int brokerId() {
            return this.brokerId;
        }

        public String hostName() {
            return this.hostName;
        }

        public int port() {
            return this.port;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public LeaderAndIsrLiveLeader setBrokerId(int v) {
            this.brokerId = v;
            return this;
        }

        public LeaderAndIsrLiveLeader setHostName(String v) {
            this.hostName = v;
            return this;
        }

        public LeaderAndIsrLiveLeader setPort(int v) {
            this.port = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("broker_id", Type.INT32, "The leader's broker ID."), new Field("host_name", Type.STRING, "The leader's hostname."), new Field("port", Type.INT32, "The leader's port."))));
            SCHEMA_6 = SCHEMA_5 = (SCHEMA_4 = new Schema(new Field("broker_id", Type.INT32, "The leader's broker ID."), new Field("host_name", Type.COMPACT_STRING, "The leader's hostname."), new Field("port", Type.INT32, "The leader's port."), Field.TaggedFieldsSection.of(new Object[0])));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6};
        }
    }

    public static class LeaderAndIsrTopicState
    implements Message {
        String topicName;
        Uuid topicId;
        List<LeaderAndIsrPartitionState> partitionStates;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_2 = new Schema(new Field("topic_name", Type.STRING, "The topic name."), new Field("partition_states", new ArrayOf(LeaderAndIsrPartitionState.SCHEMA_2), "The state of each partition"));
        public static final Schema SCHEMA_3 = new Schema(new Field("topic_name", Type.STRING, "The topic name."), new Field("partition_states", new ArrayOf(LeaderAndIsrPartitionState.SCHEMA_3), "The state of each partition"));
        public static final Schema SCHEMA_4 = new Schema(new Field("topic_name", Type.COMPACT_STRING, "The topic name."), new Field("partition_states", new CompactArrayOf(LeaderAndIsrPartitionState.SCHEMA_4), "The state of each partition"), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema SCHEMA_5 = new Schema(new Field("topic_name", Type.COMPACT_STRING, "The topic name."), new Field("topic_id", Type.UUID, "The unique topic ID."), new Field("partition_states", new CompactArrayOf(LeaderAndIsrPartitionState.SCHEMA_4), "The state of each partition"), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema SCHEMA_6 = new Schema(new Field("topic_name", Type.COMPACT_STRING, "The topic name."), new Field("topic_id", Type.UUID, "The unique topic ID."), new Field("partition_states", new CompactArrayOf(LeaderAndIsrPartitionState.SCHEMA_6), "The state of each partition"), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{null, null, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6};
        public static final short LOWEST_SUPPORTED_VERSION = 2;
        public static final short HIGHEST_SUPPORTED_VERSION = 6;

        public LeaderAndIsrTopicState(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public LeaderAndIsrTopicState() {
            this.topicName = "";
            this.topicId = Uuid.ZERO_UUID;
            this.partitionStates = new ArrayList<LeaderAndIsrPartitionState>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 6;
        }

        @Override
        public void read(Readable _readable, short _version) {
            int i;
            ArrayList<LeaderAndIsrPartitionState> newCollection;
            int arrayLength;
            if (_version > 6) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of LeaderAndIsrTopicState");
            }
            int length = _version >= 4 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field topicName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topicName had invalid length " + length);
            }
            this.topicName = _readable.readString(length);
            this.topicId = _version >= 5 ? _readable.readUuid() : Uuid.ZERO_UUID;
            if (_version >= 4) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitionStates was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new LeaderAndIsrPartitionState(_readable, _version));
                }
                this.partitionStates = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitionStates was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList<LeaderAndIsrPartitionState>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new LeaderAndIsrPartitionState(_readable, _version));
                }
                this.partitionStates = newCollection;
            }
            this._unknownTaggedFields = null;
            if (_version >= 4) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version < 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of LeaderAndIsrTopicState");
            }
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.topicName);
            if (_version >= 4) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 5) {
                _writable.writeUuid(this.topicId);
            }
            if (_version >= 4) {
                _writable.writeUnsignedVarint(this.partitionStates.size() + 1);
                _stringBytes = this.partitionStates.iterator();
                while (_stringBytes.hasNext()) {
                    LeaderAndIsrPartitionState partitionStatesElement = (LeaderAndIsrPartitionState)_stringBytes.next();
                    partitionStatesElement.write(_writable, _cache, _version);
                }
            } else {
                _writable.writeInt(this.partitionStates.size());
                _stringBytes = this.partitionStates.iterator();
                while (_stringBytes.hasNext()) {
                    LeaderAndIsrPartitionState partitionStatesElement = (LeaderAndIsrPartitionState)_stringBytes.next();
                    partitionStatesElement.write(_writable, _cache, _version);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 4) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 6) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of LeaderAndIsrTopicState");
            }
            byte[] _stringBytes = this.topicName.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topicName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topicName, _stringBytes);
            if (_version >= 4) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            if (_version >= 5) {
                _size.addBytes(16);
            }
            if (_version >= 4) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitionStates.size() + 1));
            } else {
                _size.addBytes(4);
            }
            for (LeaderAndIsrPartitionState partitionStatesElement : this.partitionStates) {
                partitionStatesElement.addSize(_size, _cache, _version);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 4) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LeaderAndIsrTopicState)) {
                return false;
            }
            LeaderAndIsrTopicState other = (LeaderAndIsrTopicState)obj;
            if (this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName)) {
                return false;
            }
            if (!this.topicId.equals(other.topicId)) {
                return false;
            }
            if (this.partitionStates == null ? other.partitionStates != null : !this.partitionStates.equals(other.partitionStates)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topicName == null ? 0 : this.topicName.hashCode());
            hashCode = 31 * hashCode + this.topicId.hashCode();
            hashCode = 31 * hashCode + (this.partitionStates == null ? 0 : this.partitionStates.hashCode());
            return hashCode;
        }

        @Override
        public LeaderAndIsrTopicState duplicate() {
            LeaderAndIsrTopicState _duplicate = new LeaderAndIsrTopicState();
            _duplicate.topicName = this.topicName;
            _duplicate.topicId = this.topicId;
            ArrayList<LeaderAndIsrPartitionState> newPartitionStates = new ArrayList<LeaderAndIsrPartitionState>(this.partitionStates.size());
            for (LeaderAndIsrPartitionState _element : this.partitionStates) {
                newPartitionStates.add(_element.duplicate());
            }
            _duplicate.partitionStates = newPartitionStates;
            return _duplicate;
        }

        public String toString() {
            return "LeaderAndIsrTopicState(topicName=" + (this.topicName == null ? "null" : "'" + this.topicName.toString() + "'") + ", topicId=" + this.topicId.toString() + ", partitionStates=" + MessageUtil.deepToString(this.partitionStates.iterator()) + ")";
        }

        public String topicName() {
            return this.topicName;
        }

        public Uuid topicId() {
            return this.topicId;
        }

        public List<LeaderAndIsrPartitionState> partitionStates() {
            return this.partitionStates;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public LeaderAndIsrTopicState setTopicName(String v) {
            this.topicName = v;
            return this;
        }

        public LeaderAndIsrTopicState setTopicId(Uuid v) {
            this.topicId = v;
            return this;
        }

        public LeaderAndIsrTopicState setPartitionStates(List<LeaderAndIsrPartitionState> v) {
            this.partitionStates = v;
            return this;
        }
    }
}

