/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.kafka.consumer;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;

public abstract class HonoKafkaConsumerHelper {
    private HonoKafkaConsumerHelper() {
    }

    public static String getPartitionsDebugString(Collection<TopicPartition> partitionsSet) {
        Objects.requireNonNull(partitionsSet);
        return partitionsSet.size() <= 20 ? partitionsSet.stream().collect(Collectors.groupingBy(TopicPartition::topic, Collectors.mapping(TopicPartition::partition, Collectors.toCollection(TreeSet::new)))).toString() : partitionsSet.size() + " topic partitions";
    }

    public static String getOffsetsDebugString(Map<TopicPartition, OffsetAndMetadata> offsets) {
        Objects.requireNonNull(offsets);
        return offsets.size() <= 20 ? offsets.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((OffsetAndMetadata)entry.getValue()).offset())).toString() : offsets.size() + " offsets";
    }
}

