/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.retro;

import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.mylyn.docs.intent.retro.AcceptanceTest;
import org.eclipse.mylyn.docs.intent.retro.Project;
import org.eclipse.mylyn.docs.intent.retro.RetroFactory;
import org.eclipse.mylyn.docs.intent.retro.RetroGeneratedElementListener;

public class ProtocolFactory
implements Resource.Factory {
    public Resource createResource(URI uri) {
        IProject prj;
        IWorkspace wksps;
        String projectName = ProtocolFactory.extractProjectName(uri);
        String regExp = ProtocolFactory.extractRegExp(uri);
        if (projectName != null && (wksps = ResourcesPlugin.getWorkspace()) != null && (prj = wksps.getRoot().getProject(projectName)) != null) {
            ResourceImpl result = new ResourceImpl(uri);
            Project rPrj = RetroFactory.eINSTANCE.createProject();
            rPrj.setId(projectName);
            try {
                this.fillProjectWithTests(rPrj, prj, regExp);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            result.getContents().add((Object)rPrj);
            this.addListeners(prj);
            return result;
        }
        return null;
    }

    private void addListeners(IProject prj) {
        if (RetroGeneratedElementListener.getInstance() != null) {
            RetroGeneratedElementListener.getInstance().addElementToListen(URI.createURI((String)("retro:/" + prj.getName())));
        }
    }

    private void fillProjectWithTests(final Project rPrj, IProject prj, String regExp) throws CoreException {
        final Pattern pattern = Pattern.compile(regExp, 34);
        if (prj.exists()) {
            prj.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    String resourcePath;
                    if ("java".equals(resource.getFileExtension()) && pattern.matcher(resourcePath = resource.getFullPath().removeFirstSegments(2).removeFirstSegments(3).removeLastSegments(1).toString().replaceAll("/", ".")).matches()) {
                        AcceptanceTest tst = RetroFactory.eINSTANCE.createAcceptanceTest();
                        tst.setSwtBotClassName(resource.getFullPath().lastSegment().replace(".java", ""));
                        tst.setPackage(resourcePath);
                        rPrj.getAcceptanceTests().add((Object)tst);
                    }
                    return true;
                }
            });
        }
    }

    public static String extractProjectName(URI uri) {
        if (uri.segmentCount() >= 1) {
            return uri.segment(0);
        }
        return null;
    }

    public static String extractRegExp(URI uri) {
        if (uri.segmentCount() > 1) {
            String regExp = "";
            int i = 1;
            while (i < uri.segmentCount()) {
                if (i > 1) {
                    regExp = String.valueOf(regExp) + "/";
                }
                regExp = String.valueOf(regExp) + uri.segment(i);
                ++i;
            }
            regExp = regExp.replace(".", "\\.");
            regExp = regExp.replace("*", ".*").replace("?", ".");
            return regExp;
        }
        return ".*";
    }
}

