/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.ide.navigator;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.docs.intent.client.ui.logger.IntentUiLogger;
import org.eclipse.mylyn.docs.intent.client.ui.utils.IntentEditorOpener;
import org.eclipse.mylyn.docs.intent.collab.common.IntentRepositoryManager;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.collab.repository.Repository;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryConnectionException;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatus;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocument;
import org.eclipse.mylyn.docs.intent.core.document.IntentSubSectionContainer;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.views.markers.MarkerItem;

public class ShowProblemInEditorHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection instanceof IStructuredSelection) {
            Object firstElement = ((IStructuredSelection)currentSelection).getFirstElement();
            try {
                if (firstElement instanceof MarkerItem && "Intent".equals(((MarkerItem)firstElement).getAttributeValue("sourceId", ""))) {
                    this.doOpenIntentEditorOnProblem((MarkerItem)firstElement);
                }
            }
            catch (RepositoryConnectionException e) {
                IntentUiLogger.logError((Throwable)e);
            }
            catch (CoreException e) {
                IntentUiLogger.logError((Throwable)e);
            }
        }
        return null;
    }

    private void doOpenIntentEditorOnProblem(MarkerItem markerItem) throws RepositoryConnectionException, CoreException {
        String location = markerItem.getLocation();
        if (location.startsWith("platform:/resource/")) {
            location = location.replaceFirst("platform:/resource/", "");
            Repository repository = IntentRepositoryManager.INSTANCE.getRepository(location = location.substring(0, location.indexOf("/")));
            RepositoryAdapter adapter = repository.createRepositoryAdapter();
            EObject elementToOpen = adapter.getResource("/INTENT/IntentDocument").getResourceSet().getEObject(URI.createURI((String)markerItem.getLocation()), true);
            if (elementToOpen instanceof CompilationStatus) {
                elementToOpen = ((CompilationStatus)elementToOpen).getTarget();
            }
            EObject elementToSelect = elementToOpen;
            while (elementToOpen != null && !(elementToOpen instanceof IntentSubSectionContainer) && !(elementToOpen instanceof IntentDocument)) {
                elementToOpen = elementToOpen.eContainer();
            }
            if (elementToOpen != null) {
                IntentEditorOpener.openIntentEditor((Repository)repository, (EObject)elementToOpen, (boolean)false, (EObject)elementToSelect, (boolean)false);
            }
            adapter.closeContext();
        }
    }
}

