/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.synchronizer.factory;

import org.eclipse.emf.compare.diff.metamodel.AttributeChange;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChange;
import org.eclipse.emf.compare.diff.metamodel.UpdateAttribute;
import org.eclipse.emf.compare.diff.metamodel.UpdateReference;
import org.eclipse.emf.compare.diff.metamodel.impl.UpdateAttributeImpl;
import org.eclipse.emf.compare.diff.metamodel.impl.UpdateReferenceImpl;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.mylyn.docs.intent.client.synchronizer.factory.SynchonizerEObjectNameGetter;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ResourceDeclaration;

public final class SynchronizerMessageProvider {
    private static final String SYNC_MESSAGES_WHITESPACE = " ";
    private static final String SYNC_MESSAGES_INTERNAL_MODEL = "<b>Current Document</b>";
    private static final String SYNC_MESSAGES_EXTERNAL_MODEL = "<b>Working Copy</b>";
    private static final String SYNC_STATUS_SEPARATOR = "<br/><hr/><br/>";

    private SynchronizerMessageProvider() {
    }

    public static String createMessageFromDiffElement(DiffElement diffElement) {
        String returnedMessage = null;
        try {
            switch (diffElement.eClass().getClassifierID()) {
                case 14: {
                    returnedMessage = SynchronizerMessageProvider.createMessageFromAttributeChange((AttributeChange)diffElement);
                    break;
                }
                case 19: {
                    returnedMessage = SynchronizerMessageProvider.createMessageFromReferenceChange((ReferenceChange)diffElement);
                    break;
                }
                case 18: {
                    returnedMessage = SynchronizerMessageProvider.createMessageFromUpdateAttribute((UpdateAttribute)diffElement);
                    break;
                }
                case 22: {
                    returnedMessage = SynchronizerMessageProvider.createMessageFromUpdateReference((UpdateReference)diffElement);
                    break;
                }
                case 9: {
                    returnedMessage = SynchronizerMessageProvider.createMessageFromModelElementChangeLeftTarget((ModelElementChangeLeftTarget)diffElement);
                    break;
                }
                case 10: {
                    returnedMessage = SynchronizerMessageProvider.createMessageFromModelElementChangeRightTarget((ModelElementChangeRightTarget)diffElement);
                    break;
                }
                case 20: {
                    break;
                }
                case 21: {
                    break;
                }
                case 25: {
                    break;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            returnedMessage = null;
        }
        if (returnedMessage == null) {
            returnedMessage = SynchonizerEObjectNameGetter.computeObjectName((EObject)diffElement);
        }
        return returnedMessage;
    }

    public static String createMessageFromAttributeChange(AttributeChange difference) {
        return difference.toString();
    }

    public static String createMessageFromReferenceChange(ReferenceChange difference) {
        return difference.toString();
    }

    public static String createMessageFromUpdateAttribute(UpdateAttribute difference) {
        String name;
        EAttribute attribute = ((UpdateAttributeImpl)difference).getAttribute();
        String returnedMessage = String.valueOf(attribute.eClass().getName()) + SYNC_MESSAGES_WHITESPACE + attribute.getName();
        if (difference.getLeftElement() instanceof ENamedElement && (name = ((ENamedElement)difference.getLeftElement()).getName()) != null) {
            returnedMessage = String.valueOf(returnedMessage) + " in " + name;
        }
        returnedMessage = String.valueOf(returnedMessage) + SynchronizerMessageProvider.createCompareValuesMessage(difference.getLeftElement().eGet((EStructuralFeature)attribute), difference.getRightElement().eGet((EStructuralFeature)attribute));
        return returnedMessage;
    }

    public static String createMessageFromUpdateReference(UpdateReference difference) {
        String name;
        EReference reference = ((UpdateReferenceImpl)difference).getReference();
        String returnedMessage = String.valueOf(reference.eClass().getName()) + SYNC_MESSAGES_WHITESPACE + reference.getName();
        if (difference.getLeftElement() instanceof ENamedElement && (name = ((ENamedElement)difference.getLeftElement()).getName()) != null) {
            returnedMessage = String.valueOf(returnedMessage) + " in " + name;
        }
        returnedMessage = String.valueOf(returnedMessage) + SynchronizerMessageProvider.createCompareValuesMessage(difference.getLeftElement().eGet((EStructuralFeature)reference), difference.getRightElement().eGet((EStructuralFeature)reference));
        return returnedMessage;
    }

    public static String createMessageFromModelElementChangeLeftTarget(ModelElementChangeLeftTarget difference) {
        String name;
        String returnedMessage = "The " + difference.getLeftElement().eClass().getName();
        if (difference.getLeftElement() instanceof ENamedElement && (name = ((ENamedElement)difference.getLeftElement()).getName()) != null) {
            returnedMessage = String.valueOf(returnedMessage) + SYNC_MESSAGES_WHITESPACE + name;
        }
        returnedMessage = String.valueOf(returnedMessage) + " is defined in the <b>Current Document</b> model<br/>but not in the <b>Working Copy</b> model.";
        return returnedMessage;
    }

    public static String createMessageFromModelElementChangeRightTarget(ModelElementChangeRightTarget difference) {
        String name;
        String returnedMessage = "The " + difference.getRightElement().eClass().getName();
        if (difference.getRightElement() instanceof ENamedElement && (name = ((ENamedElement)difference.getRightElement()).getName()) != null) {
            returnedMessage = String.valueOf(returnedMessage) + SYNC_MESSAGES_WHITESPACE + name;
        }
        returnedMessage = String.valueOf(returnedMessage) + " is defined in the <b>Working Copy</b> model<br/>but not in the <b>Current Document</b> model.";
        return returnedMessage;
    }

    private static String createCompareValuesMessage(Object repositoryValue, Object localValue) {
        return " has changed.<br/><b>Current Document</b> : " + repositoryValue + "<br/>" + SYNC_MESSAGES_EXTERNAL_MODEL + " : " + localValue;
    }

    public static String getStatusSeparator() {
        return SYNC_STATUS_SEPARATOR;
    }

    public static String createMessageForNullExternalResource(ResourceDeclaration resourceDeclaration) {
        String returnedMessage = "";
        if (resourceDeclaration.getUri() != null) {
            returnedMessage = String.valueOf(returnedMessage) + "Cannot locate Resource at URI : " + resourceDeclaration.getUri().toString();
        }
        returnedMessage = String.valueOf(returnedMessage) + '.';
        return returnedMessage;
    }

    public static String createMessageForEmptyExternalResource(ResourceDeclaration resourceDeclaration) {
        String returnedMessage = "";
        if (resourceDeclaration.getUri() != null) {
            returnedMessage = String.valueOf(returnedMessage) + "The Resource at URI : " + resourceDeclaration.getUri().toString() + " is empty";
        }
        returnedMessage = String.valueOf(returnedMessage) + '.';
        return returnedMessage;
    }

    public static String createMessageForEmptyInternalResource(ResourceDeclaration resourceDeclaration) {
        String returnedMessage = "";
        if (resourceDeclaration.getUri() != null) {
            returnedMessage = String.valueOf(returnedMessage) + "The Resource " + resourceDeclaration.getName() + " is empty";
        }
        returnedMessage = String.valueOf(returnedMessage) + '.';
        return returnedMessage;
    }
}

