/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.markup.builder.state;

import org.eclipse.mylyn.docs.intent.markup.builder.BuilderState;
import org.eclipse.mylyn.docs.intent.markup.builder.operation.HasAttributeCopyAttributes;
import org.eclipse.mylyn.docs.intent.markup.builder.state.SBlock;
import org.eclipse.mylyn.docs.intent.markup.markup.MarkupFactory;
import org.eclipse.mylyn.docs.intent.markup.markup.Table;
import org.eclipse.mylyn.docs.intent.markup.markup.TableCell;
import org.eclipse.mylyn.docs.intent.markup.markup.TableRow;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;

public class STable
extends SBlock {
    private Table table;
    private TableRow currentTr;

    public STable(BuilderState previous, Table table) {
        super(previous, table);
        this.table = table;
    }

    public BuilderState beginBlock(DocumentBuilder.BlockType type, Attributes attributes) {
        switch (type) {
            case TABLE_ROW: {
                TableRow tr = MarkupFactory.eINSTANCE.createTableRow();
                new HasAttributeCopyAttributes(tr).setValues(attributes);
                this.currentTr = tr;
                this.table.getContent().add((Object)tr);
                break;
            }
            case TABLE_CELL_HEADER: 
            case TABLE_CELL_NORMAL: {
                if (this.currentTr == null) {
                    throw new UnsupportedOperationException("Can't add a cell directly into a Table : must create a Tr.");
                }
                TableCell td = MarkupFactory.eINSTANCE.createTableCell();
                new HasAttributeCopyAttributes(td).setValues(attributes);
                td.setIsCellHeader(type == DocumentBuilder.BlockType.TABLE_CELL_HEADER);
                this.currentTr.getContent().add((Object)td);
                return new SBlock(this, td);
            }
        }
        return this;
    }

    public BuilderState endBlock() {
        if (this.currentTr == null) {
            return this.previousState();
        }
        this.currentTr = null;
        return this;
    }
}

