/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.exporter.services;

import java.io.File;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocument;
import org.eclipse.mylyn.docs.intent.core.document.IntentSection;
import org.eclipse.mylyn.docs.intent.core.document.IntentSubSectionContainer;
import org.eclipse.mylyn.docs.intent.core.genericunit.UnitInstruction;
import org.eclipse.mylyn.docs.intent.exporter.services.CopyImageUtils;

public final class IntentAcceleoServices {
    private static File outputFolder;
    private static String intentDocumentTitle;
    private static RepositoryAdapter repositoryAdapter;

    public static String getHeaderSizeForSection(String sectionID) {
        return String.valueOf(sectionID.split("_").length);
    }

    public static String getDocumentTitle(EObject any) {
        return intentDocumentTitle;
    }

    public static String getQualifiedImageID(EObject any) {
        return CopyImageUtils.copyImageAndGetImageID(any, repositoryAdapter, outputFolder);
    }

    public static String getContainingSectionID(EObject any) {
        String ID = "";
        if (any instanceof IntentSection) {
            EObject container = any;
            while (container != null & !(container instanceof IntentDocument)) {
                if (container.eContainer() instanceof IntentSubSectionContainer) {
                    ID = String.valueOf(((IntentSubSectionContainer)container.eContainer()).getSubSections().indexOf((Object)container) + 1) + "_" + ID;
                } else if (container.eContainer() instanceof IntentDocument) {
                    ID = String.valueOf(((IntentDocument)container.eContainer()).getChapters().indexOf((Object)container) + 1) + "_" + ID;
                }
                container = container.eContainer();
            }
        }
        return ID.substring(0, ID.lastIndexOf("_"));
    }

    public static IntentSection getContainingSection(EObject any) {
        EObject container = any;
        if (any instanceof UnitInstruction) {
            while (container != null && !(container instanceof IntentSection)) {
                container = container.eContainer();
            }
        }
        if (container instanceof IntentSection) {
            return (IntentSection)container;
        }
        return null;
    }

    public static void initialize(String documentTitle, File generationOutputFolder, RepositoryAdapter adapter) {
        intentDocumentTitle = documentTitle;
        outputFolder = generationOutputFolder;
        repositoryAdapter = adapter;
    }

    public static void dispose() {
        CopyImageUtils.dispose();
        outputFolder = null;
        repositoryAdapter = null;
    }
}

