/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.collab.ide.repository;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.IntentCommand;
import org.eclipse.mylyn.docs.intent.collab.handlers.impl.notification.elementList.ElementListAdapter;
import org.eclipse.mylyn.docs.intent.collab.ide.adapters.WorkspaceAdapter;
import org.eclipse.mylyn.docs.intent.collab.ide.notification.WorkspaceTypeListener;
import org.eclipse.mylyn.docs.intent.collab.ide.repository.WorkspaceRepository;
import org.eclipse.mylyn.docs.intent.collab.ide.repository.WorkspaceSessionDeltaVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceSession
implements IResourceChangeListener {
    protected Collection<Resource> savedResources = new ArrayList<Resource>();
    private WorkspaceRepository repository;
    private final Path repositoryPath;
    private WorkspaceAdapter repositoryAdapter;
    private final List<WorkspaceTypeListener> workspaceSessionListeners;
    private boolean isBusy;

    public WorkspaceSession(WorkspaceRepository repository) {
        this.repository = repository;
        this.repositoryPath = new Path(repository.getWorkspaceConfig().getRepositoryAbsolutePath());
        this.repositoryAdapter = new WorkspaceAdapter(repository);
        this.workspaceSessionListeners = new ArrayList<WorkspaceTypeListener>();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta rootDelta;
        IResourceDelta repositoryDelta;
        if (event.getType() == 1 && (repositoryDelta = (rootDelta = event.getDelta()).findMember((IPath)this.repositoryPath)) != null) {
            Job job = new Job("Notifying Intent clients"){

                protected IStatus run(IProgressMonitor monitor) {
                    WorkspaceSession.this.isBusy = true;
                    WorkspaceSession.this.analyseWorkspaceDelta(repositoryDelta);
                    WorkspaceSession.this.isBusy = false;
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    private synchronized void analyseWorkspaceDelta(IResourceDelta repositoryDelta) {
        WorkspaceSessionDeltaVisitor visitor = new WorkspaceSessionDeltaVisitor(this.repositoryAdapter, this.repositoryPath);
        try {
            repositoryDelta.accept((IResourceDeltaVisitor)visitor);
            ArrayList<Resource> removedResources = new ArrayList<Resource>();
            ArrayList<Resource> changedResources = new ArrayList<Resource>();
            if (!visitor.getRemovedResources().isEmpty()) {
                removedResources.addAll(visitor.getRemovedResources());
            }
            for (Resource changedResource : visitor.getChangedResources()) {
                if (!this.savedResources.contains(changedResource)) {
                    changedResources.add(changedResource);
                    continue;
                }
                this.savedResources.remove(changedResource);
            }
            this.treatRemovedResources(removedResources);
            this.treatChangedResources(changedResources);
        }
        catch (CoreException coreException) {}
    }

    private void treatChangedResources(Collection<Resource> changedResources) {
        for (final Resource changedResource : changedResources) {
            if (!changedResource.isLoaded()) continue;
            this.repositoryAdapter.execute(new IntentCommand(){

                public void execute() {
                    WorkspaceSession.this.notifyListeners(changedResource);
                }
            });
        }
    }

    private void reloadResource(Resource changedResource) {
        ArrayList oldAdaptersList = new ArrayList();
        for (EObject root : changedResource.getContents()) {
            oldAdaptersList.addAll(root.eAdapters());
        }
        changedResource.unload();
        try {
            this.repository.getResourceSet().getResource(changedResource.getURI(), true);
        }
        catch (WrappedException wrappedException) {
            try {
                changedResource.load(WorkspaceAdapter.getLoadOptions());
            }
            catch (IOException iOException) {}
        }
        for (EObject root : changedResource.getContents()) {
            for (Adapter adapter : oldAdaptersList) {
                root.eAdapters().add((Object)adapter);
                if (this.savedResources.contains(changedResource) || !(adapter instanceof ElementListAdapter)) continue;
                ((ElementListAdapter)adapter).notifyChangesOnElement(root);
            }
        }
    }

    private void treatRemovedResources(Collection<Resource> removedResources) {
        for (Resource removedResource : removedResources) {
            for (EObject root : removedResource.getContents()) {
                for (Adapter adapter : root.eAdapters()) {
                    if (!(adapter instanceof ElementListAdapter)) continue;
                    ((ElementListAdapter)adapter).notifyChangesOnElement(null);
                }
            }
            removedResource.unload();
            this.repository.getResourceSet().getResources().remove((Object)removedResource);
            this.notifyListeners(removedResource);
        }
    }

    private void notifyListeners(Resource resource) {
        for (WorkspaceTypeListener listener : this.workspaceSessionListeners) {
            listener.notifyResourceChanged(resource);
        }
        for (EObject root : Sets.newLinkedHashSet((Iterable)resource.getContents())) {
            for (ElementListAdapter elementListAdapter : Sets.newLinkedHashSet((Iterable)Iterables.filter((Iterable)root.eAdapters(), ElementListAdapter.class))) {
                elementListAdapter.notifyChangesOnElement(root);
            }
        }
    }

    public boolean isRepositoryResource(IResource resource) {
        boolean isRepositoryResource = false;
        isRepositoryResource = "xmi".equals(resource.getFileExtension());
        isRepositoryResource = isRepositoryResource && this.repository.isInRepositoryPath(resource.getFullPath().toString());
        return isRepositoryResource;
    }

    public void addSavedResource(Resource savedResource) {
        if (!this.savedResources.contains(savedResource)) {
            this.savedResources.add(savedResource);
        }
    }

    public void addListener(WorkspaceTypeListener typeListener) {
        this.workspaceSessionListeners.add(typeListener);
    }

    public void removeListener(WorkspaceTypeListener typeListener) {
        this.workspaceSessionListeners.remove(typeListener);
    }

    public boolean isProcessingDelta() {
        return ResourcesPlugin.getWorkspace().isTreeLocked() && !this.isBusy;
    }

    public void close() {
        this.repository = null;
        this.repositoryAdapter = null;
    }
}

