/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.compiler.saver;

import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.util.ObjectNotFoundException;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mylyn.docs.intent.client.compiler.utils.IntentCompilerInformationHolder;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IIntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IntentLogger;
import org.eclipse.mylyn.docs.intent.collab.handlers.RepositoryObjectHandler;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.ReadOnlyException;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationMessageType;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatusManager;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatusSeverity;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilerFactory;
import org.eclipse.mylyn.docs.intent.core.compiler.TraceabilityIndex;
import org.eclipse.mylyn.docs.intent.core.compiler.TraceabilityIndexEntry;
import org.eclipse.mylyn.docs.intent.core.document.IntentGenericElement;
import org.eclipse.mylyn.docs.intent.core.genericunit.UnitInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnit;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ResourceDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerInformationsSaver {
    private Map<ResourceDeclaration, Map<EObject, IntentGenericElement>> resourceToTraceabilityElementIndexEntry;
    private IProgressMonitor progressMonitor;

    public CompilerInformationsSaver(IProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    public void saveOnRepository(IntentCompilerInformationHolder informationHolder, RepositoryObjectHandler handler) {
        this.resourceToTraceabilityElementIndexEntry = new HashMap<ResourceDeclaration, Map<EObject, IntentGenericElement>>();
        try {
            if (!this.progressMonitor.isCanceled()) {
                Map<ResourceDeclaration, String> resourceToGeneratedPath = this.saveGeneratedResources(informationHolder, handler);
                if (!this.progressMonitor.isCanceled()) {
                    this.saveStatusInformations(informationHolder, handler);
                }
                if (!this.progressMonitor.isCanceled()) {
                    this.saveTraceabilityInformations(resourceToGeneratedPath, handler, informationHolder);
                }
            }
        }
        catch (Exception e) {
            IntentLogger.getInstance().log(IIntentLogger.LogType.ERROR, "Compiler failed to save changes", (Throwable)e);
            try {
                handler.getRepositoryAdapter().undo();
            }
            catch (ReadOnlyException readOnlyException) {
                IntentLogger.getInstance().log(IIntentLogger.LogType.ERROR, "Compiler failed to save changes", (Throwable)e);
            }
        }
    }

    private Map<ResourceDeclaration, String> saveGeneratedResources(IntentCompilerInformationHolder informationHolder, RepositoryObjectHandler handler) throws ReadOnlyException {
        HashMap<ResourceDeclaration, String> resourceInfos = new HashMap<ResourceDeclaration, String>();
        for (ResourceDeclaration resource : informationHolder.getDeclaredResources()) {
            String internalResourcePath;
            if (this.progressMonitor.isCanceled() || (internalResourcePath = this.getInternalResourcePath(resource)) == null) continue;
            Resource generatedResource = handler.getRepositoryAdapter().getOrCreateResource(internalResourcePath);
            resourceInfos.put(resource, internalResourcePath);
            generatedResource.getContents().clear();
            this.updateTraceabilityFromResourceContent(resource, informationHolder, informationHolder.getResourceContent(resource));
            generatedResource.getContents().addAll(informationHolder.getResourceContent(resource));
        }
        return resourceInfos;
    }

    private void updateTraceabilityFromResourceContent(ResourceDeclaration resource, IntentCompilerInformationHolder informationHolder, EList<EObject> elementsToConsider) {
        for (EObject element : elementsToConsider) {
            UnitInstruction instruction;
            if (this.progressMonitor.isCanceled() || (instruction = informationHolder.getInstructionByCreatedElement(element)) == null) continue;
            if (this.resourceToTraceabilityElementIndexEntry.get(resource) == null) {
                this.resourceToTraceabilityElementIndexEntry.put(resource, new HashMap());
            }
            this.resourceToTraceabilityElementIndexEntry.get(resource).put(element, (IntentGenericElement)instruction);
            this.updateTraceabilityFromResourceContent(resource, informationHolder, (EList<EObject>)element.eContents());
        }
    }

    private void saveStatusInformations(IntentCompilerInformationHolder informationHolder, RepositoryObjectHandler handler) throws ReadOnlyException {
        Resource resourceForCompilationStatusList = handler.getRepositoryAdapter().getOrCreateResource("/COMPILATION/STATUS/StatusIndex");
        if (resourceForCompilationStatusList.getContents().isEmpty()) {
            resourceForCompilationStatusList.getContents().add((Object)CompilerFactory.eINSTANCE.createCompilationStatusManager());
        }
        CompilationStatusManager manager = (CompilationStatusManager)resourceForCompilationStatusList.getContents().get(0);
        if (!this.progressMonitor.isCanceled()) {
            this.mergeCompilationStatusManager(informationHolder.getStatusManager(), manager, resourceForCompilationStatusList);
        }
    }

    private void saveTraceabilityInformations(Map<ResourceDeclaration, String> resourceToGeneratedPath, RepositoryObjectHandler handler, IntentCompilerInformationHolder informationHolder) throws ReadOnlyException {
        Resource traceabilityResource = handler.getRepositoryAdapter().getResource("/COMPILATION/TRACES/TraceabilityIndex");
        if (traceabilityResource.getContents().isEmpty()) {
            traceabilityResource.getContents().add((Object)CompilerFactory.eINSTANCE.createTraceabilityIndex());
        }
        TraceabilityIndex traceIndex = (TraceabilityIndex)traceabilityResource.getContents().get(0);
        ArrayList<TraceabilityIndexEntry> newTraceabilityEntries = new ArrayList<TraceabilityIndexEntry>();
        LinkedHashSet handledInstructions = Sets.newLinkedHashSet();
        for (ResourceDeclaration resourceDeclaration : resourceToGeneratedPath.keySet()) {
            TraceabilityIndexEntry entry = CompilerFactory.eINSTANCE.createTraceabilityIndexEntry();
            entry.setCompilationTime(BigInteger.valueOf(System.currentTimeMillis()));
            entry.setGeneratedResourcePath(resourceToGeneratedPath.get(resourceDeclaration));
            entry.setResourceDeclaration(resourceDeclaration);
            if (this.resourceToTraceabilityElementIndexEntry.get(resourceDeclaration) != null) {
                entry.getContainedElementToInstructions().putAll(this.resourceToTraceabilityElementIndexEntry.get(resourceDeclaration));
                handledInstructions.addAll(this.resourceToTraceabilityElementIndexEntry.get(resourceDeclaration).values());
            }
            newTraceabilityEntries.add(entry);
        }
        Sets.SetView instanciationsInstructionNotContainedInResource = Sets.difference(informationHolder.getAllInstanciationsInstructions(), (Set)handledInstructions);
        if (!instanciationsInstructionNotContainedInResource.isEmpty()) {
            TraceabilityIndexEntry entry = CompilerFactory.eINSTANCE.createTraceabilityIndexEntry();
            entry.setCompilationTime(BigInteger.valueOf(System.currentTimeMillis()));
            for (UnitInstruction instruction : instanciationsInstructionNotContainedInResource) {
                entry.getContainedElementToInstructions().put((Object)instruction, (Object)instruction);
            }
            newTraceabilityEntries.add(entry);
        }
        traceIndex.getEntries().clear();
        traceIndex.getEntries().addAll(newTraceabilityEntries);
    }

    /*
     * Enabled aggressive block sorting
     */
    private String getInternalResourcePath(ResourceDeclaration resource) {
        String resourcePath;
        block4: {
            resourcePath = null;
            if (resource.getUri() == null) {
                String resourceName = resource.getName();
                if (resourceName != null && resourceName.length() > 0) {
                    resourcePath = resourceName;
                    break block4;
                } else {
                    CompilationStatus status = CompilerFactory.eINSTANCE.createCompilationStatus();
                    status.setSeverity(CompilationStatusSeverity.ERROR);
                    status.setTarget((IntentGenericElement)resource);
                    status.setType(CompilationMessageType.VALIDATION_ERROR);
                    status.setMessage("As this resource has no URI, it should have a name to be identifed.");
                    resource.getCompilationStatus().add((Object)status);
                    return "unnamed-resource.xmi";
                }
            }
            resourcePath = ((String)resource.getUri()).replace("\"", "");
            if (resourcePath.contains("/")) {
                resourcePath = resourcePath.substring(resourcePath.lastIndexOf(47) + 1);
            }
        }
        resourcePath = resourcePath.replace("*", "").replace("?", "");
        return "/COMPILATION/GENERATED/" + resourcePath;
    }

    private boolean isContainedCompilationStatus(EList<CompilationStatus> statusList, CompilationStatus status) {
        boolean statusIsContainedInList = false;
        if (statusList != null) {
            Iterator iterator = statusList.iterator();
            while (iterator.hasNext() && !statusIsContainedInList) {
                CompilationStatus containedStatus = (CompilationStatus)iterator.next();
                statusIsContainedInList = this.isSimilarStatus(containedStatus, status);
            }
        }
        return statusIsContainedInList;
    }

    private boolean isSimilarStatus(CompilationStatus containedStatus, CompilationStatus status) {
        try {
            return containedStatus.getMessage().equals(status.getMessage()) && containedStatus.getSeverity().equals((Object)status.getSeverity()) && containedStatus.getType().equals((Object)status.getType());
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    private void mergeCompilationStatusManager(CompilationStatusManager localStatusManager, CompilationStatusManager repositoryStatusManager, Resource statusManagerResource) {
        this.removeDanglingReferences(repositoryStatusManager, statusManagerResource);
        ArrayList<IntentGenericElement> genEl = new ArrayList<IntentGenericElement>();
        for (CompilationStatus compilationStatus : repositoryStatusManager.getCompilationStatusList()) {
            genEl.add(compilationStatus.getTarget());
        }
        ArrayList<IntentGenericElement> cleanTargets = new ArrayList<IntentGenericElement>();
        for (ModelingUnit mu : localStatusManager.getModelingUnitToStatusList().keySet()) {
            for (CompilationStatus status : (EList)localStatusManager.getModelingUnitToStatusList().get((Object)mu)) {
                if (this.progressMonitor.isCanceled() || this.isContainedCompilationStatus((EList<CompilationStatus>)((EList)repositoryStatusManager.getModelingUnitToStatusList().get((Object)mu)), status)) continue;
                if (!repositoryStatusManager.getCompilationStatusList().contains((Object)status)) {
                    repositoryStatusManager.getCompilationStatusList().add((Object)status);
                    if (!status.getTarget().getCompilationStatus().contains((Object)status)) {
                        if (!cleanTargets.contains(status.getTarget())) {
                            cleanTargets.add(status.getTarget());
                            status.getTarget().getCompilationStatus().clear();
                        }
                        status.getTarget().getCompilationStatus().add((Object)status);
                    }
                }
                if (repositoryStatusManager.getModelingUnitToStatusList().get((Object)mu) == null) {
                    repositoryStatusManager.getModelingUnitToStatusList().put((Object)mu, (Object)new BasicEList());
                }
                try {
                    ((EList)repositoryStatusManager.getModelingUnitToStatusList().get((Object)mu)).add((Object)status);
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
            }
        }
        genEl = new ArrayList();
        for (CompilationStatus compilationStatus : repositoryStatusManager.getCompilationStatusList()) {
            genEl.add(compilationStatus.getTarget());
        }
    }

    private CompilationStatusManager removeDanglingReferences(CompilationStatusManager repositoryStatusManager, Resource statusManagerResource) {
        CompilationStatusManager manager = repositoryStatusManager;
        try {
            manager.getCompilationStatusList().clear();
            manager.getModelingUnitToStatusList().clear();
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            statusManagerResource.getContents().clear();
            manager = CompilerFactory.eINSTANCE.createCompilationStatusManager();
            statusManagerResource.getContents().add((Object)manager);
        }
        return manager;
    }
}

