/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.synchronizer.factory;

import java.util.ArrayList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;

public final class SynchonizerEObjectNameGetter {
    private static final ComposedAdapterFactory FACTORY = SynchonizerEObjectNameGetter.createAdapterFactory();
    private static AdapterFactoryLabelProvider labelProvider;

    private SynchonizerEObjectNameGetter() {
    }

    public static String computeObjectName(EObject eObject) {
        String objectName = null;
        try {
            objectName = SynchonizerEObjectNameGetter.getLabelProvider().getText((Object)eObject);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectName = null;
        }
        if (objectName == null || "".equals(objectName)) {
            objectName = "untitled " + eObject.eClass().getName();
        }
        return objectName;
    }

    private static AdapterFactoryLabelProvider getLabelProvider() {
        if (labelProvider == null) {
            labelProvider = new AdapterFactoryLabelProvider(SynchonizerEObjectNameGetter.getAdapterFactory());
        }
        return labelProvider;
    }

    public static AdapterFactory getAdapterFactory() {
        return FACTORY;
    }

    private static ComposedAdapterFactory createAdapterFactory() {
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));
        factories.add(new ReflectiveItemProviderAdapterFactory());
        return new ComposedAdapterFactory(factories);
    }
}

