/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.synchronizer.launcher;

import java.util.LinkedHashSet;
import org.eclipse.emf.common.util.URI;
import org.eclipse.mylyn.docs.intent.client.synchronizer.SynchronizerRepositoryClient;
import org.eclipse.mylyn.docs.intent.client.synchronizer.listeners.GeneratedElementListener;
import org.eclipse.mylyn.docs.intent.collab.common.query.CompilationStatusQuery;
import org.eclipse.mylyn.docs.intent.collab.common.query.TraceabilityInformationsQuery;
import org.eclipse.mylyn.docs.intent.collab.handlers.RepositoryObjectHandler;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.ReadOnlyException;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.collab.handlers.impl.ReadWriteRepositoryObjectHandlerImpl;
import org.eclipse.mylyn.docs.intent.collab.handlers.impl.notification.elementList.ElementListAdapter;
import org.eclipse.mylyn.docs.intent.collab.handlers.impl.notification.elementList.ElementListNotificator;
import org.eclipse.mylyn.docs.intent.collab.handlers.notification.Notificator;
import org.eclipse.mylyn.docs.intent.collab.repository.Repository;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryConnectionException;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatusManager;
import org.eclipse.mylyn.docs.intent.core.compiler.TraceabilityIndex;
import org.eclipse.mylyn.docs.intent.core.compiler.TraceabilityIndexEntry;

public final class SynchronizerCreator {
    private SynchronizerCreator() {
    }

    public static SynchronizerRepositoryClient createSynchronizer(Repository repository, GeneratedElementListener generatedElementListener) throws RepositoryConnectionException, ReadOnlyException {
        RepositoryAdapter repositoryAdapter = repository.createRepositoryAdapter();
        LinkedHashSet<TraceabilityIndex> listenedElements = new LinkedHashSet<TraceabilityIndex>();
        repositoryAdapter.openSaveContext();
        TraceabilityIndex traceabilityIndex = new TraceabilityInformationsQuery(repositoryAdapter).getOrCreateTraceabilityIndex();
        CompilationStatusManager statusManager = new CompilationStatusQuery(repositoryAdapter).getOrCreateCompilationStatusManager();
        listenedElements.add(traceabilityIndex);
        ReadWriteRepositoryObjectHandlerImpl handler = new ReadWriteRepositoryObjectHandlerImpl(repositoryAdapter);
        ElementListAdapter adapter = new ElementListAdapter();
        ElementListNotificator listenedElementsNotificator = new ElementListNotificator(listenedElements, adapter, repositoryAdapter);
        handler.addNotificator((Notificator)listenedElementsNotificator);
        SynchronizerRepositoryClient synchronizerClient = new SynchronizerRepositoryClient(traceabilityIndex, statusManager);
        synchronizerClient.addRepositoryObjectHandler((RepositoryObjectHandler)handler);
        synchronizerClient.setGeneratedElementListener(generatedElementListener);
        for (TraceabilityIndexEntry indexEntry : traceabilityIndex.getEntries()) {
            String resourceURI;
            if (indexEntry.getResourceDeclaration() == null || indexEntry.getResourceDeclaration().getUri() == null || (resourceURI = indexEntry.getResourceDeclaration().getUri().toString()) == null) continue;
            generatedElementListener.addElementToListen(URI.createURI((String)resourceURI));
        }
        repositoryAdapter.closeContext();
        return synchronizerClient;
    }
}

