/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.modelingunit.update;

import java.util.ArrayList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IIntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IntentLogger;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.IntentCommand;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.ReadOnlyException;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.SaveException;
import org.eclipse.mylyn.docs.intent.core.compiler.ModelElementChangeStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.ReferenceChangeStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.StructuralFeatureChangeStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.SynchronizerCompilationStatus;
import org.eclipse.mylyn.docs.intent.core.document.IntentGenericElement;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ContributionInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.InstanciationInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.StructuralFeatureAffectation;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ValueForStructuralFeature;
import org.eclipse.mylyn.docs.intent.modelingunit.update.AbstractModelingUnitUpdater;

public class SyncStatusUpdater
extends AbstractModelingUnitUpdater {
    public SyncStatusUpdater(RepositoryAdapter repositoryAdapter) {
        super(repositoryAdapter);
    }

    private void initMatch(SynchronizerCompilationStatus status) {
        Resource compiledResource = this.repositoryAdapter.getResource(status.getCompiledResourceURI());
        Resource workingCopyResource = this.resourceSet.getResource(URI.createURI((String)status.getWorkingCopyResourceURI().replaceAll("\"", "")), true);
        this.includeMatch(compiledResource, workingCopyResource);
    }

    public void fixSynchronizationStatus(final SynchronizerCompilationStatus ... statusToFix) {
        this.repositoryAdapter.execute(new IntentCommand(){

            public void execute() {
                SynchronizerCompilationStatus[] synchronizerCompilationStatusArray = statusToFix;
                int n = statusToFix.length;
                int n2 = 0;
                while (n2 < n) {
                    SynchronizerCompilationStatus status = synchronizerCompilationStatusArray[n2];
                    SyncStatusUpdater.this.initMatch(status);
                    switch (status.eClass().getClassifierID()) {
                        case 19: {
                            SyncStatusUpdater.this.fixModelElementChange((ModelElementChangeStatus)status);
                            break;
                        }
                        case 21: 
                        case 22: {
                            SyncStatusUpdater.this.fixStructuralFeatureChange((StructuralFeatureChangeStatus)status);
                            break;
                        }
                    }
                    ++n2;
                }
                try {
                    SyncStatusUpdater.this.repositoryAdapter.save();
                }
                catch (ReadOnlyException e) {
                    IntentLogger.getInstance().log(IIntentLogger.LogType.ERROR, e.getMessage());
                }
                catch (SaveException e) {
                    IntentLogger.getInstance().log(IIntentLogger.LogType.ERROR, e.getMessage());
                }
            }
        });
    }

    private void fixModelElementChange(ModelElementChangeStatus status) {
        IntentGenericElement target = status.getTarget();
        switch (status.getChangeState().getValue()) {
            case 2: {
                IntentGenericElement container = SyncStatusUpdater.getContainer(target, 18, 12);
                if (container instanceof ContributionInstruction) {
                    ContributionInstruction contribution = (ContributionInstruction)container;
                    container = contribution.getReferencedElement().getReferencedElement();
                }
                if (!(container instanceof InstanciationInstruction)) break;
                InstanciationInstruction instanciation = (InstanciationInstruction)container;
                EObject workingCopyObject = this.getWorkingCopyEObject(status.getWorkingCopyElementURIFragment());
                ArrayList<EObject> newObjects = new ArrayList<EObject>();
                TreeIterator iterator = workingCopyObject.eAllContents();
                while (iterator.hasNext()) {
                    newObjects.add((EObject)iterator.next());
                }
                this.setNewObjects(newObjects);
                StructuralFeatureAffectation affectation = this.generateAffectation(workingCopyObject.eContainingFeature(), workingCopyObject);
                if (affectation == null) break;
                instanciation.getStructuralFeatures().add((Object)affectation);
                break;
            }
            case 3: {
                IntentGenericElement affectation = SyncStatusUpdater.getContainer(target, 13);
                if (!(affectation instanceof StructuralFeatureAffectation)) break;
                this.removeAffectation((StructuralFeatureAffectation)affectation);
                break;
            }
            default: {
                IntentLogger.getInstance().log(IIntentLogger.LogType.INFO, "UNSUPPORTED MODEL ELEMENT CHANGE: " + status.getMessage() + '(' + status.getChangeState() + ')');
            }
        }
    }

    private void fixStructuralFeatureChange(StructuralFeatureChangeStatus status) {
        EObject element = this.getWorkingCopyEObject(status.getWorkingCopyElementURIFragment());
        EStructuralFeature feature = element.eClass().getEStructuralFeature(status.getFeatureName());
        Object newValue = null;
        if (status instanceof ReferenceChangeStatus) {
            newValue = this.getWorkingCopyEObject(((ReferenceChangeStatus)status).getWorkingCopyTargetURIFragment());
        }
        if (newValue == null) {
            newValue = element.eGet(feature);
        }
        switch (status.getChangeState().getValue()) {
            case 0: {
                StructuralFeatureAffectation newAffectation;
                if (status.getTarget() instanceof ValueForStructuralFeature) {
                    if (newValue == null) {
                        IntentGenericElement affectation = SyncStatusUpdater.getContainer(status.getTarget(), 13);
                        if (!(affectation instanceof StructuralFeatureAffectation)) break;
                        this.removeAffectation((StructuralFeatureAffectation)affectation);
                        break;
                    }
                    this.setValue((ValueForStructuralFeature)status.getTarget(), newValue);
                    break;
                }
                if (!(status.getTarget() instanceof InstanciationInstruction) || (newAffectation = this.generateAffectation(feature, newValue)) == null) break;
                this.addAffectation((IntentGenericElement)((InstanciationInstruction)status.getTarget()), newAffectation);
                break;
            }
            case 3: {
                IntentGenericElement affectation = SyncStatusUpdater.getContainer(status.getTarget(), 13);
                if (!(affectation instanceof StructuralFeatureAffectation)) break;
                this.removeAffectation((StructuralFeatureAffectation)affectation);
                break;
            }
            case 2: {
                StructuralFeatureAffectation newAffectation = this.generateAffectation(feature, newValue);
                IntentGenericElement container = SyncStatusUpdater.getContainer(status.getTarget(), 18, 12);
                this.addAffectation(container, newAffectation);
                break;
            }
            default: {
                IntentLogger.getInstance().log(IIntentLogger.LogType.INFO, "UNSUPPORTED CHANGE: " + status.getMessage() + " (" + status.getChangeState() + ')');
            }
        }
    }

    private void addAffectation(IntentGenericElement container, StructuralFeatureAffectation affectation) {
        if (container instanceof ContributionInstruction) {
            ContributionInstruction contribution = (ContributionInstruction)container;
            contribution.getContributions().add((Object)affectation);
        } else if (container instanceof InstanciationInstruction) {
            InstanciationInstruction instanciation = (InstanciationInstruction)container;
            instanciation.getStructuralFeatures().add((Object)affectation);
        }
    }

    private void removeAffectation(StructuralFeatureAffectation affectation) {
        IntentGenericElement container = SyncStatusUpdater.getContainer((IntentGenericElement)affectation, 18, 12);
        if (container instanceof ContributionInstruction) {
            ContributionInstruction contribution = (ContributionInstruction)container;
            contribution.getContributions().remove((Object)affectation);
        } else if (container instanceof InstanciationInstruction) {
            InstanciationInstruction instanciation = (InstanciationInstruction)container;
            instanciation.getStructuralFeatures().remove((Object)affectation);
        }
    }
}

