/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.core.compiler;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CompilationMessageType implements Enumerator
{
    RESOLVE_ERROR(0, "RESOLVE_ERROR", "RESOLVE_ERROR"),
    PACKAGE_NOT_FOUND_ERROR(1, "PACKAGE_NOT_FOUND_ERROR", "PACKAGE_NOT_FOUND_ERROR"),
    PACKAGE_REGISTRATION_ERROR(2, "PACKAGE_REGISTRATION_ERROR", "PACKAGE_REGISTRATION_ERROR"),
    INVALID_REFERENCE_ERROR(3, "INVALID_REFERENCE_ERROR", "INVALID_REFERENCE_ERROR"),
    VALIDATION_ERROR(4, "VALIDATION_ERROR", "VALIDATION_ERROR"),
    INVALID_VALUE_ERROR(5, "INVALID_VALUE_ERROR", "INVALID_VALUE_ERROR"),
    GENERAL_WARNING(6, "GENERAL_WARNING", "GENERAL_WARNING"),
    SYNCHRONIZER_WARNING(7, "SYNCHRONIZER_WARNING", "SYNCHRONIZER_WARNING"),
    SYNCHRONIZER_INFO(8, "SYNCHRONIZER_INFO", "SYNCHRONIZER_INFO");

    public static final int RESOLVE_ERROR_VALUE = 0;
    public static final int PACKAGE_NOT_FOUND_ERROR_VALUE = 1;
    public static final int PACKAGE_REGISTRATION_ERROR_VALUE = 2;
    public static final int INVALID_REFERENCE_ERROR_VALUE = 3;
    public static final int VALIDATION_ERROR_VALUE = 4;
    public static final int INVALID_VALUE_ERROR_VALUE = 5;
    public static final int GENERAL_WARNING_VALUE = 6;
    public static final int SYNCHRONIZER_WARNING_VALUE = 7;
    public static final int SYNCHRONIZER_INFO_VALUE = 8;
    private static final CompilationMessageType[] VALUES_ARRAY;
    public static final List<CompilationMessageType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CompilationMessageType[]{RESOLVE_ERROR, PACKAGE_NOT_FOUND_ERROR, PACKAGE_REGISTRATION_ERROR, INVALID_REFERENCE_ERROR, VALIDATION_ERROR, INVALID_VALUE_ERROR, GENERAL_WARNING, SYNCHRONIZER_WARNING, SYNCHRONIZER_INFO};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CompilationMessageType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CompilationMessageType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CompilationMessageType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CompilationMessageType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CompilationMessageType get(int value) {
        switch (value) {
            case 0: {
                return RESOLVE_ERROR;
            }
            case 1: {
                return PACKAGE_NOT_FOUND_ERROR;
            }
            case 2: {
                return PACKAGE_REGISTRATION_ERROR;
            }
            case 3: {
                return INVALID_REFERENCE_ERROR;
            }
            case 4: {
                return VALIDATION_ERROR;
            }
            case 5: {
                return INVALID_VALUE_ERROR;
            }
            case 6: {
                return GENERAL_WARNING;
            }
            case 7: {
                return SYNCHRONIZER_WARNING;
            }
            case 8: {
                return SYNCHRONIZER_INFO;
            }
        }
        return null;
    }

    private CompilationMessageType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

