/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor.annotation;

import org.eclipse.jface.text.source.Annotation;
import org.eclipse.mylyn.docs.intent.client.ui.editor.annotation.IntentAnnotation;
import org.eclipse.mylyn.docs.intent.client.ui.editor.annotation.IntentAnnotationMessageType;
import org.eclipse.mylyn.docs.intent.client.ui.editor.annotation.image.IntentImageAnnotation;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationMessageType;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatus;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ExternalContentReference;

public final class IntentAnnotationFactory {
    public static final String INTENT_ANNOT_COMPILER_ERROR = "org.eclipse.mylyn.docs.intent.client.ui.annotation.compiler.error";
    public static final String INTENT_ANNOT_COMPILER_WARNING = "org.eclipse.mylyn.docs.intent.client.ui.annotation.compiler.warning";
    public static final String INTENT_ANNOT_GENERAL_INFO = "org.eclipse.mylyn.docs.intent.client.ui.annotation.info";
    public static final String INTENT_ANNOT_SYNTAX_ERROR = "org.eclipse.mylyn.docs.intent.client.ui.annotation.syntaxerror";
    public static final String INTENT_ANNOT_SYNC_WARNING = "org.eclipse.mylyn.docs.intent.client.ui.annotation.sync.warning";
    public static final String INTENT_IMAGE = "org.eclipse.mylyn.docs.intent.client.ui.annotation.image";

    private IntentAnnotationFactory() {
    }

    public static Annotation createAnnotationFromCompilationStatus(CompilationStatus compilationStatus) {
        IntentAnnotation annotation = new IntentAnnotation(true);
        annotation.setCompilationStatus(compilationStatus);
        annotation.setText(compilationStatus.getMessage());
        IntentAnnotationMessageType annotationMessageType = null;
        switch (compilationStatus.getSeverity()) {
            case ERROR: {
                annotation.setType(INTENT_ANNOT_COMPILER_ERROR);
                annotationMessageType = IntentAnnotationMessageType.COMPILER_ERROR;
                break;
            }
            case WARNING: {
                if (compilationStatus.getType() == CompilationMessageType.SYNCHRONIZER_WARNING) {
                    annotation.setType(INTENT_ANNOT_SYNC_WARNING);
                    annotationMessageType = IntentAnnotationMessageType.SYNC_WARNING;
                    break;
                }
                annotation.setType(INTENT_ANNOT_COMPILER_WARNING);
                annotationMessageType = IntentAnnotationMessageType.COMPILER_INFO;
                break;
            }
            default: {
                annotation.setType(INTENT_ANNOT_GENERAL_INFO);
                annotationMessageType = IntentAnnotationMessageType.COMPILER_INFO;
            }
        }
        annotation.setMessageType(annotationMessageType);
        return annotation;
    }

    public static IntentAnnotation createSyntaxErrorAnnotation() {
        IntentAnnotation annotation = new IntentAnnotation(true);
        annotation.setType(INTENT_ANNOT_SYNTAX_ERROR);
        annotation.setMessageType(IntentAnnotationMessageType.PARSER_ERROR);
        return annotation;
    }

    public static IntentImageAnnotation createImageAnnotation(ExternalContentReference reference) {
        return new IntentImageAnnotation(reference);
    }
}

