/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor.annotation;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.mylyn.docs.intent.client.ui.editor.annotation.IntentAnnotation;
import org.eclipse.mylyn.docs.intent.client.ui.editor.annotation.IntentAnnotationFactory;
import org.eclipse.mylyn.docs.intent.client.ui.editor.annotation.image.IntentImageAnnotation;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatus;
import org.eclipse.mylyn.docs.intent.core.document.IntentGenericElement;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ExternalContentReference;
import org.eclipse.mylyn.docs.intent.serializer.ParsedElementPosition;

public class IntentAnnotationModelManager {
    private AnnotationModel annotationModel = new AnnotationModel();
    private Map<CompilationStatus, Annotation> handledCompilationStatus = new HashMap<CompilationStatus, Annotation>();

    public void addAnnotationFromStatus(RepositoryAdapter repositoryAdapter, CompilationStatus status, Position position) {
        if (!this.handledCompilationStatus.containsKey(status)) {
            Annotation annotation = IntentAnnotationFactory.createAnnotationFromCompilationStatus(status);
            this.addAnnotation(annotation, position);
            this.handledCompilationStatus.put(status, annotation);
        }
    }

    private synchronized void addAnnotation(Annotation annotation, Position position) {
        this.annotationModel.addAnnotation(annotation, position);
    }

    public IAnnotationModel getAnnotationModel() {
        return this.annotationModel;
    }

    public synchronized void removeAllCompilerAnnotations() {
        Iterator annotationIterator = this.annotationModel.getAnnotationIterator();
        while (annotationIterator.hasNext()) {
            Annotation annotation = (Annotation)annotationIterator.next();
            if (!this.isCompilerAnnotation(annotation.getType())) continue;
            this.annotationModel.removeAnnotation(annotation);
        }
        this.handledCompilationStatus.clear();
    }

    public synchronized void removeInvalidCompilerAnnotations(RepositoryAdapter adapter, IntentGenericElement element) {
        Iterator<CompilationStatus> compilationStatusIterator = this.handledCompilationStatus.keySet().iterator();
        while (compilationStatusIterator.hasNext()) {
            CompilationStatus currentStatus = compilationStatusIterator.next();
            boolean removeCurrentStatus = currentStatus == null || currentStatus.getTarget() == null;
            Object currentStatusTargetID = null;
            Object elementID = null;
            if (!removeCurrentStatus) {
                currentStatusTargetID = adapter.getIDFromElement((EObject)currentStatus.getTarget());
                elementID = adapter.getIDFromElement((EObject)element);
                boolean bl = removeCurrentStatus = currentStatusTargetID == null;
            }
            if (!removeCurrentStatus && currentStatusTargetID.equals(elementID) && this.isCompilerAnnotation(this.handledCompilationStatus.get(currentStatus).getType()) && !element.getCompilationStatus().contains((Object)currentStatus)) {
                removeCurrentStatus = true;
            }
            if (!removeCurrentStatus) continue;
            this.annotationModel.removeAnnotation(this.handledCompilationStatus.get(currentStatus));
            compilationStatusIterator.remove();
        }
    }

    public void createSyntaxErrorAnnotation(String message, int offset, int length) {
        IntentAnnotation syntaxErrorAnnotation = IntentAnnotationFactory.createSyntaxErrorAnnotation();
        syntaxErrorAnnotation.setText(message);
        Position position = new Position(offset, length);
        this.addAnnotation(syntaxErrorAnnotation, position);
    }

    public synchronized void removeSyntaxErrorsAnnotations() {
        Iterator annotationIterator = this.annotationModel.getAnnotationIterator();
        while (annotationIterator.hasNext()) {
            Annotation next = (Annotation)annotationIterator.next();
            if (!"org.eclipse.mylyn.docs.intent.client.ui.annotation.syntaxerror".equals(next.getType())) continue;
            this.annotationModel.removeAnnotation(next);
        }
    }

    private boolean isCompilerAnnotation(String type) {
        return "org.eclipse.mylyn.docs.intent.client.ui.annotation.compiler.error".equals(type) || "org.eclipse.mylyn.docs.intent.client.ui.annotation.compiler.warning".equals(type) || "org.eclipse.mylyn.docs.intent.client.ui.annotation.info".equals(type) || "org.eclipse.mylyn.docs.intent.client.ui.annotation.sync.warning".equals(type);
    }

    public void updateAnnotationFromExternalContentReference(ExternalContentReference reference, ParsedElementPosition intentPosition) {
        if (intentPosition != null) {
            boolean foundAlredyExistingAnnotation = false;
            Iterator annotationIterator = this.getAnnotationModel().getAnnotationIterator();
            while (annotationIterator.hasNext() && !foundAlredyExistingAnnotation) {
                Object annotation = annotationIterator.next();
                if (!(annotation instanceof IntentImageAnnotation) || !((IntentImageAnnotation)((Object)annotation)).getExternalContentReference().getUri().equals(reference.getUri())) continue;
                foundAlredyExistingAnnotation = true;
                ((IntentImageAnnotation)((Object)annotation)).setImageShouldBeRedrawn(true);
            }
            if (!foundAlredyExistingAnnotation) {
                this.getAnnotationModel().addAnnotation((Annotation)IntentAnnotationFactory.createImageAnnotation(reference), new Position(intentPosition.getOffset() + intentPosition.getLength(), 0));
            }
        }
    }
}

