/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor.scanner;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.mylyn.docs.intent.client.ui.editor.configuration.ColorManager;
import org.eclipse.mylyn.docs.intent.client.ui.editor.configuration.IntentColorConstants;
import org.eclipse.mylyn.docs.intent.client.ui.editor.configuration.IntentFontConstants;
import org.eclipse.mylyn.docs.intent.client.ui.editor.rules.KeywordRule;
import org.eclipse.mylyn.docs.intent.client.ui.editor.scanner.AbstractIntentScanner;
import org.eclipse.mylyn.docs.intent.client.ui.editor.scanner.IntentWordDetector;
import org.eclipse.swt.graphics.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntentStructuredElementScanner
extends AbstractIntentScanner {
    public static final String CLOSING = "";
    private static String[] STRUCTURED_KEYWORDS = new String[]{"Chapter", "Document", "Section", "hidden", "internal", "{"};

    public IntentStructuredElementScanner(ColorManager colorManager) {
        super(colorManager);
        Color backgroundColor = colorManager.getColor(IntentColorConstants.getDuBackground());
        Color duForeGroundColor = colorManager.getColor(IntentColorConstants.getDuDefaultForeground());
        Token duToken = new Token((Object)new TextAttribute(duForeGroundColor, backgroundColor, 0, IntentFontConstants.getDescriptionFont()));
        Color defaultforeGroundColor = colorManager.getColor(IntentColorConstants.getDuTitleForeground());
        Token defaultToken = new Token((Object)new TextAttribute(defaultforeGroundColor, backgroundColor, 1, IntentFontConstants.getTitleFont()));
        Color keyWordForeGroundColor = colorManager.getColor(IntentColorConstants.getDuKeywordForeground());
        Token keyWordToken = new Token((Object)new TextAttribute(keyWordForeGroundColor, backgroundColor, 1));
        Color stringforeGroundColor = colorManager.getColor(IntentColorConstants.getMuStringForeground());
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(this.computeKeyWordRule((IToken)defaultToken, (IToken)keyWordToken));
        rules.addAll(this.computeStringRules(stringforeGroundColor));
        rules.add(new KeywordRule("{", true, true, (IToken)duToken));
        this.setRules(rules.toArray(new IRule[rules.size()]));
        this.setDefaultReturnToken((IToken)defaultToken);
    }

    private IRule computeKeyWordRule(IToken defaultToken, IToken keyWordToken) {
        WordRule keyWordsRule = new WordRule((IWordDetector)new IntentWordDetector(), defaultToken);
        int i = 0;
        while (i < STRUCTURED_KEYWORDS.length) {
            keyWordsRule.addWord(STRUCTURED_KEYWORDS[i], keyWordToken);
            ++i;
        }
        return keyWordsRule;
    }

    private Collection<? extends IRule> computeStringRules(Color stringforeGroundColor) {
        Token stringToken = new Token((Object)new TextAttribute(stringforeGroundColor, null, 2));
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new SingleLineRule("\"", "\"", (IToken)stringToken, '\\'));
        rules.add(new MultiLineRule("'", "'", (IToken)stringToken, '\\'));
        return rules;
    }

    @Override
    public String getConfiguredContentType() {
        return "__Intent__structuralcontent";
    }
}

