/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.parser.modelingunit.serializer.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnitInstructionReference;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ResourceDeclaration;
import org.eclipse.mylyn.docs.intent.parser.modelingunit.serializer.internal.ModelingUnitElementDispatcher;

public final class ResourceDeclarationSerializer {
    private ResourceDeclarationSerializer() {
    }

    public static String render(ResourceDeclaration resourceDeclaration, ModelingUnitElementDispatcher dispatcher) {
        StringBuilder renderedForm = new StringBuilder();
        int initialOffset = dispatcher.getCurrentOffset();
        renderedForm.append("Resource ");
        int declarationLength = renderedForm.length();
        if (resourceDeclaration.getName() != null && resourceDeclaration.getName().length() > 0) {
            renderedForm.append(resourceDeclaration.getName());
            declarationLength = renderedForm.length();
            renderedForm.append(" ");
        }
        renderedForm.append("{\n");
        if (resourceDeclaration.getUri() != null) {
            renderedForm.append("URI = " + resourceDeclaration.getUri() + ';' + "\n");
        }
        if (resourceDeclaration.getContentType() != null) {
            renderedForm.append("contentType = " + resourceDeclaration.getContentType() + ';' + "\n");
        }
        for (ModelingUnitInstructionReference content : resourceDeclaration.getContent()) {
            renderedForm.append("content += ");
            dispatcher.setCurrentOffset(initialOffset + renderedForm.length());
            renderedForm.append(String.valueOf((String)dispatcher.doSwitch((EObject)content)) + ';' + "\n");
        }
        renderedForm.append("}");
        if (resourceDeclaration.isLineBreak()) {
            renderedForm.append("\n");
        }
        dispatcher.getPositionManager().setPositionForInstruction((EObject)resourceDeclaration, initialOffset, renderedForm.length(), declarationLength);
        dispatcher.setCurrentOffset(initialOffset + renderedForm.length());
        return renderedForm.toString();
    }
}

