/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.bridge.java.ui.renderers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.docs.intent.bridge.java.Classifier;
import org.eclipse.mylyn.docs.intent.bridge.java.Field;
import org.eclipse.mylyn.docs.intent.bridge.java.Method;
import org.eclipse.mylyn.docs.intent.bridge.java.resource.factory.JavaClassExplorer;
import org.eclipse.mylyn.docs.intent.bridge.java.resource.factory.JavaResourceFactory;
import org.eclipse.mylyn.docs.intent.bridge.java.util.JavaBridgeSerializer;
import org.eclipse.mylyn.docs.intent.bridge.java.util.JavaBridgeUtils;
import org.eclipse.mylyn.docs.intent.client.ui.editor.renderers.IEditorRendererExtension;
import org.eclipse.mylyn.docs.intent.client.ui.logger.IntentUiLogger;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ExternalContentReference;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ResourceTransfer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaEditorRendererExtension
implements IEditorRendererExtension {
    private static final int JAVA_IMAGE_HEIGHT_MARGIN = 5;
    private static final int JAVA_IMAGE_WIDTH = 800;

    public boolean isRendererFor(ExternalContentReference externalContentReference) {
        return JavaBridgeUtils.isHandledByJavaBridge(URI.createURI((String)externalContentReference.getUri().toString().trim()));
    }

    public boolean openEditor(ExternalContentReference externalContentReference) {
        URI javaElementURI = URI.createURI((String)externalContentReference.getUri().toString().trim());
        IFile javaFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(javaElementURI.trimFragment().toString()));
        FileEditorInput editorInput = new FileEditorInput(javaFile);
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(javaElementURI.trimFragment().lastSegment());
        IEditorPart openedEditor = null;
        if (desc != null) {
            try {
                openedEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)editorInput, desc.getId());
            }
            catch (PartInitException e) {
                IntentUiLogger.logError((Throwable)e);
            }
        }
        if (openedEditor != null && javaElementURI.hasFragment()) {
            this.updateOpenedEditorSelection(openedEditor, javaFile, javaElementURI);
        }
        return true;
    }

    private void updateOpenedEditorSelection(IEditorPart openedEditor, IFile javaFile, URI javaElementURI) {
        EObject eJavaElement = new JavaResourceFactory().createResource(javaElementURI.trimFragment()).getEObject(javaElementURI.fragment());
        try {
            IType javaType = ((ICompilationUnit)JavaCore.create((IFile)javaFile)).getTypes()[0];
            IType matchingElement = null;
            if (eJavaElement instanceof Classifier) {
                matchingElement = javaType;
            } else if (eJavaElement instanceof Method) {
                IMethod[] iMethodArray = javaType.getMethods();
                int n = iMethodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod method = iMethodArray[n2];
                    if (method.getElementName().equals(((Method)eJavaElement).getSimpleName())) {
                        matchingElement = method;
                    }
                    ++n2;
                }
            } else if (eJavaElement instanceof Field) {
                matchingElement = javaType.getField(((Field)eJavaElement).getName());
            }
            if (matchingElement != null) {
                TextSelection textSelection = new TextSelection(matchingElement.getSourceRange().getOffset(), matchingElement.getSourceRange().getLength());
                openedEditor.getEditorSite().getSelectionProvider().setSelection((ISelection)textSelection);
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    public Collection<Transfer> getAdditionalTransfers() {
        ArrayList<Transfer> transfers = new ArrayList<Transfer>();
        transfers.add((Transfer)ResourceTransfer.getInstance());
        transfers.add((Transfer)LocalSelectionTransfer.getTransfer());
        return transfers;
    }

    public Collection<? extends EObject> getEObjectsFromDropTargetEvent(DropTargetEvent event) {
        LinkedHashSet<EObject> eObjects = new LinkedHashSet<EObject>();
        try {
            if (event.data instanceof IResource[]) {
                IResource[] droppedResources = (IResource[])event.data;
                int i = 0;
                while (i < droppedResources.length) {
                    eObjects.add((EObject)this.getJavaFactoryResourceFromIResource(droppedResources[i]).getContents().iterator().next());
                    ++i;
                }
            } else if (event.data instanceof IStructuredSelection) {
                for (Object element : (IStructuredSelection)event.data) {
                    if (element instanceof IMethod || element instanceof IField) {
                        String elementID = JavaClassExplorer.getMemberID((IMember)element);
                        String elementFragment = "//";
                        if (element instanceof IMethod) {
                            elementFragment = String.valueOf(elementFragment) + "@methods";
                        } else if (element instanceof IField) {
                            elementFragment = String.valueOf(elementFragment) + "@fields";
                        }
                        elementFragment = String.valueOf(elementFragment) + "[name='" + elementID + "']";
                        Resource javaResource = this.getJavaFactoryResourceFromIResource(((IMember)element).getResource());
                        if (elementID != null) {
                            eObjects.add(javaResource.getEObject(elementFragment));
                            continue;
                        }
                        eObjects.add((EObject)javaResource.getContents().iterator().next());
                        continue;
                    }
                    if (element instanceof ICompilationUnit) {
                        eObjects.add((EObject)this.getJavaFactoryResourceFromIResource(((ICompilationUnit)element).getResource()).getContents().iterator().next());
                        continue;
                    }
                    if (!(element instanceof IType)) continue;
                    eObjects.add((EObject)this.getJavaFactoryResourceFromIResource(((IType)element).getResource()).getContents().iterator().next());
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (JavaModelException e) {
            IntentUiLogger.logError((Throwable)e);
        }
        return eObjects;
    }

    Resource getJavaFactoryResourceFromIResource(IResource resource) {
        if (!"java".equals(resource.getFileExtension())) {
            throw new IllegalArgumentException();
        }
        return new JavaResourceFactory().createResource(URI.createURI((String)resource.getFullPath().toString().replaceFirst("/", "")));
    }

    public Image getImage(ExternalContentReference externalContentReference) {
        Image image = null;
        if (externalContentReference.getExternalContent() != null) {
            String javaFileAsText = (String)new JavaBridgeSerializer().doSwitch(externalContentReference.getExternalContent());
            String javadoc = "";
            Display display = Display.getDefault();
            int fontHeight = new GC((Drawable)new Image((Device)display, 1, 1)).getFontMetrics().getHeight();
            if (javaFileAsText.startsWith("/**")) {
                javadoc = javaFileAsText.substring(0, javaFileAsText.indexOf("*/") + 3);
                javaFileAsText = javaFileAsText.replace(javadoc, "");
                javadoc = javadoc.replace("/**", "").replace("*/", "").trim();
            }
            int textWithoutJavaDocHeight = fontHeight + 5;
            int imageHeight = fontHeight * javadoc.split("\n").length + textWithoutJavaDocHeight;
            image = new Image((Device)display, 800, imageHeight);
            GC gc = new GC((Drawable)image);
            int iconWidth = 5;
            gc.setForeground(display.getSystemColor(16));
            IItemLabelProvider labeProvider = (IItemLabelProvider)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE).adapt((Notifier)externalContentReference.getExternalContent(), IItemLabelProvider.class);
            if (labeProvider != null) {
                Object iconURL = labeProvider.getImage((Object)externalContentReference.getExternalContent());
                Image icon = ExtendedImageRegistry.getInstance().getImage(iconURL);
                if (icon != null) {
                    gc.drawImage(icon, 0, 5);
                    iconWidth += icon.getImageData().width + 2;
                }
            }
            gc.drawText(javaFileAsText, iconWidth, 5);
            if (javadoc.length() > 1) {
                gc.setForeground(display.getSystemColor(2));
                gc.drawText(javadoc, 2, textWithoutJavaDocHeight);
            }
            gc.dispose();
        }
        return image;
    }
}

