/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.internal.renderers;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.mylyn.docs.intent.client.ui.editor.renderers.IEditorRendererExtension;
import org.eclipse.mylyn.docs.intent.client.ui.internal.renderers.IEditorRendererExtensionDescriptor;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ExternalContentReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IEditorRendererExtensionRegistry {
    private static final Map<IEditorRendererExtension, Collection<IEditorRendererExtensionDescriptor>> EXTENSIONS = Maps.newHashMap();

    private IEditorRendererExtensionRegistry() {
    }

    public static void addExtension(IEditorRendererExtensionDescriptor extensionDescriptor) {
        IEditorRendererExtension extension = extensionDescriptor.getEditorRendererExtension();
        if (EXTENSIONS.get(extension) == null) {
            EXTENSIONS.put(extension, new HashSet());
        }
        EXTENSIONS.get(extension).add(extensionDescriptor);
    }

    public static void clearRegistry() {
        EXTENSIONS.clear();
    }

    public static Collection<IEditorRendererExtensionDescriptor> getRegisteredExtensions() {
        HashSet registeredExtensions = Sets.newHashSet();
        for (Collection<IEditorRendererExtensionDescriptor> extensions : EXTENSIONS.values()) {
            registeredExtensions.addAll(extensions);
        }
        return registeredExtensions;
    }

    public static Collection<IEditorRendererExtension> getEditorRendererExtensions(ExternalContentReference externalContentReference) {
        ArrayList registeredExtensions = Lists.newArrayList();
        for (Collection<IEditorRendererExtensionDescriptor> extensions : EXTENSIONS.values()) {
            for (IEditorRendererExtensionDescriptor descriptor : extensions) {
                if (!descriptor.getEditorRendererExtension().isRendererFor(externalContentReference)) continue;
                registeredExtensions.add(descriptor);
            }
        }
        Collections.sort(registeredExtensions, new Comparator<IEditorRendererExtensionDescriptor>(){

            @Override
            public int compare(IEditorRendererExtensionDescriptor o1, IEditorRendererExtensionDescriptor o2) {
                return o2.getPriority() - o1.getPriority();
            }
        });
        LinkedHashSet editorRenders = Sets.newLinkedHashSet();
        for (IEditorRendererExtensionDescriptor descriptor : registeredExtensions) {
            editorRenders.add(descriptor.getEditorRendererExtension());
        }
        return editorRenders;
    }

    public static Collection<IEditorRendererExtension> getEditorRendererExtensions() {
        return EXTENSIONS.keySet();
    }

    public static void removeExtension(String extensionClassName) {
        for (IEditorRendererExtensionDescriptor extension : IEditorRendererExtensionRegistry.getRegisteredExtensions()) {
            if (!extension.getExtensionClassName().equals(extensionClassName)) continue;
            EXTENSIONS.get(extension.getEditorRendererExtension()).clear();
        }
    }
}

