/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.modelingunit.update;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IIntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.query.CompilationStatusQuery;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.IntentCommand;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.ReadOnlyException;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.SaveException;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.StructuralFeatureChangeStatus;
import org.eclipse.mylyn.docs.intent.core.document.IntentSection;
import org.eclipse.mylyn.docs.intent.core.document.UnitInstruction;
import org.eclipse.mylyn.docs.intent.core.document.descriptionunit.DescriptionBloc;
import org.eclipse.mylyn.docs.intent.core.document.descriptionunit.DescriptionUnit;
import org.eclipse.mylyn.docs.intent.core.document.descriptionunit.DescriptionUnitFactory;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ContributionInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.InstanciationInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnit;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnitFactory;
import org.eclipse.mylyn.docs.intent.core.modelingunit.NewObjectValue;
import org.eclipse.mylyn.docs.intent.core.modelingunit.StructuralFeatureAffectation;
import org.eclipse.mylyn.docs.intent.modelingunit.update.AbstractModelingUnitUpdater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeUpdater
extends AbstractModelingUnitUpdater {
    private Map<EObject, InstanciationInstruction> newInstanciations;

    public MergeUpdater(RepositoryAdapter repositoryAdapter) {
        super(repositoryAdapter);
    }

    public void create(final IntentSection section, final EObject sibling, final List<EObject> elements) {
        this.repositoryAdapter.execute(new IntentCommand(){

            public void execute() {
                ModelingUnit modelingUnit = ModelingUnitFactory.eINSTANCE.createModelingUnit();
                EObject previousSibling = MergeUpdater.this.addModelingUnitInContainer(section, sibling, modelingUnit);
                MergeUpdater.this.internalCreate(modelingUnit, previousSibling, elements);
                try {
                    MergeUpdater.this.repositoryAdapter.save();
                }
                catch (ReadOnlyException e) {
                    IntentLogger.getInstance().log(IIntentLogger.LogType.ERROR, e.getMessage());
                }
                catch (SaveException e) {
                    IntentLogger.getInstance().log(IIntentLogger.LogType.ERROR, e.getMessage());
                }
            }
        });
    }

    public void create(final ModelingUnit modelingUnit, final EObject sibling, final List<EObject> elements) {
        this.repositoryAdapter.execute(new IntentCommand(){

            public void execute() {
                MergeUpdater.this.internalCreate(modelingUnit, sibling, elements);
                try {
                    MergeUpdater.this.repositoryAdapter.save();
                }
                catch (ReadOnlyException e) {
                    IntentLogger.getInstance().log(IIntentLogger.LogType.ERROR, e.getMessage());
                }
                catch (SaveException e) {
                    IntentLogger.getInstance().log(IIntentLogger.LogType.ERROR, e.getMessage());
                }
            }
        });
    }

    protected void internalCreate(ModelingUnit modelingUnit, EObject sibling, List<EObject> elements) {
        this.setNewObjects(this.getAllNewObjects(elements));
        this.newInstanciations = new HashMap<EObject, InstanciationInstruction>();
        for (EObject workingCopyObject : elements) {
            Resource compiledResource = this.getMatchingCompiledResource(workingCopyObject);
            this.includeMatch(compiledResource, workingCopyObject.eResource());
            if (this.getExistingInstanciationFor(workingCopyObject) != null) continue;
            InstanciationInstruction containerInstanciation = this.getExistingInstanciationFor(workingCopyObject.eContainer());
            if (containerInstanciation == null) {
                containerInstanciation = this.newInstanciations.get(workingCopyObject.eContainer());
            }
            if (containerInstanciation != null) {
                ContributionInstruction contribution = this.generateContribution(containerInstanciation);
                StructuralFeatureAffectation containment = this.generateSingleAffectation(workingCopyObject.eContainingFeature(), workingCopyObject);
                contribution.getContributions().add((Object)containment);
                modelingUnit.getInstructions().add((Object)contribution);
                this.newInstanciations.put(workingCopyObject, ((NewObjectValue)containment.getValues().get(0)).getValue());
                continue;
            }
            InstanciationInstruction instanciation = this.generateInstanciation(workingCopyObject);
            modelingUnit.getInstructions().add((Object)instanciation);
            this.newInstanciations.put(workingCopyObject, instanciation);
        }
    }

    private List<EObject> getAllNewObjects(List<EObject> roots) {
        ArrayList<EObject> res = new ArrayList<EObject>();
        for (EObject root : roots) {
            res.add(root);
            res.addAll(this.getAllNewObjects((List<EObject>)root.eContents()));
        }
        return res;
    }

    private Resource getMatchingCompiledResource(EObject eObject) {
        String uriFragment = EcoreUtil.getURI((EObject)eObject).toString();
        CompilationStatusQuery query = new CompilationStatusQuery(this.repositoryAdapter);
        for (CompilationStatus compilationStatus : query.getOrCreateCompilationStatusManager().getCompilationStatusList()) {
            StructuralFeatureChangeStatus status;
            if (!(compilationStatus instanceof StructuralFeatureChangeStatus) || !uriFragment.equals((status = (StructuralFeatureChangeStatus)compilationStatus).getWorkingCopyElementURIFragment())) continue;
            return this.repositoryAdapter.getResource(status.getCompiledResourceURI());
        }
        return null;
    }

    private EObject addModelingUnitInContainer(IntentSection section, EObject sibling, ModelingUnit modelingUnit) {
        int siblingIndex;
        EObject previousSibling = sibling;
        DescriptionUnit rightUnit = null;
        if (previousSibling instanceof DescriptionBloc) {
            DescriptionUnit leftUnit = (DescriptionUnit)previousSibling.eContainer();
            rightUnit = DescriptionUnitFactory.eINSTANCE.createDescriptionUnit();
            LinkedHashSet<UnitInstruction> descriptionInstructionsToMove = new LinkedHashSet<UnitInstruction>();
            int i = leftUnit.getInstructions().indexOf((Object)previousSibling) + 1;
            while (i < leftUnit.getInstructions().size()) {
                descriptionInstructionsToMove.add((UnitInstruction)leftUnit.getInstructions().get(i));
                ++i;
            }
            leftUnit.getInstructions().removeAll(descriptionInstructionsToMove);
            rightUnit.getInstructions().addAll(descriptionInstructionsToMove);
            previousSibling = leftUnit;
        }
        if ((siblingIndex = section.getIntentContent().indexOf((Object)previousSibling)) != -1) {
            section.getIntentContent().add(siblingIndex + 1, (Object)modelingUnit);
            if (rightUnit != null) {
                section.getIntentContent().add(siblingIndex + 2, (Object)rightUnit);
            }
        } else {
            section.getIntentContent().add((Object)modelingUnit);
            if (rightUnit != null) {
                section.getIntentContent().add(1, (Object)rightUnit);
            }
        }
        return previousSibling;
    }
}

