/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.parser.descriptionunit;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocumentFactory;
import org.eclipse.mylyn.docs.intent.core.document.IntentReferenceInstruction;
import org.eclipse.mylyn.docs.intent.core.document.LabelDeclaration;
import org.eclipse.mylyn.docs.intent.core.document.TypeLabel;
import org.eclipse.mylyn.docs.intent.core.document.descriptionunit.DescriptionBloc;
import org.eclipse.mylyn.docs.intent.core.document.descriptionunit.DescriptionUnit;
import org.eclipse.mylyn.docs.intent.core.document.descriptionunit.DescriptionUnitFactory;
import org.eclipse.mylyn.docs.intent.markup.builder.ModelDocumentBuilder;
import org.eclipse.mylyn.docs.intent.markup.markup.Block;
import org.eclipse.mylyn.docs.intent.markup.markup.Container;
import org.eclipse.mylyn.docs.intent.markup.markup.Document;
import org.eclipse.mylyn.docs.intent.markup.markup.MarkupFactory;
import org.eclipse.mylyn.docs.intent.markup.markup.Section;
import org.eclipse.mylyn.docs.intent.markup.markup.SimpleContainer;
import org.eclipse.mylyn.docs.intent.markup.markup.StructureElement;
import org.eclipse.mylyn.docs.intent.parser.modelingunit.ParseException;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.textile.core.TextileLanguage;

public class DescriptionUnitParser {
    private static String[] intentTokens = new String[]{"@label", "@lazylabel", "@see"};
    private MarkupParser internalMarkupParser = new MarkupParser((MarkupLanguage)new TextileLanguage());
    private ModelDocumentBuilder builder = new ModelDocumentBuilder();
    private int offSet;

    public DescriptionUnitParser() {
        this.internalMarkupParser.setBuilder((DocumentBuilder)this.builder);
    }

    public DescriptionUnit parse(String descriptionUnitToParse) throws ParseException {
        DescriptionUnit descriptionUnit = DescriptionUnitFactory.eINSTANCE.createDescriptionUnit();
        String remainingContentToParse = descriptionUnitToParse;
        String currentlyParsedSentence = null;
        this.offSet = 0;
        while (remainingContentToParse.length() > 0 && this.offSet != -1) {
            this.offSet = this.getNextOffset(remainingContentToParse);
            if (this.offSet != -1) {
                currentlyParsedSentence = remainingContentToParse.substring(0, this.offSet);
                this.createDescriptionBlocs(descriptionUnit, currentlyParsedSentence.trim());
                currentlyParsedSentence = remainingContentToParse.substring(this.offSet);
                this.offSet = this.constructInstructionsFromSentence(descriptionUnit, currentlyParsedSentence);
                remainingContentToParse = remainingContentToParse.substring(this.offSet);
                continue;
            }
            this.createDescriptionBlocs(descriptionUnit, remainingContentToParse.trim());
            this.offSet = -1;
        }
        return descriptionUnit;
    }

    private void createDescriptionBlocs(DescriptionUnit descriptionUnit, String descriptionBlocToParse) {
        if (descriptionBlocToParse.trim().length() > 0) {
            this.internalMarkupParser.parse(descriptionBlocToParse);
            BasicEList blocksToCreate = new BasicEList();
            for (EObject descriptionRoot : this.builder.getRoots()) {
                if (!(descriptionRoot instanceof Document)) continue;
                for (StructureElement content : ((Document)descriptionRoot).getContent()) {
                    if (!(content instanceof Block) && !(content instanceof Section)) continue;
                    blocksToCreate.add((Object)content);
                }
            }
            int blocCount = 0;
            for (StructureElement blockToCreate : blocksToCreate) {
                SimpleContainer container = MarkupFactory.eINSTANCE.createSimpleContainer();
                container.getContent().add((Object)blockToCreate);
                DescriptionBloc descriptionBloc = DescriptionUnitFactory.eINSTANCE.createDescriptionBloc();
                descriptionBloc.setDescriptionBloc((Container)container);
                if (this.isLineBreaker(blockToCreate) && ++blocCount < blocksToCreate.size()) {
                    descriptionBloc.setLineBreak(true);
                }
                descriptionUnit.getInstructions().add((Object)descriptionBloc);
            }
        }
    }

    private boolean isLineBreaker(StructureElement blockToCreate) {
        return true;
    }

    private int constructInstructionsFromSentence(DescriptionUnit descriptionUnit, String parsedSentence) {
        String parsedSentenceWithoutLabelDeclaration;
        int endOffset = -1;
        if (parsedSentence.startsWith("@lazylabel")) {
            parsedSentenceWithoutLabelDeclaration = parsedSentence.replaceFirst("@lazylabel", "");
            this.offSet += "@lazylabel".length();
            endOffset = this.constructLabelInstruction(descriptionUnit, parsedSentenceWithoutLabelDeclaration, TypeLabel.LAZY);
        }
        if (parsedSentence.startsWith("@label")) {
            parsedSentenceWithoutLabelDeclaration = parsedSentence.replaceFirst("@label", "");
            this.offSet += "@label".length();
            endOffset = this.constructLabelInstruction(descriptionUnit, parsedSentenceWithoutLabelDeclaration, TypeLabel.EXPLICIT);
        }
        if (parsedSentence.startsWith("@see")) {
            String parsedSentenceWithoutReferenceDeclaration = parsedSentence.replaceFirst("@see", "");
            this.offSet += "@see".length();
            endOffset = this.constructReferenceInstruction(descriptionUnit, parsedSentenceWithoutReferenceDeclaration);
        }
        return endOffset;
    }

    private int constructReferenceInstruction(DescriptionUnit descriptionUnit, String parsedSentence) {
        int initialOffset = this.offSet;
        IntentReferenceInstruction referenceInstruction = null;
        String referenceValue = this.extractFirstString(parsedSentence);
        String parsendSentenceWithoutReferenceValue = parsedSentence.substring(this.offSet - initialOffset);
        String textToPrint = this.extractFirstString(parsendSentenceWithoutReferenceValue);
        referenceInstruction = IntentDocumentFactory.eINSTANCE.createIntentReferenceInstruction();
        referenceInstruction.setTextToPrint(textToPrint);
        referenceInstruction.setIntentHref(referenceValue);
        if (parsedSentence.length() > this.offSet - initialOffset) {
            if (parsedSentence.charAt(this.offSet - initialOffset) == '\n') {
                ++this.offSet;
                referenceInstruction.setLineBreak(true);
            }
        } else {
            referenceInstruction.setLineBreak(true);
        }
        descriptionUnit.getInstructions().add((Object)referenceInstruction);
        return this.offSet;
    }

    private int constructLabelInstruction(DescriptionUnit descriptionUnit, String parsedSentence, TypeLabel typeLabel) {
        int initialOffset = this.offSet;
        String labelValue = this.extractFirstString(parsedSentence);
        String parsendSentenceWithoutLabelValueDeclaration = parsedSentence.substring(this.offSet - initialOffset);
        String textToPrint = this.extractFirstString(parsendSentenceWithoutLabelValueDeclaration);
        LabelDeclaration labelDeclaration = IntentDocumentFactory.eINSTANCE.createLabelDeclaration();
        labelDeclaration.setType(typeLabel);
        labelDeclaration.setLabelValue(labelValue);
        if (textToPrint != null) {
            labelDeclaration.setTextToPrint(textToPrint);
        }
        if (parsedSentence.length() > this.offSet - initialOffset) {
            if (parsedSentence.charAt(this.offSet - initialOffset) == '\n') {
                ++this.offSet;
                labelDeclaration.setLineBreak(true);
            }
        } else {
            labelDeclaration.setLineBreak(true);
        }
        descriptionUnit.getInstructions().add((Object)labelDeclaration);
        return this.offSet;
    }

    public String extractFirstString(String parsedSentence) {
        String firstString = null;
        int temporaryOffset = this.offSet;
        boolean foundFirstString = false;
        if (parsedSentence.contains("\"") || parsedSentence.contains("'")) {
            StringBuilder firstStringBuilder = new StringBuilder();
            char beginQuote = ' ';
            int previousCharacter = 32;
            int i = 0;
            while (i < parsedSentence.length() && !foundFirstString) {
                ++temporaryOffset;
                char currentChar = parsedSentence.charAt(i);
                if (currentChar == '\"' || currentChar == '\'') {
                    if (previousCharacter != 92) {
                        if (beginQuote == ' ') {
                            beginQuote = currentChar;
                        } else if (currentChar == beginQuote) {
                            foundFirstString = true;
                        } else {
                            firstStringBuilder.append(currentChar);
                            previousCharacter = currentChar;
                        }
                    } else {
                        firstStringBuilder.append(currentChar);
                        previousCharacter = currentChar;
                    }
                } else if (currentChar == '\\') {
                    if (previousCharacter == 92) {
                        firstStringBuilder.append(currentChar);
                        previousCharacter = 32;
                    } else {
                        previousCharacter = 92;
                    }
                } else if (beginQuote != ' ') {
                    firstStringBuilder.append(currentChar);
                    previousCharacter = currentChar;
                }
                ++i;
            }
            firstString = firstStringBuilder.toString();
        }
        if (foundFirstString) {
            this.offSet = temporaryOffset;
            return firstString;
        }
        return null;
    }

    private int getNextOffset(String currentlyParsedContent) {
        Integer[] possibleNextOffsets = new Integer[intentTokens.length];
        int i = 0;
        while (i < intentTokens.length) {
            possibleNextOffsets[i] = currentlyParsedContent.indexOf(intentTokens[i]);
            ++i;
        }
        return this.getNextOffSetInTable(possibleNextOffsets);
    }

    private int getNextOffSetInTable(Integer[] possibleNextOffsets) {
        int nextOffset = -1;
        int i = 0;
        while (i < possibleNextOffsets.length) {
            if (possibleNextOffsets[i] > -1 && (nextOffset == -1 || possibleNextOffsets[i] < nextOffset)) {
                nextOffset = possibleNextOffsets[i];
            }
            ++i;
        }
        return nextOffset;
    }
}

