/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor.outline;

import java.util.ArrayList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditor;
import org.eclipse.mylyn.docs.intent.client.ui.editor.outline.IntentOutlineInformationHolder;
import org.eclipse.mylyn.docs.intent.client.ui.editor.outline.IntentOutlinePageItemProviderAdapterFactory;
import org.eclipse.mylyn.docs.intent.client.ui.editor.outline.IntentOutlinePageLabelProvider;
import org.eclipse.mylyn.docs.intent.client.ui.editor.outline.OutlineContentProvider;
import org.eclipse.mylyn.docs.intent.client.ui.editor.outline.RefreshOutlineJob;
import org.eclipse.mylyn.docs.intent.core.descriptionunit.DescriptionUnit;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class IntentOutlinePage
extends ContentOutlinePage
implements IContentOutlinePage,
ISelectionChangedListener {
    protected IntentEditor editor;
    protected AdapterFactory adapterFactory;
    protected IntentOutlinePageItemProviderAdapterFactory outlinePageItemProvider;
    private final RefreshOutlineJob refreshViewJob;
    private ViewerFilter descriptionUnitFilter;

    public IntentOutlinePage(IntentEditor editor) {
        this.editor = editor;
        this.outlinePageItemProvider = new IntentOutlinePageItemProviderAdapterFactory();
        ArrayList<ReflectiveItemProviderAdapterFactory> factories = new ArrayList<ReflectiveItemProviderAdapterFactory>();
        factories.add(this.outlinePageItemProvider);
        factories.add((ReflectiveItemProviderAdapterFactory)new ResourceItemProviderAdapterFactory());
        factories.add((ReflectiveItemProviderAdapterFactory)new EcoreItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        this.adapterFactory = new ComposedAdapterFactory(factories);
        this.refreshViewJob = new RefreshOutlineJob(this);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        EObject editorContent = this.editor.getIntentContent();
        this.getTreeViewer().setContentProvider((IContentProvider)new OutlineContentProvider(this.adapterFactory, editorContent, false));
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)new IntentOutlinePageLabelProvider(this.adapterFactory));
        IntentOutlineInformationHolder input = new IntentOutlineInformationHolder(editorContent, true);
        this.getTreeViewer().setInput((Object)input);
        this.getTreeViewer().expandToLevel((Object)editorContent, 2);
    }

    public void addDescriptionUnitFilter() {
        if (this.descriptionUnitFilter == null) {
            this.descriptionUnitFilter = new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return !(parentElement instanceof DescriptionUnit);
                }
            };
            this.getTreeViewer().addFilter(this.descriptionUnitFilter);
        }
    }

    public void removeDescriptionUnitFilter() {
        if (this.descriptionUnitFilter == null) {
            this.getTreeViewer().removeFilter(this.descriptionUnitFilter);
        }
    }

    public TreeViewer getTreeViewer() {
        return super.getTreeViewer();
    }

    public void refreshInternalContainer(Object element) {
        if (!this.getTreeViewer().getControl().isDisposed()) {
            TreePath[] treePaths = this.getTreeViewer().getExpandedTreePaths();
            this.getTreeViewer().setInput((Object)new IntentOutlineInformationHolder((EObject)element, true));
            this.getTreeViewer().setExpandedTreePaths(treePaths);
        }
    }

    public void refresh(Object element) {
        this.refreshViewJob.refreshView(element);
    }

    public void setSelectedElement(EObject element) {
    }
}

