/**
 * Copyright (c) 2010, 2012 Obeo.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Obeo - initial API and implementation
 */
package org.eclipse.mylyn.docs.intent.core.modelingunit.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.mylyn.docs.intent.core.modelingunit.util.ModelingUnitAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class ModelingUnitItemProviderAdapterFactory extends ModelingUnitAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ModelingUnitItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModelingUnitItemProvider modelingUnitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModelingUnitAdapter() {
		if (modelingUnitItemProvider == null) {
			modelingUnitItemProvider = new ModelingUnitItemProvider(this);
		}

		return modelingUnitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.mylyn.docs.intent.core.modelingunit.ResourceDeclaration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ResourceDeclarationItemProvider resourceDeclarationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.mylyn.docs.intent.core.modelingunit.ResourceDeclaration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createResourceDeclarationAdapter() {
		if (resourceDeclarationItemProvider == null) {
			resourceDeclarationItemProvider = new ResourceDeclarationItemProvider(this);
		}

		return resourceDeclarationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.mylyn.docs.intent.core.modelingunit.TypeReference} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TypeReferenceItemProvider typeReferenceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.mylyn.docs.intent.core.modelingunit.TypeReference}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTypeReferenceAdapter() {
		if (typeReferenceItemProvider == null) {
			typeReferenceItemProvider = new TypeReferenceItemProvider(this);
		}

		return typeReferenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.mylyn.docs.intent.core.modelingunit.InstanciationInstruction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InstanciationInstructionItemProvider instanciationInstructionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.mylyn.docs.intent.core.modelingunit.InstanciationInstruction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInstanciationInstructionAdapter() {
		if (instanciationInstructionItemProvider == null) {
			instanciationInstructionItemProvider = new InstanciationInstructionItemProvider(this);
		}

		return instanciationInstructionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.mylyn.docs.intent.core.modelingunit.StructuralFeatureAffectation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StructuralFeatureAffectationItemProvider structuralFeatureAffectationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.mylyn.docs.intent.core.modelingunit.StructuralFeatureAffectation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStructuralFeatureAffectationAdapter() {
		if (structuralFeatureAffectationItemProvider == null) {
			structuralFeatureAffectationItemProvider = new StructuralFeatureAffectationItemProvider(this);
		}

		return structuralFeatureAffectationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.mylyn.docs.intent.core.modelingunit.NativeValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NativeValueItemProvider nativeValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.mylyn.docs.intent.core.modelingunit.NativeValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNativeValueAdapter() {
		if (nativeValueItemProvider == null) {
			nativeValueItemProvider = new NativeValueItemProvider(this);
		}

		return nativeValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.mylyn.docs.intent.core.modelingunit.NewObjectValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NewObjectValueItemProvider newObjectValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.mylyn.docs.intent.core.modelingunit.NewObjectValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNewObjectValueAdapter() {
		if (newObjectValueItemProvider == null) {
			newObjectValueItemProvider = new NewObjectValueItemProvider(this);
		}

		return newObjectValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.mylyn.docs.intent.core.modelingunit.ReferenceValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReferenceValueItemProvider referenceValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.mylyn.docs.intent.core.modelingunit.ReferenceValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReferenceValueAdapter() {
		if (referenceValueItemProvider == null) {
			referenceValueItemProvider = new ReferenceValueItemProvider(this);
		}

		return referenceValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.mylyn.docs.intent.core.modelingunit.InstanciationInstructionReference} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InstanciationInstructionReferenceItemProvider instanciationInstructionReferenceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.mylyn.docs.intent.core.modelingunit.InstanciationInstructionReference}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInstanciationInstructionReferenceAdapter() {
		if (instanciationInstructionReferenceItemProvider == null) {
			instanciationInstructionReferenceItemProvider = new InstanciationInstructionReferenceItemProvider(
					this);
		}

		return instanciationInstructionReferenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.mylyn.docs.intent.core.modelingunit.ContributionInstruction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ContributionInstructionItemProvider contributionInstructionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.mylyn.docs.intent.core.modelingunit.ContributionInstruction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createContributionInstructionAdapter() {
		if (contributionInstructionItemProvider == null) {
			contributionInstructionItemProvider = new ContributionInstructionItemProvider(this);
		}

		return contributionInstructionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.mylyn.docs.intent.core.modelingunit.ExternalContentReference} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExternalContentReferenceItemProvider externalContentReferenceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.mylyn.docs.intent.core.modelingunit.ExternalContentReference}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExternalContentReferenceAdapter() {
		if (externalContentReferenceItemProvider == null) {
			externalContentReferenceItemProvider = new ExternalContentReferenceItemProvider(this);
		}

		return externalContentReferenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnitInstructionReference} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModelingUnitInstructionReferenceItemProvider modelingUnitInstructionReferenceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnitInstructionReference}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModelingUnitInstructionReferenceAdapter() {
		if (modelingUnitInstructionReferenceItemProvider == null) {
			modelingUnitInstructionReferenceItemProvider = new ModelingUnitInstructionReferenceItemProvider(
					this);
		}

		return modelingUnitInstructionReferenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.mylyn.docs.intent.core.modelingunit.IntentReferenceInModelingUnit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IntentReferenceInModelingUnitItemProvider intentReferenceInModelingUnitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.mylyn.docs.intent.core.modelingunit.IntentReferenceInModelingUnit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIntentReferenceInModelingUnitAdapter() {
		if (intentReferenceInModelingUnitItemProvider == null) {
			intentReferenceInModelingUnitItemProvider = new IntentReferenceInModelingUnitItemProvider(this);
		}

		return intentReferenceInModelingUnitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.mylyn.docs.intent.core.modelingunit.AnnotationDeclaration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AnnotationDeclarationItemProvider annotationDeclarationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.mylyn.docs.intent.core.modelingunit.AnnotationDeclaration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAnnotationDeclarationAdapter() {
		if (annotationDeclarationItemProvider == null) {
			annotationDeclarationItemProvider = new AnnotationDeclarationItemProvider(this);
		}

		return annotationDeclarationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.mylyn.docs.intent.core.modelingunit.LabelInModelingUnit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LabelInModelingUnitItemProvider labelInModelingUnitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.mylyn.docs.intent.core.modelingunit.LabelInModelingUnit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLabelInModelingUnitAdapter() {
		if (labelInModelingUnitItemProvider == null) {
			labelInModelingUnitItemProvider = new LabelInModelingUnitItemProvider(this);
		}

		return labelInModelingUnitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link java.util.Map.Entry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected KeyValForAnnotationItemProvider keyValForAnnotationItemProvider;

	/**
	 * This creates an adapter for a {@link java.util.Map.Entry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createKeyValForAnnotationAdapter() {
		if (keyValForAnnotationItemProvider == null) {
			keyValForAnnotationItemProvider = new KeyValForAnnotationItemProvider(this);
		}

		return keyValForAnnotationItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (modelingUnitItemProvider != null)
			modelingUnitItemProvider.dispose();
		if (resourceDeclarationItemProvider != null)
			resourceDeclarationItemProvider.dispose();
		if (typeReferenceItemProvider != null)
			typeReferenceItemProvider.dispose();
		if (instanciationInstructionItemProvider != null)
			instanciationInstructionItemProvider.dispose();
		if (structuralFeatureAffectationItemProvider != null)
			structuralFeatureAffectationItemProvider.dispose();
		if (nativeValueItemProvider != null)
			nativeValueItemProvider.dispose();
		if (newObjectValueItemProvider != null)
			newObjectValueItemProvider.dispose();
		if (referenceValueItemProvider != null)
			referenceValueItemProvider.dispose();
		if (instanciationInstructionReferenceItemProvider != null)
			instanciationInstructionReferenceItemProvider.dispose();
		if (contributionInstructionItemProvider != null)
			contributionInstructionItemProvider.dispose();
		if (externalContentReferenceItemProvider != null)
			externalContentReferenceItemProvider.dispose();
		if (modelingUnitInstructionReferenceItemProvider != null)
			modelingUnitInstructionReferenceItemProvider.dispose();
		if (intentReferenceInModelingUnitItemProvider != null)
			intentReferenceInModelingUnitItemProvider.dispose();
		if (annotationDeclarationItemProvider != null)
			annotationDeclarationItemProvider.dispose();
		if (labelInModelingUnitItemProvider != null)
			labelInModelingUnitItemProvider.dispose();
		if (keyValForAnnotationItemProvider != null)
			keyValForAnnotationItemProvider.dispose();
	}

}
