/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.collab.common.internal.logger;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.eclipse.mylyn.docs.intent.collab.common.internal.logger.IntentLoggerDescriptor;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IIntentLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntentLoggerRegistry {
    private static final Map<IntentLoggerDescriptor, IIntentLogger> DECLARED_LOGGERS = Maps.newLinkedHashMap();

    private IntentLoggerRegistry() {
    }

    public static Collection<IIntentLogger> getDeclaredLoggers() {
        for (Map.Entry<IntentLoggerDescriptor, IIntentLogger> descriptorToLogger : DECLARED_LOGGERS.entrySet()) {
            if (descriptorToLogger.getValue() != null) continue;
            descriptorToLogger.setValue(descriptorToLogger.getKey().createLogger());
        }
        return DECLARED_LOGGERS.values();
    }

    public static void addLogger(IntentLoggerDescriptor intentLoggerDescriptor) {
        DECLARED_LOGGERS.put(intentLoggerDescriptor, null);
    }

    public static void removeExtension(String extensionClassName) {
        for (IntentLoggerDescriptor extension : DECLARED_LOGGERS.keySet()) {
            if (!extension.getExtensionClassName().equals(extensionClassName)) continue;
            DECLARED_LOGGERS.remove(extension);
        }
    }

    public static void clearContributedLoggers() {
        DECLARED_LOGGERS.clear();
    }
}

