/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.specialized;

import com.ibm.jbatch.tck.artifacts.chunktypes.ArrayIndexCheckpointData;
import com.ibm.jbatch.tck.artifacts.chunktypes.ReadRecord;
import com.ibm.jbatch.tck.artifacts.reusable.MyPersistentRestartUserData;
import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.AbstractItemWriter;
import jakarta.batch.runtime.context.StepContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Logger;

@Named(value="doSomethingSimpleArrayWriter")
public class DoSomethingSimpleArrayWriter
extends AbstractItemWriter {
    private static final Logger logger = Logger.getLogger(DoSomethingSimpleArrayWriter.class.getName());
    private int[] writerDataArray = new int[30];
    private int idx = 0;
    private int chkArraySize;
    int chunkWriteIteration = 0;
    @Inject
    @BatchProperty(name="app.arraysize")
    String appArraySizeString;
    @Inject
    @BatchProperty(name="app.writepoints")
    String writePointsString;
    @Inject
    @BatchProperty(name="app.next.writepoints")
    String nextWritePointsString;
    @Inject
    private StepContext stepCtx = null;
    @Inject
    @BatchProperty(name="app.checkpoint.position")
    String appCheckpointPositionString;
    int arraysize;
    int[] writePoints;
    int checkpointPosition;

    public void open(Serializable cpd) throws Exception {
        int i;
        logger.fine("openWriter");
        MyPersistentRestartUserData myData = null;
        myData = (MyPersistentRestartUserData)this.stepCtx.getPersistentUserData();
        if (myData != null) {
            this.stepCtx.setPersistentUserData((Serializable)new MyPersistentRestartUserData(myData.getExecutionNumber() + 1, this.nextWritePointsString));
            logger.fine("AJM: iteration = " + ((MyPersistentRestartUserData)this.stepCtx.getPersistentUserData()).getExecutionNumber());
            this.writePointsString = ((MyPersistentRestartUserData)this.stepCtx.getPersistentUserData()).getNextWritePoints();
        } else {
            this.stepCtx.setPersistentUserData((Serializable)new MyPersistentRestartUserData(1, this.nextWritePointsString));
        }
        ArrayIndexCheckpointData checkpointData = (ArrayIndexCheckpointData)cpd;
        this.arraysize = Integer.parseInt(this.appArraySizeString);
        String[] writePointsStrArr = this.writePointsString.split(",");
        this.writePoints = new int[this.writePointsString.length()];
        logger.fine("AJM: writePointsStrArr.length() = " + writePointsStrArr.length);
        if (this.appCheckpointPositionString != null) {
            this.checkpointPosition = Integer.parseInt(this.appCheckpointPositionString);
        }
        for (i = 0; i < writePointsStrArr.length; ++i) {
            logger.fine("AJM: writePointsStrArr[" + i + "] = " + writePointsStrArr[i]);
            this.writePoints[i] = Integer.parseInt(writePointsStrArr[i]);
            logger.fine("AJM: writePoints[" + i + "] = " + this.writePoints[i]);
        }
        if (checkpointData == null) {
            this.idx = 0;
            logger.fine("WRITE: chkpt data = null, so idx = " + this.idx);
        } else {
            this.idx = checkpointData.getCurrentIndex();
            if (this.appCheckpointPositionString != null) {
                if (this.idx != this.checkpointPosition) {
                    throw new Exception("checkpointPosition incorect, test will now fail");
                }
                logger.fine("AJM: checkpoint position as expected");
            }
            logger.fine("WRITE: chkpt data was valid, so idx = " + this.idx);
            logger.fine("WRITE: chunkWriteIteration = " + this.chunkWriteIteration);
        }
        for (i = 0; i < this.arraysize; ++i) {
            this.writerDataArray[i] = 0;
        }
    }

    public void close() throws Exception {
        for (int i = 0; i < this.arraysize; ++i) {
            logger.fine("WRITE: writerDataArray[" + i + "] = " + this.writerDataArray[i]);
        }
    }

    public void writeItems(List<Object> myData) throws Exception {
        int i;
        logger.fine("writeMyData receives chunk size=" + myData.size());
        logger.fine("WRITE: before writing, idx = " + this.idx);
        logger.fine("WRITE: before writing, chunkWriteIteration = " + this.chunkWriteIteration);
        if (this.writePoints[this.chunkWriteIteration] != this.idx) {
            logger.fine("WRITE: we have an issue! throw exception here");
            throw new Exception("WRITE: the chunk write did not at the correct boundary (idx) ->" + this.idx);
        }
        logger.fine("WRITE: the chunk write is occuring at the correct boundary (idx) ->" + this.idx);
        ++this.chunkWriteIteration;
        for (i = 0; i < myData.size(); ++i) {
            this.writerDataArray[this.idx] = ((ReadRecord)myData.get(i)).getCount();
            ++this.idx;
        }
        for (i = 0; i < this.arraysize; ++i) {
            logger.fine("WRITE: writerDataArray[" + i + "] = " + this.writerDataArray[i]);
        }
        logger.fine("WRITE: idx = " + this.idx + " and i = " + i);
        logger.fine("WRITE: chunkWriteIteration= " + this.chunkWriteIteration);
        logger.fine("WRITE: size of writePoints->" + this.writePoints.length);
    }

    public ArrayIndexCheckpointData checkpointInfo() throws Exception {
        ArrayIndexCheckpointData _chkptData = new ArrayIndexCheckpointData();
        _chkptData.setCurrentIndex(this.idx);
        return _chkptData;
    }

    private class MyTransient {
        int data = 0;

        MyTransient(int x) {
            this.data = x;
        }
    }
}

