/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.query.apitests;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.query.apitests.DataTypes2;
import ee.jakarta.tck.persistence.core.query.apitests.Department;
import ee.jakarta.tck.persistence.core.query.apitests.Employee;
import jakarta.persistence.Query;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.List;
import java.util.Properties;

public class Client3
extends PMClientBase {
    private final Employee[] empRef = new Employee[21];
    private final java.sql.Date d1 = this.getSQLDate("2000-02-14");
    private final Date dateId = this.getUtilDate("2009-01-10");
    final Department[] deptRef = new Department[5];
    private static final DecimalFormat df = new DecimalFormat();

    public static void main(String[] args) {
        Client3 theTests = new Client3();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createDataTypes2Data();
            this.logTrace("Done creating test data");
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception caught in Setup: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("in cleanupNoData");
        super.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryAPITest28() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = true;
        Time timeValue = this.getTimeData("10:30:15");
        this.logTrace("time Value = " + timeValue.toString());
        try {
            this.getEntityTransaction().begin();
            this.logTrace("FIND D2: " + this.dateId);
            DataTypes2 dataTypes2 = (DataTypes2)this.getEntityManager().find(DataTypes2.class, (Object)this.dateId);
            if (null != dataTypes2) {
                this.logTrace("DataType Entity is not null, setting TimeData ");
                dataTypes2.setTimeData(timeValue);
                pass1 = true;
            } else {
                this.logErr("Null returned during initial find");
            }
            this.getEntityManager().merge((Object)dataTypes2);
            this.doFlush();
            this.clearCache();
            this.logTrace("Make sure update occurred");
            this.logTrace("FIND D2 again:");
            dataTypes2 = (DataTypes2)this.getEntityManager().find(DataTypes2.class, (Object)this.dateId);
            if (null != dataTypes2) {
                if (dataTypes2.getTimeData().equals(timeValue)) {
                    this.logTrace("Update occurred properly:" + dataTypes2);
                    pass2 = true;
                } else {
                    this.logErr("Update did not occur properly");
                }
            } else {
                this.logErr("Find returned null after update");
            }
            this.logTrace("Retrieving all results first");
            List cDataTypes2 = this.getEntityManager().createQuery("select d from DataTypes2 d").getResultList();
            for (DataTypes2 d : cDataTypes2) {
                this.logTrace("result:" + d.toString());
            }
            this.logTrace("Check results when testing for Time");
            List result = this.getEntityManager().createQuery("select d.timeData from DataTypes2 d where d.timeData = :time").setParameter("time", (Object)timeValue).getResultList();
            int result_size = result.size();
            this.logTrace("Result Size = " + result_size);
            if (result_size == 1) {
                pass3 = true;
                this.logTrace("Received expected result size");
                for (Time t : result) {
                    this.logTrace("time=" + t);
                    if (t.equals(timeValue)) {
                        this.logTrace("Received expected Time ");
                        continue;
                    }
                    pass4 = false;
                    this.logErr("Received unexpected Time = " + t.toString());
                }
            } else {
                this.logErr("Expected 1 result, instead got: " + result_size);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new Exception("queryAPITest28 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryAPITest29() throws Exception {
        this.logTrace("Begin queryAPITest29");
        int result_size = 0;
        boolean pass1 = false;
        boolean pass2 = true;
        Timestamp tsValue = this.getTimestampData("2006-11-11");
        this.logTrace("timestamp Value = " + tsValue.toString());
        try {
            this.getEntityTransaction().begin();
            this.logTrace("FIND D2");
            DataTypes2 dataTypes2 = (DataTypes2)this.getEntityManager().find(DataTypes2.class, (Object)this.dateId);
            if (null != dataTypes2) {
                this.logTrace("DataType Entity is not null, setting TimeData ");
                dataTypes2.setTsData(tsValue);
            }
            this.getEntityManager().merge((Object)dataTypes2);
            this.doFlush();
            this.clearCache();
            this.logTrace("Check results");
            if (null != dataTypes2) {
                Query q = this.getEntityManager().createQuery("select d.tsData from DataTypes2 d where d.tsData = {ts '2006-11-11 10:10:10'}");
                List result = q.getResultList();
                result_size = result.size();
                this.logTrace("Result Size = " + result_size);
                if (result_size == 1) {
                    pass1 = true;
                    this.logTrace("Received expected result size");
                    for (Timestamp t : result) {
                        this.logTrace("time=" + t);
                        if (t.equals(tsValue)) {
                            this.logTrace("Received expected TimeStamp ");
                            continue;
                        }
                        this.logErr("Received unexpected TimeStamp = " + t.toString());
                        pass2 = false;
                    }
                } else {
                    this.logErr("Did not get expected results.  Expected " + tsValue + " , got: " + dataTypes2.getTsData());
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("queryAPITest29 failed");
        }
    }

    private void createDataTypes2Data() throws Exception {
        this.logTrace("createDataTypes2Data");
        try {
            this.getEntityTransaction().begin();
            DataTypes2 dT2 = new DataTypes2(this.dateId);
            dT2.setDateData(this.dateId);
            dT2.setTimeData(this.getTimeData("01:01:01"));
            this.getEntityManager().persist((Object)dT2);
            Date d = this.getUtilDate("2010-02-11");
            dT2 = new DataTypes2(d);
            dT2.setDateData(d);
            dT2.setTimeData(this.getTimeData("02:02:02"));
            this.getEntityManager().persist((Object)dT2);
            d = this.getUtilDate("2011-03-12");
            dT2 = new DataTypes2(d);
            dT2.setDateData(d);
            dT2.setTimeData(this.getTimeData("03:03:03"));
            this.getEntityManager().persist((Object)dT2);
            d = this.getUtilDate("2012-04-01");
            dT2 = new DataTypes2(d);
            dT2.setDateData(d);
            dT2.setTimeData(this.getTimeData("04:04:04"));
            this.getEntityManager().persist((Object)dT2);
            this.getEntityTransaction().commit();
            this.logTrace("Created TestData");
        }
        catch (Exception re) {
            this.logErr("Unexpected Exception in createTestData:", re);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in createTestData while rolling back TX:", re);
            }
        }
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM EMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DEPARTMENT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM INSURANCE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DATATYPES2").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

