/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.refactoring.RenameTypeArguments;
import org.eclipse.jdt.internal.corext.refactoring.participants.ResourceModifications;
import org.eclipse.jdt.internal.corext.refactoring.reorg.RefactoringModifications;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.IParticipantDescriptorFilter;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;

public class RenameModifications
extends RefactoringModifications {
    private List<Object> fRename = new ArrayList<Object>();
    private List<RefactoringArguments> fRenameArguments = new ArrayList<RefactoringArguments>();
    private List<IParticipantDescriptorFilter> fParticipantDescriptorFilter = new ArrayList<IParticipantDescriptorFilter>();

    public void rename(IResource resource, RenameArguments args) {
        this.add(resource, (RefactoringArguments)args, null);
    }

    public void rename(IJavaProject project, RenameArguments args) {
        this.add(project, (RefactoringArguments)args, null);
        IProject rProject = project.getProject();
        if (rProject != null) {
            this.getResourceModifications().addRename((IResource)rProject, args);
            IProject[] iProjectArray = rProject.getReferencingProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject referencingProject = iProjectArray[n2];
                IFile classpath = this.getClasspathFile((IResource)referencingProject);
                if (classpath != null) {
                    this.getResourceModifications().addChanged(classpath);
                }
                ++n2;
            }
        }
    }

    public void rename(IPackageFragmentRoot sourceFolder, RenameArguments arguments) {
        this.add(sourceFolder, (RefactoringArguments)arguments, null);
        if (sourceFolder.getResource() != null) {
            this.getResourceModifications().addRename(sourceFolder.getResource(), arguments);
        }
    }

    public void rename(IPackageFragment rootPackage, RenameArguments args, boolean renameSubPackages) throws CoreException {
        IContainer container;
        this.add(rootPackage, (RefactoringArguments)args, null);
        IPackageFragment[] allSubPackages = null;
        if (renameSubPackages) {
            IPackageFragment[] iPackageFragmentArray = allSubPackages = this.getSubpackages(rootPackage);
            int n = allSubPackages.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragment pack = iPackageFragmentArray[n2];
                RenameArguments subArgs = new RenameArguments(this.getNewPackageName(rootPackage, args.getNewName(), pack.getElementName()), args.getUpdateReferences());
                this.add(pack, (RefactoringArguments)subArgs, null);
                ++n2;
            }
        }
        if ((container = (IContainer)rootPackage.getResource()) == null) {
            return;
        }
        IContainer target = (IContainer)((IPackageFragmentRoot)rootPackage.getParent()).getPackageFragment(args.getNewName()).getResource();
        if ((!rootPackage.hasSubpackages() || renameSubPackages) && this.canMove(container, target)) {
            this.createIncludingParents(target.getParent());
            if (container.getParent().equals((Object)target.getParent())) {
                this.getResourceModifications().addRename((IResource)container, new RenameArguments(target.getName(), args.getUpdateReferences()));
            } else {
                try {
                    this.getResourceModifications().ignoreForDelta();
                    this.addAllResourceModifications(rootPackage, args, renameSubPackages, allSubPackages);
                }
                finally {
                    this.getResourceModifications().trackForDelta();
                }
                this.getResourceModifications().addDelta(new ResourceModifications.MoveDescription((IResource)container, target.getFullPath()));
            }
        } else {
            this.addAllResourceModifications(rootPackage, args, renameSubPackages, allSubPackages);
        }
    }

    public void rename(ICompilationUnit unit, RenameArguments args) {
        this.add(unit, (RefactoringArguments)args, null);
        if (unit.getResource() != null) {
            this.getResourceModifications().addRename(unit.getResource(), new RenameArguments(args.getNewName(), args.getUpdateReferences()));
        }
    }

    public void rename(IType type, RenameTypeArguments args, IParticipantDescriptorFilter filter) {
        this.add(type, (RefactoringArguments)args, filter);
    }

    public void rename(IField field, RenameArguments args) {
        this.add(field, (RefactoringArguments)args, null);
    }

    public void rename(IMethod method, RenameArguments args) {
        this.add(method, (RefactoringArguments)args, null);
    }

    public void rename(ILocalVariable variable, RenameArguments args) {
        this.add(variable, (RefactoringArguments)args, null);
    }

    public void rename(ITypeParameter typeParameter, RenameArguments arguments) {
        this.add(typeParameter, (RefactoringArguments)arguments, null);
    }

    public void rename(IModuleDescription module, RenameArguments args) {
        this.add(module, (RefactoringArguments)args, null);
    }

    @Override
    public void buildDelta(IResourceChangeDescriptionFactory builder) {
        int i = 0;
        while (i < this.fRename.size()) {
            Object element = this.fRename.get(i);
            if (element instanceof IResource) {
                ResourceModifications.buildMoveDelta(builder, (IResource)element, (RenameArguments)this.fRenameArguments.get(i));
            }
            ++i;
        }
        this.getResourceModifications().buildDelta(builder);
    }

    @Override
    public void buildValidateEdits(ValidateEditChecker checker) {
        for (Object element : this.fRename) {
            ICompilationUnit unit;
            IResource resource;
            if (!(element instanceof ICompilationUnit) || (resource = (unit = (ICompilationUnit)element).getResource()) == null || resource.getType() != 1) continue;
            checker.addFile((IFile)resource);
        }
    }

    @Override
    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, RefactoringProcessor owner, String[] natures, SharableParticipants shared) {
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < this.fRename.size()) {
            result.addAll(Arrays.asList(ParticipantManager.loadRenameParticipants((RefactoringStatus)status, (RefactoringProcessor)owner, (Object)this.fRename.get(i), (RenameArguments)((RenameArguments)this.fRenameArguments.get(i)), (IParticipantDescriptorFilter)this.fParticipantDescriptorFilter.get(i), (String[])natures, (SharableParticipants)shared)));
            ++i;
        }
        result.addAll(Arrays.asList(this.getResourceModifications().getParticipants(status, owner, natures, shared)));
        return result.toArray(new RefactoringParticipant[result.size()]);
    }

    private void add(Object element, RefactoringArguments args, IParticipantDescriptorFilter filter) {
        Assert.isNotNull((Object)element);
        Assert.isNotNull((Object)args);
        this.fRename.add(element);
        this.fRenameArguments.add(args);
        this.fParticipantDescriptorFilter.add(filter);
    }

    private void addAllResourceModifications(IPackageFragment rootPackage, RenameArguments args, boolean renameSubPackages, IPackageFragment[] allSubPackages) throws CoreException {
        IFolder target = this.addResourceModifications(rootPackage, args, rootPackage, renameSubPackages);
        if (renameSubPackages) {
            IContainer container = (IContainer)rootPackage.getResource();
            if (container == null) {
                return;
            }
            boolean removeContainer = !container.contains((ISchedulingRule)target);
            IPackageFragment[] iPackageFragmentArray = allSubPackages;
            int n = allSubPackages.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragment pack = iPackageFragmentArray[n2];
                IFolder subTarget = this.addResourceModifications(rootPackage, args, pack, renameSubPackages);
                if (container.contains((ISchedulingRule)subTarget)) {
                    removeContainer = false;
                }
                ++n2;
            }
            if (removeContainer) {
                this.getResourceModifications().addDelete((IResource)container);
            }
        }
    }

    private IFolder addResourceModifications(IPackageFragment rootPackage, RenameArguments args, IPackageFragment pack, boolean renameSubPackages) throws CoreException {
        IContainer container = (IContainer)pack.getResource();
        if (container == null) {
            return null;
        }
        IFolder target = this.computeTargetFolder(rootPackage, args, pack);
        this.createIncludingParents((IContainer)target);
        MoveArguments arguments = new MoveArguments((Object)target, args.getUpdateReferences());
        HashSet<IResource> allMembers = new HashSet<IResource>(Arrays.asList(container.members()));
        IResource[] iResourceArray = this.collectResourcesOfInterest(pack);
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource toMove = iResourceArray[n2];
            this.getResourceModifications().addMove(toMove, arguments);
            allMembers.remove(toMove);
            ++n2;
        }
        Iterator iter = allMembers.iterator();
        while (iter.hasNext()) {
            IResource element = (IResource)iter.next();
            if (!(element instanceof IFile)) continue;
            this.getResourceModifications().addDelete(element);
            iter.remove();
        }
        if (!renameSubPackages && allMembers.isEmpty()) {
            this.getResourceModifications().addDelete((IResource)container);
        }
        return target;
    }

    private boolean canMove(IContainer source, IContainer target) {
        return !target.exists() && !source.getFullPath().isPrefixOf(target.getFullPath());
    }

    private IPackageFragment[] getSubpackages(IPackageFragment pack) throws CoreException {
        IPackageFragmentRoot root = (IPackageFragmentRoot)pack.getParent();
        if (pack.isDefaultPackage()) {
            return new IPackageFragment[0];
        }
        ArrayList<IPackageFragment> result = new ArrayList<IPackageFragment>();
        String prefix = pack.getElementName() + ".";
        IJavaElement[] iJavaElementArray = root.getChildren();
        int n = iJavaElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement element = iJavaElementArray[n2];
            IPackageFragment currentPackage = (IPackageFragment)element;
            if (currentPackage.getElementName().startsWith(prefix)) {
                result.add(currentPackage);
            }
            ++n2;
        }
        return result.toArray(new IPackageFragment[result.size()]);
    }

    private IFolder computeTargetFolder(IPackageFragment rootPackage, RenameArguments args, IPackageFragment pack) {
        IPath path = pack.getParent().getPath();
        path = path.append(this.getNewPackageName(rootPackage, args.getNewName(), pack.getElementName()).replace('.', '/'));
        IFolder target = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
        return target;
    }

    private String getNewPackageName(IPackageFragment rootPackage, String newPackageName, String oldSubPackageName) {
        String oldPackageName = rootPackage.getElementName();
        return newPackageName + oldSubPackageName.substring(oldPackageName.length());
    }
}

