/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ExpressionContext;
import org.eclipse.jdt.internal.compiler.ast.IPolyExpression;
import org.eclipse.jdt.internal.compiler.ast.NullAnnotationMatching;
import org.eclipse.jdt.internal.compiler.ast.SwitchStatement;
import org.eclipse.jdt.internal.compiler.ast.YieldStatement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PolyTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class SwitchExpression
extends SwitchStatement
implements IPolyExpression {
    TypeBinding expectedType;
    ExpressionContext expressionContext = ExpressionContext.VANILLA_CONTEXT;
    private int nullStatus = 1;
    public boolean jvmStackVolatile = false;
    static final char[] SECRET_YIELD_VALUE_NAME = " yieldValue".toCharArray();
    private List<LocalVariableBinding> typesOnStack;
    public Results results = new Results();

    @Override
    public void setExpressionContext(ExpressionContext context) {
        this.expressionContext = context;
    }

    @Override
    public void setExpectedType(TypeBinding expectedType) {
        this.expectedType = expectedType;
    }

    @Override
    public ExpressionContext getExpressionContext() {
        return this.expressionContext;
    }

    @Override
    protected void reportMissingEnumConstantCase(BlockScope upperScope, FieldBinding enumConstant) {
        upperScope.problemReporter().missingEnumConstantCase(this, enumConstant);
    }

    @Override
    public boolean checkNPE(BlockScope skope, FlowContext flowContext, FlowInfo flowInfo, int ttlForFieldCheck) {
        if ((this.nullStatus & 2) != 0) {
            skope.problemReporter().expressionNullReference(this);
        } else if ((this.nullStatus & 0x10) != 0) {
            skope.problemReporter().expressionPotentialNullReference(this);
        }
        return true;
    }

    @Override
    protected boolean needToCheckFlowInAbsenceOfDefaultBranch() {
        return (this.switchBits & 1) == 0;
    }

    @Override
    public Expression[] getPolyExpressions() {
        ArrayList<Expression> polys = new ArrayList<Expression>();
        for (Expression e : this.results.rExpressions) {
            Expression[] ea = e.getPolyExpressions();
            if (ea == null || ea.length == 0) continue;
            polys.addAll(Arrays.asList(ea));
        }
        return polys.toArray(new Expression[0]);
    }

    @Override
    public boolean isPertinentToApplicability(TypeBinding targetType, MethodBinding method) {
        for (Expression e : this.results.rExpressions) {
            if (e.isPertinentToApplicability(targetType, method)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isPotentiallyCompatibleWith(TypeBinding targetType, Scope scope1) {
        for (Expression e : this.results.rExpressions) {
            if (e.isPotentiallyCompatibleWith(targetType, scope1)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isFunctionalType() {
        for (Expression e : this.results.rExpressions) {
            if (!e.isFunctionalType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int nullStatus(FlowInfo flowInfo, FlowContext flowContext) {
        if ((this.implicitConversion & 0x200) != 0) {
            return 4;
        }
        return this.nullStatus;
    }

    private LocalVariableBinding createStackSpillSlot(CodeStream codeStream, TypeBinding type, int typeId, int index, int resolvedPosition) {
        char[] name = CharOperation.concat(SECRET_YIELD_VALUE_NAME, String.valueOf(index).toCharArray());
        if (type == null && (type = TypeBinding.wellKnownType(this.scope, typeId)) == null) {
            type = this.scope.getJavaLangObject();
        }
        LocalVariableBinding lvb = new LocalVariableBinding(name, type, 0, false);
        lvb.setConstant(Constant.NotAConstant);
        lvb.useFlag = 1;
        lvb.resolvedPosition = resolvedPosition;
        this.scope.addLocalVariable(lvb);
        return lvb;
    }

    private void spillOperandStackIfNeeded(CodeStream codeStream) {
        int delta;
        int operandStackSize = codeStream.operandStack.size();
        if (!this.jvmStackVolatile || codeStream.stackDepth == 0 && operandStackSize == 0) {
            return;
        }
        int nextResolvedPosition = this.scope.offset;
        this.typesOnStack = new ArrayList<LocalVariableBinding>();
        int index = 0;
        while (operandStackSize > 0) {
            TypeBinding type = codeStream.operandStack.peek();
            LocalVariableBinding lvb = this.createStackSpillSlot(codeStream, type, 0, index++, nextResolvedPosition);
            nextResolvedPosition += (switch (lvb.type.id) {
                case 7, 8 -> 2;
                default -> 1;
            });
            this.typesOnStack.add(lvb);
            codeStream.store(lvb, false);
            codeStream.addVariable(lvb);
            operandStackSize = codeStream.operandStack.size();
        }
        if (codeStream.stackDepth != 0 || codeStream.operandStack.size() != 0) {
            codeStream.classFile.referenceBinding.scope.problemReporter().operandStackSizeInappropriate(codeStream.classFile.referenceBinding.scope.referenceContext);
        }
        if ((delta = nextResolvedPosition - this.scope.offset) > 0) {
            this.scope.adjustLocalVariablePositions(delta);
        }
    }

    public void refillOperandStackIfNeeded(CodeStream codeStream, YieldStatement yield) {
        List<LocalVariableBinding> tos;
        if (!this.jvmStackVolatile || this.typesOnStack == null || this.typesOnStack.isEmpty() || (yield.bits & 0x20000000) != 0) {
            return;
        }
        if (codeStream.stackDepth != 0 || codeStream.operandStack.size() != 0) {
            codeStream.classFile.referenceBinding.scope.problemReporter().operandStackSizeInappropriate(codeStream.classFile.referenceBinding.scope.referenceContext);
        }
        int index = (tos = this.typesOnStack) != null ? tos.size() - 1 : -1;
        while (index >= 0) {
            LocalVariableBinding lvb = tos.get(index--);
            codeStream.load(lvb);
        }
    }

    private void releaseStackSpillSlots(CodeStream codeStream) {
        List<LocalVariableBinding> tos = this.typesOnStack;
        int index = tos != null ? tos.size() - 1 : -1;
        while (index >= 0) {
            LocalVariableBinding lvb = tos.get(index--);
            codeStream.removeVariable(lvb);
        }
    }

    @Override
    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        this.spillOperandStackIfNeeded(codeStream);
        super.generateCode(currentScope, codeStream);
        if (this.jvmStackVolatile) {
            this.releaseStackSpillSlots(codeStream);
        }
        if (!valueRequired) {
            switch (this.postConversionType((Scope)currentScope).id) {
                case 7: 
                case 8: {
                    codeStream.pop2();
                    break;
                }
                default: {
                    codeStream.pop();
                    break;
                }
            }
        } else if (!this.isPolyExpression()) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        }
    }

    @Override
    public void resolve(BlockScope upperScope) {
        this.resolveType(upperScope);
    }

    @Override
    public TypeBinding resolveType(BlockScope upperScope) {
        try {
            if (this.constant != Constant.NotAConstant) {
                this.constant = Constant.NotAConstant;
                super.resolve(upperScope);
                if (this.results.rExpressions.size() == 0) {
                    upperScope.problemReporter().unyieldingSwitchExpression(this);
                    this.resolvedType = null;
                    TypeBinding typeBinding = null;
                    return typeBinding;
                }
                if (this.isPolyExpression() && (this.expectedType == null || !this.expectedType.isProperType(true))) {
                    PolyTypeBinding polyTypeBinding = new PolyTypeBinding(this);
                    return polyTypeBinding;
                }
            } else {
                for (Expression rExpression : this.results.rExpressions) {
                    if (!rExpression.isPolyExpression()) continue;
                    rExpression.resolveTypeExpecting(upperScope, this.expectedType);
                }
            }
            TypeBinding typeBinding = this.resolvedType = this.results.resultType();
            return typeBinding;
        }
        finally {
            if (this.scope != null) {
                this.scope.enclosingCase = null;
            }
        }
    }

    private TypeBinding resolveAsType(TypeBinding switchType) {
        for (Expression rExpression : this.results.rExpressions) {
            if (rExpression.resolvedType == null || !rExpression.resolvedType.isValidBinding()) continue;
            if (rExpression.isConstantValueOfTypeAssignableToType(rExpression.resolvedType, switchType) || rExpression.resolvedType.isCompatibleWith(switchType)) {
                rExpression.computeConversion(this.scope, switchType, rExpression.resolvedType);
                if (rExpression.resolvedType.needsUncheckedConversion(switchType)) {
                    this.scope.problemReporter().unsafeTypeConversion(rExpression, rExpression.resolvedType, switchType);
                }
                if (!(rExpression instanceof CastExpression) || (rExpression.bits & 0x4020) != 0) continue;
                CastExpression.checkNeedForAssignedCast(this.scope, switchType, (CastExpression)rExpression);
                continue;
            }
            if (this.isBoxingCompatible(rExpression.resolvedType, switchType, rExpression, this.scope)) {
                rExpression.computeConversion(this.scope, switchType, rExpression.resolvedType);
                if (!(rExpression instanceof CastExpression) || (rExpression.bits & 0x4020) != 0) continue;
                CastExpression.checkNeedForAssignedCast(this.scope, switchType, (CastExpression)rExpression);
                continue;
            }
            this.scope.problemReporter().typeMismatchError(rExpression.resolvedType, switchType, rExpression, null);
            return null;
        }
        return switchType.capture(this.scope, this.sourceStart, this.sourceEnd);
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        int status;
        flowInfo = super.analyseCode(currentScope, flowContext, flowInfo);
        if (currentScope.compilerOptions().enableSyntacticNullAnalysisForFields) {
            flowContext.expireNullCheckedFieldInfo();
        }
        int combinedStatus = status = this.results.rExpressions.iterator().next().nullStatus(flowInfo, flowContext);
        boolean identicalStatus = true;
        for (Expression rExpression : this.results.rExpressions) {
            status = rExpression.nullStatus(flowInfo, flowContext);
            identicalStatus &= combinedStatus == status;
            combinedStatus |= status;
        }
        if (identicalStatus) {
            this.nullStatus = status;
            return flowInfo;
        }
        status = Expression.computeNullStatus(0, combinedStatus);
        if (status > 0) {
            this.nullStatus = status;
        }
        return flowInfo;
    }

    @Override
    public boolean isPolyExpression() {
        return this.expressionContext == ExpressionContext.ASSIGNMENT_CONTEXT || this.expressionContext == ExpressionContext.INVOCATION_CONTEXT;
    }

    @Override
    public boolean isTrulyExpression() {
        return true;
    }

    @Override
    public boolean isCompatibleWith(TypeBinding left, Scope skope) {
        if (!this.isPolyExpression()) {
            return super.isCompatibleWith(left, skope);
        }
        for (Expression e : this.results.rExpressions) {
            if (e.isCompatibleWith(left, skope)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isBoxingCompatibleWith(TypeBinding targetType, Scope skope) {
        if (!this.isPolyExpression()) {
            return super.isBoxingCompatibleWith(targetType, skope);
        }
        for (Expression e : this.results.rExpressions) {
            if (e.isCompatibleWith(targetType, skope) || e.isBoxingCompatibleWith(targetType, skope)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean sIsMoreSpecific(TypeBinding s, TypeBinding t, Scope skope) {
        if (super.sIsMoreSpecific(s, t, skope)) {
            return true;
        }
        if (!this.isPolyExpression()) {
            return false;
        }
        for (Expression e : this.results.rExpressions) {
            if (e.sIsMoreSpecific(s, t, skope)) continue;
            return false;
        }
        return true;
    }

    @Override
    public StringBuilder printExpression(int tab, StringBuilder output, boolean makeShort) {
        if (!makeShort) {
            return super.printExpression(tab, output);
        }
        SwitchExpression.printIndent(tab, output).append("switch (");
        return this.expression.printExpression(0, output).append(") { ... }");
    }

    @Override
    public TypeBinding expectedType() {
        return this.expectedType;
    }

    public Set<Expression> resultExpressions() {
        return this.results.rExpressions;
    }

    class Results {
        private Set<Expression> rExpressions = new LinkedHashSet<Expression>(4);
        private Set<TypeBinding> rTypes = new HashSet<TypeBinding>();
        private boolean allUniform = true;
        private boolean allBoolean = true;
        private boolean allNumeric = true;
        private boolean allWellFormed = true;

        Results() {
        }

        private TypeBinding resultType() {
            if (!this.allWellFormed) {
                return null;
            }
            if (SwitchExpression.this.isPolyExpression()) {
                return SwitchExpression.this.resolveAsType(SwitchExpression.this.expectedType);
            }
            if (this.allUniform) {
                TypeBinding uniformType = null;
                for (Expression rExpression : this.rExpressions) {
                    TypeBinding typeBinding = uniformType = uniformType == null ? rExpression.resolvedType : NullAnnotationMatching.moreDangerousType(uniformType, rExpression.resolvedType);
                }
                return uniformType;
            }
            if (this.allBoolean) {
                return SwitchExpression.this.resolveAsType(TypeBinding.BOOLEAN);
            }
            if (this.allNumeric) {
                TypeBinding[] typeBindingArray = TypeBinding.NUMERIC_TYPES;
                int n = TypeBinding.NUMERIC_TYPES.length;
                int rExpression = 0;
                while (rExpression < n) {
                    TypeBinding type = typeBindingArray[rExpression];
                    TypeBinding result = switch (type.id) {
                        case 7, 8, 9, 10 -> {
                            if (this.rTypes.contains(type)) {
                                yield type;
                            }
                            yield null;
                        }
                        case 2, 3, 4 -> {
                            if (this.rTypes.contains(type)) {
                                if (type.id != 2 && this.rTypes.contains(TypeBinding.CHAR)) {
                                    yield TypeBinding.INT;
                                }
                                for (Expression rExpression : this.rExpressions) {
                                    if (rExpression.resolvedType.id != 10 || rExpression.constant == Constant.NotAConstant || rExpression.isConstantValueOfTypeAssignableToType(rExpression.resolvedType, type)) continue;
                                    yield TypeBinding.INT;
                                }
                                yield type;
                            }
                            yield null;
                        }
                        default -> throw new IllegalStateException("Unexpected control flow!");
                    };
                    if (result != null) {
                        return SwitchExpression.this.resolveAsType(result);
                    }
                    ++rExpression;
                }
                throw new IllegalStateException("Unexpected control flow!");
            }
            LookupEnvironment env = SwitchExpression.this.scope.environment();
            TypeBinding[] resultReferenceTypes = new TypeBinding[this.rExpressions.size()];
            int i = 0;
            for (Expression rExpression : this.rExpressions) {
                TypeBinding typeBinding = resultReferenceTypes[i++] = rExpression.resolvedType.isBaseType() ? env.computeBoxingType(rExpression.resolvedType) : rExpression.resolvedType;
            }
            TypeBinding lub = SwitchExpression.this.scope.lowerUpperBound(resultReferenceTypes);
            if (lub != null) {
                return SwitchExpression.this.resolveAsType(lub);
            }
            SwitchExpression.this.scope.problemReporter().incompatibleSwitchExpressionResults(SwitchExpression.this);
            return null;
        }

        public boolean add(Expression rxpression, TypeBinding rxpressionType) {
            this.rExpressions.add(rxpression);
            if (rxpressionType == null) {
                if (!rxpression.isPolyExpression() || ((IPolyExpression)((Object)rxpression)).expectedType() != null) {
                    this.allWellFormed = false;
                }
            } else if (!rxpressionType.isValidBinding()) {
                this.allWellFormed = false;
            }
            if (!this.allWellFormed || SwitchExpression.this.isPolyExpression()) {
                return this.allWellFormed;
            }
            rxpressionType = rxpressionType.unboxedType();
            this.allUniform &= TypeBinding.equalsEquals(this.rExpressions.iterator().next().resolvedType, rxpression.resolvedType);
            this.allBoolean &= rxpressionType.id == 5;
            this.allNumeric &= rxpressionType.isNumericType();
            if (this.allNumeric) {
                int i;
                boolean definiteType = true;
                if (rxpressionType.id == 10 && rxpression.constant != Constant.NotAConstant && (i = rxpression.constant.intValue()) <= 65535 && i >= Short.MIN_VALUE) {
                    definiteType = false;
                }
                if (definiteType) {
                    this.rTypes.add(rxpressionType);
                }
            }
            return true;
        }

        public String toString() {
            return this.rExpressions.toString();
        }
    }
}

