/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.FakedTrackingVariable;
import org.eclipse.jdt.internal.compiler.ast.FalseLiteral;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.RecordComponent;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SuperReference;
import org.eclipse.jdt.internal.compiler.ast.TrueLiteral;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.AnnotationContext;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.StackMapFrameCodeStream;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InitializationFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.JavaFeature;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.RecordComponentBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.Util;

public class ConstructorDeclaration
extends AbstractMethodDeclaration {
    public ExplicitConstructorCall constructorCall;
    public TypeParameter[] typeParameters;
    private ExceptionHandlingFlowContext prologueContext;
    private FlowInfo prologueInfo;
    public AbstractVariableDeclaration[] protoArguments;

    public ConstructorDeclaration(CompilationResult compilationResult) {
        super(compilationResult);
    }

    FlowInfo getPrologueInfo() {
        if (this.prologueInfo != null) {
            return this.prologueInfo;
        }
        return new UnconditionalFlowInfo();
    }

    public void analyseCode(ClassScope classScope, InitializationFlowContext initializerFlowContext, FlowInfo flowInfo, int initialReachMode) {
        this.analyseCode(classScope, initializerFlowContext, flowInfo, initialReachMode, this.prologueInfo != null ? AnalysisMode.REST : AnalysisMode.ALL);
    }

    public void analyseCode(ClassScope classScope, InitializationFlowContext initializerFlowContext, FlowInfo flowInfo, int initialReachMode, AnalysisMode mode) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            FieldBinding[] fields;
            ExceptionHandlingFlowContext constructorContext;
            int nonStaticFieldInfoReachMode;
            ExplicitConstructorCall lateConstructorCall;
            block36: {
                int size;
                List<TypeBinding> computedExceptions;
                Object declaringClass2;
                boolean hasArgumentNeedingAnalysis;
                block37: {
                    block38: {
                        MethodBinding methodBinding;
                        block35: {
                            lateConstructorCall = this.getLateConstructorCall();
                            boolean bl = hasArgumentNeedingAnalysis = this.constructorCall != null && this.constructorCall.hasArgumentNeedingAnalysis();
                            if (mode == AnalysisMode.PROLOGUE && lateConstructorCall == null && !hasArgumentNeedingAnalysis) {
                                return;
                            }
                            nonStaticFieldInfoReachMode = flowInfo.reachMode();
                            if (mode != AnalysisMode.REST) break block35;
                            constructorContext = this.prologueContext;
                            flowInfo = this.prologueInfo.addInitializationsFrom(flowInfo);
                            break block36;
                        }
                        flowInfo.setReachMode(initialReachMode);
                        MethodBinding constructorBinding = this.binding;
                        if (constructorBinding == null || (this.bits & 0x80) != 0 || constructorBinding.isUsed() || (!constructorBinding.isPrivate() ? !constructorBinding.isOrEnclosedByPrivateType() : (this.binding.declaringClass.tagBits & 0x1000000000000000L) == 0L) || this.constructorCall == null) break block37;
                        if (this.constructorCall.accessMode == 3) break block38;
                        ReferenceBinding superClass = constructorBinding.declaringClass.superclass();
                        if (superClass == null || (methodBinding = superClass.getExactConstructor(Binding.NO_PARAMETERS)) == null || !methodBinding.canBeSeenBy(SuperReference.implicitSuperConstructorCall(), this.scope)) break block37;
                        declaringClass2 = constructorBinding.declaringClass;
                        if (constructorBinding.isPublic() && constructorBinding.parameters.length == 0 && ((ReferenceBinding)declaringClass2).isStatic() && ((TypeBinding)declaringClass2).findSuperTypeOriginatingFrom(56, false) != null) break block37;
                    }
                    this.scope.problemReporter().unusedPrivateConstructor(this);
                }
                if (this.isRecursive(null)) {
                    this.scope.problemReporter().recursiveConstructorInvocation(this.constructorCall);
                }
                if (this.typeParameters != null && !this.scope.referenceCompilationUnit().compilationResult.hasSyntaxError) {
                    declaringClass2 = this.typeParameters;
                    int methodBinding = this.typeParameters.length;
                    int superClass = 0;
                    while (superClass < methodBinding) {
                        TypeParameter typeParameter = declaringClass2[superClass];
                        if ((typeParameter.binding.modifiers & 0x8000000) == 0) {
                            this.scope.problemReporter().unusedTypeParameter(typeParameter);
                        }
                        ++superClass;
                    }
                }
                constructorContext = new ExceptionHandlingFlowContext(initializerFlowContext.parent, this, this.binding.thrownExceptions, initializerFlowContext, this.scope, FlowInfo.DEAD_END);
                if (mode == AnalysisMode.PROLOGUE) {
                    this.prologueContext = constructorContext;
                }
                initializerFlowContext.checkInitializerExceptions(this.scope, constructorContext, flowInfo);
                if (this.binding.declaringClass.isAnonymousType() && (computedExceptions = constructorContext.extendedExceptions) != null && (size = computedExceptions.size()) > 0) {
                    ReferenceBinding[] actuallyThrownExceptions = new ReferenceBinding[size];
                    computedExceptions.toArray(actuallyThrownExceptions);
                    this.binding.thrownExceptions = actuallyThrownExceptions;
                }
                ConstructorDeclaration.analyseArguments(classScope.environment(), flowInfo, initializerFlowContext, this.arguments(true), this.binding, this.scope);
                if (JavaFeature.FLEXIBLE_CONSTRUCTOR_BODIES.isSupported(this.scope.compilerOptions())) {
                    this.scope.enterEarlyConstructionContext();
                }
                if (this.constructorCall != null) {
                    flowInfo = this.constructorCall.analyseCode(this.scope, constructorContext, flowInfo);
                    if (mode == AnalysisMode.PROLOGUE && hasArgumentNeedingAnalysis) {
                        this.prologueInfo = flowInfo.copy();
                    }
                    if (this.constructorCall.accessMode == 3) {
                        FieldBinding[] fieldBindingArray = fields = this.binding.declaringClass.fields();
                        int declaringClass2 = fields.length;
                        int actuallyThrownExceptions = 0;
                        while (actuallyThrownExceptions < declaringClass2) {
                            FieldBinding field = fieldBindingArray[actuallyThrownExceptions];
                            if (!field.isStatic()) {
                                flowInfo.markAsDefinitelyAssigned(field);
                            }
                            ++actuallyThrownExceptions;
                        }
                    }
                }
            }
            flowInfo.setReachMode(nonStaticFieldInfoReachMode);
            if (this.statements != null) {
                CompilerOptions compilerOptions = this.scope.compilerOptions();
                boolean enableSyntacticNullAnalysisForFields = compilerOptions.enableSyntacticNullAnalysisForFields;
                int complaintLevel = (nonStaticFieldInfoReachMode & 3) == 0 ? 0 : 1;
                Statement[] statementArray = this.statements;
                int n = this.statements.length;
                int n2 = 0;
                while (n2 < n) {
                    Statement stat = statementArray[n2];
                    if (mode == AnalysisMode.REST && lateConstructorCall != null) {
                        if (stat == lateConstructorCall) {
                            lateConstructorCall = null;
                        }
                    } else {
                        if ((complaintLevel = stat.complainIfUnreachable(flowInfo, this.scope, complaintLevel, true)) < 2) {
                            flowInfo = stat.analyseCode(this.scope, constructorContext, flowInfo);
                        }
                        if (enableSyntacticNullAnalysisForFields) {
                            constructorContext.expireNullCheckedFieldInfo();
                        }
                        if (compilerOptions.analyseResourceLeaks) {
                            FakedTrackingVariable.cleanUpUnassigned(this.scope, stat, flowInfo, false);
                        }
                        if (mode == AnalysisMode.PROLOGUE && stat == lateConstructorCall) break;
                    }
                    ++n2;
                }
                if (mode == AnalysisMode.PROLOGUE) {
                    if (this.prologueInfo == null) {
                        this.prologueInfo = flowInfo;
                    }
                    return;
                }
            }
            if ((flowInfo.tagBits & 1) == 0) {
                this.bits |= 0x40;
            }
            if (this.isCompactConstructor()) {
                FieldBinding[] fieldBindingArray = this.binding.declaringClass.fields();
                int n = fieldBindingArray.length;
                int n3 = 0;
                while (n3 < n) {
                    FieldBinding field = fieldBindingArray[n3];
                    if (!field.isStatic()) {
                        flowInfo.markAsDefinitelyAssigned(field);
                    }
                    ++n3;
                }
            }
            if (this.constructorCall != null && this.constructorCall.accessMode != 3) {
                flowInfo = flowInfo.mergedWith(constructorContext.initsOnReturn);
                fields = this.binding.declaringClass.fields();
                this.doFieldReachAnalysis(flowInfo, fields);
            }
            constructorContext.complainIfUnusedExceptionHandlers(this);
            this.scope.checkUnusedParameters(this.binding);
            this.scope.checkUnclosedCloseables(flowInfo, null, null, null);
        }
        catch (AbortMethod e) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    @Override
    public AbstractVariableDeclaration[] arguments(boolean includedElided) {
        return includedElided && this.isCompactConstructor() ? this.protoArguments : super.arguments(includedElided);
    }

    @Override
    public LocalVariableBinding[] argumentBindings() {
        return this.isCompactConstructor() ? (this.scope == null ? Binding.NO_ARGUMENT_BINDINGS : this.scope.argumentBindings()) : super.argumentBindings();
    }

    protected void doFieldReachAnalysis(FlowInfo flowInfo, FieldBinding[] fields) {
        FieldBinding[] fieldBindingArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            FieldBinding field = fieldBindingArray[n2];
            if (!field.isStatic() && !flowInfo.isDefinitelyAssigned(field)) {
                FieldDeclaration fieldDecl;
                if (field.isFinal()) {
                    this.scope.problemReporter().uninitializedBlankFinalField(field, (this.bits & 0x80) != 0 ? this.scope.referenceType().declarationOf(field.original()) : this);
                } else if ((field.isNonNull() || field.type.isFreeTypeVariable()) && !this.isValueProvidedUsingAnnotation(fieldDecl = this.scope.referenceType().declarationOf(field.original()))) {
                    this.scope.problemReporter().uninitializedNonNullField(field, (this.bits & 0x80) != 0 ? fieldDecl : this);
                }
            }
            ++n2;
        }
    }

    boolean isValueProvidedUsingAnnotation(FieldDeclaration fieldDecl) {
        if (fieldDecl.annotations != null) {
            int length = fieldDecl.annotations.length;
            int i = 0;
            while (i < length) {
                Annotation annotation = fieldDecl.annotations[i];
                if (annotation.resolvedType.id == 80) {
                    return true;
                }
                if (annotation.resolvedType.id == 81) {
                    memberValuePairs = annotation.memberValuePairs();
                    if (memberValuePairs == Annotation.NoValuePairs) {
                        return true;
                    }
                    var9_9 = memberValuePairs;
                    var8_8 = memberValuePairs.length;
                    var7_7 = 0;
                    while (var7_7 < var8_8) {
                        memberValuePair = var9_9[var7_7];
                        if (CharOperation.equals(memberValuePair.name, TypeConstants.OPTIONAL)) {
                            return memberValuePair.value instanceof FalseLiteral;
                        }
                        ++var7_7;
                    }
                } else if (annotation.resolvedType.id == 82) {
                    memberValuePairs = annotation.memberValuePairs();
                    if (memberValuePairs == Annotation.NoValuePairs) {
                        return true;
                    }
                    var9_9 = memberValuePairs;
                    var8_8 = memberValuePairs.length;
                    var7_7 = 0;
                    while (var7_7 < var8_8) {
                        memberValuePair = var9_9[var7_7];
                        if (CharOperation.equals(memberValuePair.name, TypeConstants.REQUIRED)) {
                            return memberValuePair.value instanceof TrueLiteral;
                        }
                        ++var7_7;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public void generateCode(ClassScope classScope, ClassFile classFile) {
        TypeDeclaration referenceContext;
        int problemResetPC = 0;
        if (this.ignoreFurtherInvestigation) {
            if (this.binding == null) {
                return;
            }
            CategorizedProblem[] problems = this.scope.referenceCompilationUnit().compilationResult.getProblems();
            int problemsLength = problems.length;
            CategorizedProblem[] problemsCopy = new CategorizedProblem[problemsLength];
            System.arraycopy(problems, 0, problemsCopy, 0, problemsLength);
            classFile.addProblemConstructor(this, this.binding, problemsCopy);
            return;
        }
        boolean restart = false;
        boolean abort = false;
        CompilationResult unitResult = null;
        int problemCount = 0;
        if (classScope != null && (referenceContext = classScope.referenceContext) != null) {
            unitResult = referenceContext.compilationResult();
            problemCount = unitResult.problemCount;
        }
        do {
            try {
                problemResetPC = classFile.contentsOffset;
                this.internalGenerateCode(classScope, classFile);
                restart = false;
            }
            catch (AbortMethod e) {
                if (e.compilationResult == CodeStream.RESTART_IN_WIDE_MODE) {
                    classFile.contentsOffset = problemResetPC;
                    --classFile.methodCount;
                    classFile.codeStream.resetInWideMode();
                    if (unitResult != null) {
                        unitResult.problemCount = problemCount;
                    }
                    restart = true;
                    continue;
                }
                if (e.compilationResult == CodeStream.RESTART_CODE_GEN_FOR_UNUSED_LOCALS_MODE) {
                    classFile.contentsOffset = problemResetPC;
                    --classFile.methodCount;
                    classFile.codeStream.resetForCodeGenUnusedLocals();
                    if (unitResult != null) {
                        unitResult.problemCount = problemCount;
                    }
                    restart = true;
                    continue;
                }
                restart = false;
                abort = true;
            }
        } while (restart);
        if (abort) {
            CategorizedProblem[] problems = this.scope.referenceCompilationUnit().compilationResult.getAllProblems();
            int problemsLength = problems.length;
            CategorizedProblem[] problemsCopy = new CategorizedProblem[problemsLength];
            System.arraycopy(problems, 0, problemsCopy, 0, problemsLength);
            classFile.addProblemConstructor(this, this.binding, problemsCopy, problemResetPC);
        }
    }

    public void generateSyntheticFieldInitializationsIfNecessary(MethodScope methodScope, CodeStream codeStream, ReferenceBinding declaringClass) {
        SyntheticArgumentBinding syntheticArg;
        int n;
        int n2;
        SyntheticArgumentBinding[] syntheticArgumentBindingArray;
        if (!declaringClass.isNestedType()) {
            return;
        }
        NestedTypeBinding nestedType = (NestedTypeBinding)declaringClass;
        SyntheticArgumentBinding[] syntheticArgs = nestedType.syntheticEnclosingInstances();
        if (syntheticArgs != null) {
            syntheticArgumentBindingArray = syntheticArgs;
            n2 = syntheticArgs.length;
            n = 0;
            while (n < n2) {
                syntheticArg = syntheticArgumentBindingArray[n];
                if (syntheticArg.matchingField != null) {
                    codeStream.aload_0();
                    codeStream.load(syntheticArg);
                    codeStream.fieldAccess((byte)-75, syntheticArg.matchingField, null);
                }
                ++n;
            }
        }
        if ((syntheticArgs = nestedType.syntheticOuterLocalVariables()) != null) {
            syntheticArgumentBindingArray = syntheticArgs;
            n2 = syntheticArgs.length;
            n = 0;
            while (n < n2) {
                syntheticArg = syntheticArgumentBindingArray[n];
                if (syntheticArg.matchingField != null) {
                    codeStream.aload_0();
                    codeStream.load(syntheticArg);
                    codeStream.fieldAccess((byte)-75, syntheticArg.matchingField, null);
                }
                ++n;
            }
        }
    }

    private void internalGenerateCode(ClassScope classScope, ClassFile classFile) {
        classFile.generateMethodInfoHeader(this.binding);
        int methodAttributeOffset = classFile.contentsOffset;
        int attributeNumber = classFile.generateMethodInfoAttributes(this.binding);
        if (!this.binding.isNative() && !this.binding.isAbstract()) {
            int n;
            int n2;
            Statement[] statementArray;
            boolean needFieldInitializations;
            TypeDeclaration declaringType = classScope.referenceContext;
            int codeAttributeOffset = classFile.contentsOffset;
            classFile.generateCodeAttributeHeader();
            CodeStream codeStream = classFile.codeStream;
            codeStream.reset(this, classFile);
            ReferenceBinding declaringClass = this.binding.declaringClass;
            int enumOffset = declaringClass.isEnum() ? 2 : 0;
            int argSlotSize = 1 + enumOffset;
            if (declaringClass.isNestedType()) {
                this.scope.extraSyntheticArguments = declaringClass.syntheticOuterLocalVariables();
                this.scope.computeLocalVariablePositions(declaringClass.getEnclosingInstancesSlotSize() + 1 + enumOffset, codeStream);
                argSlotSize += declaringClass.getEnclosingInstancesSlotSize();
                argSlotSize += declaringClass.getOuterLocalVariablesSlotSize();
            } else {
                this.scope.computeLocalVariablePositions(1 + enumOffset, codeStream);
            }
            LocalVariableBinding[] localVariableBindingArray = this.scope.locals;
            int n3 = this.scope.locals.length;
            int n4 = 0;
            while (n4 < n3) {
                LocalVariableBinding local = localVariableBindingArray[n4];
                if (local != null && local.isParameter()) {
                    codeStream.addVisibleLocalVariable(local);
                    local.recordInitializationStartPC(0);
                    switch (local.type.id) {
                        case 7: 
                        case 8: {
                            argSlotSize += 2;
                            break;
                        }
                        default: {
                            ++argSlotSize;
                        }
                    }
                }
                ++n4;
            }
            MethodScope initializerScope = declaringType.initializerScope;
            initializerScope.computeLocalVariablePositions(argSlotSize, codeStream);
            codeStream.pushPatternAccessTrapScope(this.scope);
            boolean bl = needFieldInitializations = this.constructorCall == null || this.constructorCall.accessMode != 3;
            if (needFieldInitializations) {
                this.generateSyntheticFieldInitializationsIfNecessary(this.scope, codeStream, declaringClass);
                codeStream.recordPositionsFrom(0, this.bodyStart > 0 ? this.bodyStart : this.sourceStart);
            }
            if (JavaFeature.FLEXIBLE_CONSTRUCTOR_BODIES.isSupported(this.scope.compilerOptions())) {
                this.scope.enterEarlyConstructionContext();
            }
            if (this.constructorCall != null) {
                this.constructorCall.generateCode(this.scope, codeStream);
            }
            ExplicitConstructorCall lateConstructorCall = this.getLateConstructorCall();
            if (needFieldInitializations && lateConstructorCall == null) {
                this.generateFieldInitializations(declaringType, codeStream, initializerScope);
            }
            if (this.statements != null) {
                statementArray = this.statements;
                n2 = this.statements.length;
                n = 0;
                while (n < n2) {
                    Statement statement = statementArray[n];
                    statement.generateCode(this.scope, codeStream);
                    if (!(this.compilationResult.hasErrors() || codeStream.stackDepth == 0 && codeStream.operandStack.size() == 0)) {
                        this.scope.problemReporter().operandStackSizeInappropriate(this);
                    }
                    if (lateConstructorCall == statement) {
                        this.generateFieldInitializations(declaringType, codeStream, initializerScope);
                    }
                    ++n;
                }
            }
            if (this.ignoreFurtherInvestigation) {
                throw new AbortMethod(this.scope.referenceCompilationUnit().compilationResult, null);
            }
            if ((this.bits & 0x40) != 0) {
                if (this.isCompactConstructor()) {
                    statementArray = classScope.referenceContext.recordComponents;
                    n2 = classScope.referenceContext.recordComponents.length;
                    n = 0;
                    while (n < n2) {
                        Statement rc = statementArray[n];
                        LocalVariableBinding parameter = this.scope.findVariable(((RecordComponent)rc).name);
                        FieldBinding field = classScope.referenceContext.binding.getField(((RecordComponent)rc).name, true).original();
                        codeStream.aload_0();
                        codeStream.load(parameter);
                        codeStream.fieldAccess((byte)-75, field, classScope.referenceContext.binding);
                        ++n;
                    }
                }
                codeStream.return_();
            }
            codeStream.exitUserScope(this.scope, lvb -> !lvb.isParameter());
            codeStream.handleRecordAccessorExceptions(this.scope);
            codeStream.exitUserScope(this.scope);
            codeStream.recordPositionsFrom(0, this.bodyEnd > 0 ? this.bodyEnd : this.sourceStart);
            try {
                classFile.completeCodeAttribute(codeAttributeOffset, this.scope);
            }
            catch (NegativeArraySizeException e) {
                throw new AbortMethod(this.scope.referenceCompilationUnit().compilationResult, null);
            }
            ++attributeNumber;
            if (codeStream instanceof StackMapFrameCodeStream && needFieldInitializations && declaringType.fields != null) {
                ((StackMapFrameCodeStream)codeStream).resetSecretLocals();
            }
        }
        classFile.completeMethodInfo(this.binding, methodAttributeOffset, attributeNumber);
    }

    private void generateFieldInitializations(TypeDeclaration declaringType, CodeStream codeStream, MethodScope initializerScope) {
        if (declaringType.fields != null) {
            FieldDeclaration[] fieldDeclarationArray = declaringType.fields;
            int n = declaringType.fields.length;
            int n2 = 0;
            while (n2 < n) {
                FieldDeclaration field = fieldDeclarationArray[n2];
                if (!field.isStatic()) {
                    field.generateCode(initializerScope, codeStream);
                }
                ++n2;
            }
        }
    }

    @Override
    public void getAllAnnotationContexts(int targetType, List allAnnotationContexts) {
        SingleTypeReference fakeReturnType = new SingleTypeReference(this.selector, 0L);
        fakeReturnType.resolvedType = this.binding.declaringClass;
        TypeReference.AnnotationCollector collector = new TypeReference.AnnotationCollector(fakeReturnType, targetType, (List<AnnotationContext>)allAnnotationContexts);
        Annotation[] annotationArray = this.annotations;
        int n = this.annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            annotation.traverse((ASTVisitor)collector, (BlockScope)null);
            ++n2;
        }
    }

    @Override
    public boolean isConstructor() {
        return true;
    }

    @Override
    public boolean isCanonicalConstructor() {
        return (this.bits & 0x200) != 0;
    }

    @Override
    public boolean isCompactConstructor() {
        return (this.modifiers & 0x800000) != 0;
    }

    @Override
    public boolean isDefaultConstructor() {
        return (this.bits & 0x80) != 0;
    }

    @Override
    public boolean isInitializationMethod() {
        return true;
    }

    public boolean isRecursive(ArrayList visited) {
        if (this.binding == null || this.constructorCall == null || this.constructorCall.binding == null || this.constructorCall.isSuperAccess() || !this.constructorCall.binding.isValidBinding()) {
            return false;
        }
        ConstructorDeclaration targetConstructor = (ConstructorDeclaration)this.scope.referenceType().declarationOf(this.constructorCall.binding.original());
        if (targetConstructor == null) {
            return false;
        }
        if (this == targetConstructor) {
            return true;
        }
        if (visited == null) {
            visited = new ArrayList<ConstructorDeclaration>(1);
        } else {
            int index = visited.indexOf(this);
            if (index >= 0) {
                return index == 0;
            }
        }
        visited.add(this);
        return targetConstructor.isRecursive(visited);
    }

    @Override
    public void parseStatements(Parser parser, CompilationUnitDeclaration unit) {
        if (this.isCompactConstructor()) {
            this.constructorCall = SuperReference.implicitSuperConstructorCall();
            this.constructorCall.sourceStart = this.sourceStart;
            this.constructorCall.sourceEnd = this.sourceEnd;
        } else if ((this.bits & 0x80) != 0 && this.constructorCall == null) {
            this.constructorCall = SuperReference.implicitSuperConstructorCall();
            this.constructorCall.sourceStart = this.sourceStart;
            this.constructorCall.sourceEnd = this.sourceEnd;
            return;
        }
        parser.parse(this, unit, false);
    }

    @Override
    public StringBuilder printBody(int indent, StringBuilder output) {
        output.append(" {");
        if (this.constructorCall != null) {
            output.append('\n');
            this.constructorCall.printStatement(indent, output);
        }
        if (this.statements != null) {
            Statement[] statementArray = this.statements;
            int n = this.statements.length;
            int n2 = 0;
            while (n2 < n) {
                Statement statement = statementArray[n2];
                output.append('\n');
                statement.printStatement(indent, output);
                ++n2;
            }
        }
        output.append('\n');
        ConstructorDeclaration.printIndent(indent == 0 ? 0 : indent - 1, output).append('}');
        return output;
    }

    @Override
    public void resolveJavadoc() {
        if (this.binding == null || this.javadoc != null) {
            super.resolveJavadoc();
        } else if ((this.bits & 0x80) == 0 && this.binding.declaringClass != null && !this.binding.declaringClass.isLocalType()) {
            int javadocVisibility = this.binding.modifiers & 7;
            ClassScope classScope = this.scope.classScope();
            ProblemReporter reporter = this.scope.problemReporter();
            int severity = reporter.computeSeverity(-1610612250);
            if (severity != 256) {
                if (classScope != null) {
                    javadocVisibility = Util.computeOuterMostVisibility(classScope.referenceType(), javadocVisibility);
                }
                int javadocModifiers = this.binding.modifiers & 0xFFFFFFF8 | javadocVisibility;
                reporter.javadocMissing(this.sourceStart, this.sourceEnd, severity, javadocModifiers);
            }
        }
    }

    @Override
    public void resolve(ClassScope upperScope) {
        if (this.binding != null && this.binding.isCanonicalConstructor()) {
            boolean lastComponentVarargs;
            RecordComponentBinding[] rcbs = upperScope.referenceContext.binding.components();
            boolean bl = lastComponentVarargs = rcbs.length > 0 && rcbs[rcbs.length - 1].sourceRecordComponent().isVarArgs();
            if (this.binding.isVarargs() != lastComponentVarargs) {
                upperScope.problemReporter().recordErasureIncompatibilityInCanonicalConstructor(this.arguments[this.arguments.length - 1].type);
            }
            int i = 0;
            while (i < rcbs.length) {
                TypeBinding mpt = this.binding.parameters[i];
                TypeBinding rct = rcbs[i].type;
                if (TypeBinding.notEquals(mpt, rct)) {
                    upperScope.problemReporter().recordErasureIncompatibilityInCanonicalConstructor(this.arguments[i].type);
                }
                ++i;
            }
            if (!this.binding.isAsVisible(this.binding.declaringClass)) {
                this.scope.problemReporter().recordCanonicalConstructorVisibilityReduced(this);
            }
            if (this.typeParameters != null && this.typeParameters.length > 0) {
                this.scope.problemReporter().recordCanonicalConstructorShouldNotBeGeneric(this);
            }
            if (this.binding.thrownExceptions != null && this.binding.thrownExceptions.length > 0) {
                this.scope.problemReporter().recordCanonicalConstructorHasThrowsClause(this);
            }
            if (!this.isCompactConstructor()) {
                i = 0;
                while (i < rcbs.length) {
                    if (!CharOperation.equals(this.arguments[i].name, rcbs[i].name)) {
                        this.scope.problemReporter().recordIllegalParameterNameInCanonicalConstructor(rcbs[i], this.arguments[i]);
                    }
                    ++i;
                }
            }
        }
        super.resolve(upperScope);
    }

    @Override
    public void resolveStatements() {
        SourceTypeBinding sourceType = this.scope.enclosingSourceType();
        if (!CharOperation.equals(sourceType.sourceName, this.selector)) {
            this.scope.problemReporter().missingReturnType(this);
        }
        if (this.binding != null && !this.binding.isPrivate()) {
            sourceType.tagBits |= 0x1000000000000000L;
        }
        if (this.constructorCall != null) {
            if (sourceType.id == 1 && this.constructorCall.accessMode != 3) {
                if (this.constructorCall.accessMode == 2) {
                    this.scope.problemReporter().cannotUseSuperInJavaLangObject(this.constructorCall);
                }
                this.constructorCall = null;
            } else if (sourceType.isRecord() && !this.isCompactConstructor() && this.binding != null && !this.binding.isCanonicalConstructor() && this.constructorCall.accessMode != 3) {
                this.scope.problemReporter().recordMissingExplicitConstructorCallInNonCanonicalConstructor(this);
                this.constructorCall = null;
            } else {
                this.scope.enterEarlyConstructionContext();
                if (this.getLateConstructorCall() != null) {
                    this.constructorCall = null;
                } else {
                    this.constructorCall.resolve(this.scope);
                }
            }
        }
        if ((this.modifiers & 0x1000000) != 0) {
            this.scope.problemReporter().methodNeedBody(this);
        }
        super.resolveStatements();
    }

    ExplicitConstructorCall getLateConstructorCall() {
        if (!JavaFeature.FLEXIBLE_CONSTRUCTOR_BODIES.isSupported(this.scope.compilerOptions())) {
            return null;
        }
        if (this.constructorCall != null && !this.constructorCall.isImplicitSuper()) {
            return null;
        }
        if (this.statements == null) {
            return null;
        }
        int i = 0;
        while (i < this.statements.length) {
            Statement statement = this.statements[i];
            if (statement instanceof ExplicitConstructorCall) {
                ExplicitConstructorCall ctorCall = (ExplicitConstructorCall)statement;
                return i > 0 ? ctorCall : null;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void traverse(ASTVisitor visitor, ClassScope classScope) {
        if (visitor.visit(this, classScope)) {
            int i;
            if (this.javadoc != null) {
                this.javadoc.traverse(visitor, this.scope);
            }
            if (this.annotations != null) {
                int annotationsLength = this.annotations.length;
                i = 0;
                while (i < annotationsLength) {
                    this.annotations[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
            if (this.typeParameters != null) {
                int typeParametersLength = this.typeParameters.length;
                i = 0;
                while (i < typeParametersLength) {
                    this.typeParameters[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
            if (this.arguments != null) {
                int argumentLength = this.arguments.length;
                i = 0;
                while (i < argumentLength) {
                    this.arguments[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
            if (this.thrownExceptions != null) {
                int thrownExceptionsLength = this.thrownExceptions.length;
                i = 0;
                while (i < thrownExceptionsLength) {
                    this.thrownExceptions[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
            if (this.constructorCall != null) {
                this.constructorCall.traverse(visitor, this.scope);
            }
            if (this.statements != null) {
                int statementsLength = this.statements.length;
                i = 0;
                while (i < statementsLength) {
                    this.statements[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
        }
        visitor.endVisit(this, classScope);
    }

    @Override
    public TypeParameter[] typeParameters() {
        return this.typeParameters;
    }

    static enum AnalysisMode {
        ALL,
        PROLOGUE,
        REST;

    }
}

