/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.AbortSearchException;

public final class ForLoops {
    private static final String LENGTH = "length";
    private static final String SIZE_METHOD = "size";
    private static final String HAS_NEXT_METHOD = "hasNext";
    private static final String ITERATOR_METHOD = "iterator";

    private ForLoops() {
    }

    public static ForLoopContent iterateOverContainer(ForStatement node) {
        Expression initialValue;
        Expression initialVariable;
        List initializers = node.initializers();
        List updaters = node.updaters();
        if (initializers.isEmpty() || initializers.size() > 2 || updaters.size() > 1) {
            return null;
        }
        AtomicBoolean isLoopingForward = new AtomicBoolean();
        Name updater = null;
        if (updaters.size() == 1 && (updater = ForLoops.getUpdaterOperand((Expression)updaters.get(0), isLoopingForward)) == null) {
            return null;
        }
        Expression endVariable = null;
        Expression endValue = null;
        ArrayList<Expression> initializerVariables = new ArrayList<Expression>();
        ArrayList<Expression> initializerValues = new ArrayList<Expression>();
        if (!ForLoops.getInitialization((Expression)initializers.get(0), initializerVariables, initializerValues)) {
            return null;
        }
        if (initializers.size() == 2 && !ForLoops.getInitialization((Expression)initializers.get(1), initializerVariables, initializerValues)) {
            return null;
        }
        if (initializers.size() > 2) {
            return null;
        }
        if (initializerVariables.size() == 2) {
            if (ASTNodes.isSameVariable((ASTNode)initializerVariables.get(0), (ASTNode)updater)) {
                initialVariable = (Expression)initializerVariables.get(0);
                initialValue = (Expression)initializerValues.get(0);
                endVariable = (Expression)initializerVariables.get(1);
                endValue = (Expression)initializerValues.get(1);
            } else if (ASTNodes.isSameVariable((ASTNode)initializerVariables.get(1), (ASTNode)updater)) {
                initialVariable = (Expression)initializerVariables.get(1);
                initialValue = (Expression)initializerValues.get(1);
                endVariable = (Expression)initializerVariables.get(0);
                endValue = (Expression)initializerValues.get(0);
            } else {
                return null;
            }
            final Expression finalEndVariable = endVariable;
            ASTVisitor variableUseVisitor = new ASTVisitor(){

                public boolean visit(SimpleName aSimpleName) {
                    if (ASTNodes.isSameVariable((ASTNode)finalEndVariable, (ASTNode)aSimpleName)) {
                        throw new AbortSearchException();
                    }
                    return true;
                }
            };
            try {
                node.getBody().accept(variableUseVisitor);
            }
            catch (AbortSearchException e) {
                return null;
            }
        } else {
            initialVariable = (Expression)initializerVariables.get(0);
            initialValue = (Expression)initializerValues.get(0);
        }
        Expression condition = node.getExpression();
        if (updater == null) {
            if (initializerVariables.size() == 2) {
                return null;
            }
            MethodInvocation conditionMethodInvocation = ASTNodes.as(condition, MethodInvocation.class);
            MethodInvocation initMethodInvocation = ASTNodes.as(initialValue, MethodInvocation.class);
            if (conditionMethodInvocation != null && ASTNodes.isSameVariable((ASTNode)initialVariable, (ASTNode)conditionMethodInvocation.getExpression()) && ASTNodes.usesGivenSignature(initMethodInvocation, Collection.class.getCanonicalName(), ITERATOR_METHOD, new String[0]) && ASTNodes.usesGivenSignature(conditionMethodInvocation, Iterator.class.getCanonicalName(), HAS_NEXT_METHOD, new String[0])) {
                return ForLoops.getIteratorOnCollection(initMethodInvocation.getExpression(), conditionMethodInvocation.getExpression());
            }
        } else if (ASTNodes.hasType(initialVariable, Integer.TYPE.getSimpleName())) {
            InfixExpression startValueMinusOne = ASTNodes.as(initialValue, InfixExpression.class);
            Expression collectionOnSize = null;
            Expression arrayOnLength = null;
            if (startValueMinusOne != null && !startValueMinusOne.hasExtendedOperands() && ASTNodes.hasOperator(startValueMinusOne, InfixExpression.Operator.MINUS, new InfixExpression.Operator[0])) {
                Long one = ASTNodes.getIntegerLiteral(startValueMinusOne.getRightOperand());
                if (Long.valueOf(1L).equals(one)) {
                    collectionOnSize = ForLoops.getCollectionOnSize(startValueMinusOne.getLeftOperand());
                    arrayOnLength = ForLoops.getArrayOnLength(startValueMinusOne.getLeftOperand());
                }
            }
            Long initialInteger = ASTNodes.getIntegerLiteral(initialValue);
            ForLoopContent forContent = ForLoops.getIndexOnIterable(condition, endVariable, endValue, initialVariable, collectionOnSize, arrayOnLength, isLoopingForward.get());
            if (forContent != null && ASTNodes.isSameVariable((ASTNode)initialVariable, (ASTNode)forContent.loopVariable) && ASTNodes.isSameVariable((ASTNode)initialVariable, (ASTNode)updater) && isLoopingForward.get() == Long.valueOf(0L).equals(initialInteger)) {
                return forContent;
            }
        }
        return null;
    }

    private static boolean getInitialization(Expression initializer, List<Expression> variables, List<Expression> values) {
        VariableDeclarationExpression variableDeclarationExpression = ASTNodes.as(initializer, VariableDeclarationExpression.class);
        if (variableDeclarationExpression != null) {
            List fragments = variableDeclarationExpression.fragments();
            if (fragments.size() > 2) {
                return false;
            }
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
            variables.add((Expression)fragment.getName());
            values.add(fragment.getInitializer());
            if (fragments.size() == 2) {
                fragment = (VariableDeclarationFragment)fragments.get(1);
                variables.add((Expression)fragment.getName());
                values.add(fragment.getInitializer());
            }
            return true;
        }
        Assignment assignment = ASTNodes.as(initializer, Assignment.class);
        if (assignment != null && ASTNodes.hasOperator(assignment, Assignment.Operator.ASSIGN, new Assignment.Operator[0])) {
            variables.add(assignment.getLeftHandSide());
            values.add(assignment.getRightHandSide());
            return true;
        }
        return false;
    }

    private static ForLoopContent getIteratorOnCollection(Expression containerVar, Expression iteratorVariable) {
        if (containerVar instanceof Name || containerVar instanceof FieldAccess || containerVar instanceof SuperFieldAccess) {
            return ForLoopContent.iteratedCollection(containerVar, iteratorVariable);
        }
        return null;
    }

    private static Name getUpdaterOperand(Expression updater, AtomicBoolean isLoopingForward) {
        Expression updaterOperand = null;
        if (updater instanceof PostfixExpression) {
            PostfixExpression postfixExpression = (PostfixExpression)updater;
            if (ASTNodes.hasOperator(postfixExpression, PostfixExpression.Operator.INCREMENT, new PostfixExpression.Operator[0])) {
                isLoopingForward.set(true);
                updaterOperand = postfixExpression.getOperand();
            }
            if (ASTNodes.hasOperator(postfixExpression, PostfixExpression.Operator.DECREMENT, new PostfixExpression.Operator[0])) {
                isLoopingForward.set(false);
                updaterOperand = postfixExpression.getOperand();
            }
        } else if (updater instanceof PrefixExpression) {
            PrefixExpression prefixExpression = (PrefixExpression)updater;
            if (ASTNodes.hasOperator(prefixExpression, PrefixExpression.Operator.INCREMENT, new PrefixExpression.Operator[0])) {
                isLoopingForward.set(true);
                updaterOperand = prefixExpression.getOperand();
            }
            if (ASTNodes.hasOperator(prefixExpression, PrefixExpression.Operator.DECREMENT, new PrefixExpression.Operator[0])) {
                isLoopingForward.set(false);
                updaterOperand = prefixExpression.getOperand();
            }
        }
        return ASTNodes.as(updaterOperand, Name.class);
    }

    private static ForLoopContent getIndexOnIterable(Expression condition, Expression endVariable, Expression endValue, Expression loopVariable, Expression collectionOnSize, Expression arrayOnLength, boolean isLoopingForward) {
        InfixExpression infixExpression = ASTNodes.as(condition, InfixExpression.class);
        if (infixExpression != null && !infixExpression.hasExtendedOperands()) {
            Expression leftOperand = infixExpression.getLeftOperand();
            Expression rightOperand = infixExpression.getRightOperand();
            if (!(loopVariable instanceof Name)) {
                return null;
            }
            if (isLoopingForward) {
                if (ASTNodes.hasOperator(infixExpression, InfixExpression.Operator.LESS, InfixExpression.Operator.NOT_EQUALS) && ASTNodes.isSameLocalVariable(loopVariable, leftOperand)) {
                    return ForLoops.buildForLoopContent((Name)loopVariable, rightOperand, endVariable, endValue, isLoopingForward, collectionOnSize, arrayOnLength);
                }
                if (ASTNodes.hasOperator(infixExpression, InfixExpression.Operator.GREATER, InfixExpression.Operator.NOT_EQUALS) && ASTNodes.isSameLocalVariable(loopVariable, rightOperand)) {
                    return ForLoops.buildForLoopContent((Name)loopVariable, leftOperand, endVariable, endValue, isLoopingForward, collectionOnSize, arrayOnLength);
                }
            } else if (collectionOnSize != null || arrayOnLength != null) {
                if (ASTNodes.hasOperator(infixExpression, InfixExpression.Operator.GREATER_EQUALS, new InfixExpression.Operator[0]) && ASTNodes.isSameLocalVariable(loopVariable, leftOperand)) {
                    return ForLoops.buildForLoopContent((Name)loopVariable, rightOperand, endVariable, endValue, isLoopingForward, collectionOnSize, arrayOnLength);
                }
                if (ASTNodes.hasOperator(infixExpression, InfixExpression.Operator.LESS_EQUALS, new InfixExpression.Operator[0]) && ASTNodes.isSameLocalVariable(loopVariable, rightOperand)) {
                    return ForLoops.buildForLoopContent((Name)loopVariable, leftOperand, endVariable, endValue, isLoopingForward, collectionOnSize, arrayOnLength);
                }
            }
        }
        return null;
    }

    private static ForLoopContent buildForLoopContent(Name loopVar, Expression containerVariable, Expression endVariable, Expression endValue, boolean isLoopingForward, Expression collectionOnSize, Expression arrayOnLength) {
        Expression endOfLoop;
        if (endVariable != null) {
            if (!ASTNodes.isSameVariable((ASTNode)containerVariable, (ASTNode)endVariable)) {
                return null;
            }
            endOfLoop = endValue;
        } else {
            endOfLoop = containerVariable;
        }
        Long containerZero = ASTNodes.getIntegerLiteral(endOfLoop);
        Expression containerCollectionOnSize = ForLoops.getCollectionOnSize(endOfLoop);
        Expression containerArrayOnLength = ForLoops.getArrayOnLength(endOfLoop);
        if (isLoopingForward) {
            if (containerCollectionOnSize != null) {
                return ForLoopContent.indexedCollection(containerCollectionOnSize, loopVar, true);
            }
            if (containerArrayOnLength != null) {
                return ForLoopContent.indexedArray(containerArrayOnLength, loopVar, true);
            }
        } else if (Long.valueOf(0L).equals(containerZero)) {
            if (collectionOnSize != null) {
                return ForLoopContent.indexedCollection(collectionOnSize, loopVar, false);
            }
            if (arrayOnLength != null) {
                return ForLoopContent.indexedArray(arrayOnLength, loopVar, false);
            }
        }
        return null;
    }

    private static Expression getCollectionOnSize(Expression containerVar) {
        Expression containerVarName;
        MethodInvocation methodInvocation = ASTNodes.as(containerVar, MethodInvocation.class);
        if (methodInvocation != null && (containerVarName = ASTNodes.getUnparenthesedExpression(methodInvocation.getExpression())) != null && ASTNodes.usesGivenSignature(methodInvocation, Collection.class.getCanonicalName(), SIZE_METHOD, new String[0])) {
            return containerVarName;
        }
        return null;
    }

    private static Expression getArrayOnLength(Expression containerVar) {
        FieldAccess containerVarName;
        if (containerVar instanceof QualifiedName) {
            QualifiedName containerVarName2 = (QualifiedName)containerVar;
            if (ASTNodes.isArray((Expression)containerVarName2.getQualifier()) && LENGTH.equals(containerVarName2.getName().getIdentifier())) {
                return containerVarName2.getQualifier();
            }
        } else if (containerVar instanceof FieldAccess && ASTNodes.isArray((containerVarName = (FieldAccess)containerVar).getExpression()) && LENGTH.equals(containerVarName.getName().getIdentifier())) {
            return containerVarName.getExpression();
        }
        return null;
    }

    public static enum ContainerType {
        ARRAY,
        COLLECTION;

    }

    public static final class ForLoopContent {
        private final IterationType iterationType;
        private final ContainerType containerType;
        private final Expression containerVariable;
        private final Expression iteratorVariable;
        private final Name loopVariable;
        private final boolean isLoopingForward;

        private ForLoopContent(IterationType iterationType, ContainerType containerType, Expression containerVariable, Expression iteratorVariable, Name loopVariable, boolean isLoopingForward) {
            this.iterationType = iterationType;
            this.containerType = containerType;
            this.containerVariable = containerVariable;
            this.iteratorVariable = iteratorVariable;
            this.loopVariable = loopVariable;
            this.isLoopingForward = isLoopingForward;
        }

        private static ForLoopContent indexedArray(Expression containerVariable, Name loopVariable, boolean isLoopingForward) {
            return new ForLoopContent(IterationType.INDEX, ContainerType.ARRAY, containerVariable, null, loopVariable, isLoopingForward);
        }

        private static ForLoopContent indexedCollection(Expression containerVariable, Name loopVariable, boolean isLoopingForward) {
            return new ForLoopContent(IterationType.INDEX, ContainerType.COLLECTION, containerVariable, null, loopVariable, isLoopingForward);
        }

        private static ForLoopContent iteratedCollection(Expression containerVariable, Expression iteratorVariable) {
            return new ForLoopContent(IterationType.ITERATOR, ContainerType.COLLECTION, containerVariable, iteratorVariable, null, true);
        }

        public Name getLoopVariable() {
            return this.loopVariable;
        }

        public Expression getContainerVariable() {
            return this.containerVariable;
        }

        public Expression getIteratorVariable() {
            return this.iteratorVariable;
        }

        public ContainerType getContainerType() {
            return this.containerType;
        }

        public IterationType getIterationType() {
            return this.iterationType;
        }

        public boolean isLoopingForward() {
            return this.isLoopingForward;
        }
    }

    public static enum IterationType {
        INDEX,
        ITERATOR,
        FOREACH;

    }
}

