/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.undo.snapshot.IResourceSnapshot;
import org.eclipse.core.resources.undo.snapshot.ResourceSnapshotFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.AbstractDeleteChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.UndoDeleteResourceChange;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IPackageFragmentRootManipulationQuery;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class DeletePackageFragmentRootChange
extends AbstractDeleteChange {
    private final String fHandle;
    private final IPackageFragmentRootManipulationQuery fUpdateClasspathQuery;

    public DeletePackageFragmentRootChange(IPackageFragmentRoot root, boolean isExecuteChange, IPackageFragmentRootManipulationQuery updateClasspathQuery) {
        Assert.isNotNull((Object)root);
        Assert.isTrue((!root.isExternal() ? 1 : 0) != 0);
        this.fHandle = root.getHandleIdentifier();
        this.fUpdateClasspathQuery = updateClasspathQuery;
        if (isExecuteChange) {
            this.setValidationMethod(2);
        } else {
            this.setValidationMethod(3);
        }
    }

    public String getName() {
        String rootName = JavaElementLabelsCore.getElementLabel((IJavaElement)this.getRoot(), 0x200009L);
        return Messages.format(RefactoringCoreMessages.DeletePackageFragmentRootChange_delete, rootName);
    }

    public Object getModifiedElement() {
        return this.getRoot();
    }

    protected IResource getModifiedResource() {
        return this.getRoot().getResource();
    }

    private IPackageFragmentRoot getRoot() {
        return (IPackageFragmentRoot)JavaCore.create((String)this.fHandle);
    }

    @Override
    protected Change doDelete(IProgressMonitor pm) throws CoreException {
        if (!this.confirmDeleteIfReferenced()) {
            return new NullChange();
        }
        int resourceUpdateFlags = 2;
        int jCoreUpdateFlags = 6;
        pm.beginTask("", 2);
        IPackageFragmentRoot root = this.getRoot();
        IResource rootResource = root.getResource();
        CompositeChange result = new CompositeChange(this.getName());
        IResourceSnapshot rootDescription = ResourceSnapshotFactory.fromResource((IResource)rootResource);
        HashMap<IFile, String> classpathFilesContents = new HashMap<IFile, String>();
        IJavaProject[] iJavaProjectArray = JavaElementUtil.getReferencingProjects(root);
        int n = iJavaProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject javaProject = iJavaProjectArray[n2];
            IFile classpathFile = javaProject.getProject().getFile(".classpath");
            if (classpathFile.exists()) {
                classpathFilesContents.put(classpathFile, DeletePackageFragmentRootChange.getFileContents(classpathFile));
            }
            ++n2;
        }
        root.delete(resourceUpdateFlags, jCoreUpdateFlags, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)pm, (int)1));
        rootDescription.recordStateFromHistory((IProgressMonitor)SubMonitor.convert((IProgressMonitor)pm, (int)1));
        for (Map.Entry entry : classpathFilesContents.entrySet()) {
            IFile file = (IFile)entry.getKey();
            String contents = (String)entry.getValue();
            TextFileChange classpathUndo = new TextFileChange(Messages.format(RefactoringCoreMessages.DeletePackageFragmentRootChange_restore_file, BasicElementLabels.getPathLabel(file.getFullPath(), true)), file);
            classpathUndo.setEdit((TextEdit)new ReplaceEdit(0, DeletePackageFragmentRootChange.getFileLength(file), contents));
            result.add((Change)classpathUndo);
        }
        result.add((Change)new UndoDeleteResourceChange((IResourceSnapshot<? extends IResource>)rootDescription));
        pm.done();
        return result;
    }

    private static String getFileContents(IFile file) throws CoreException {
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        IPath path = file.getFullPath();
        manager.connect(path, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
        try {
            String string = manager.getTextFileBuffer(path, LocationKind.IFILE).getDocument().get();
            return string;
        }
        finally {
            manager.disconnect(path, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    /*
     * Loose catch block
     */
    private static int getFileLength(IFile file) throws CoreException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                int n;
                InputStreamReader reader;
                InputStream contents;
                block18: {
                    block17: {
                        contents = file.getContents();
                        reader = DeletePackageFragmentRootChange.createReader(file, contents);
                        n = (int)reader.skip(Integer.MAX_VALUE);
                        if (reader == null) break block17;
                        reader.close();
                    }
                    if (contents == null) break block18;
                    contents.close();
                }
                return n;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (contents != null) {
                                contents.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, JavaManipulationPlugin.getPluginId(), e.getMessage(), (Throwable)e));
        }
    }

    private static InputStreamReader createReader(IFile file, InputStream contents) throws CoreException {
        try {
            return new InputStreamReader(contents, file.getCharset());
        }
        catch (UnsupportedEncodingException e) {
            JavaManipulationPlugin.log(e);
            return new InputStreamReader(contents);
        }
    }

    private boolean confirmDeleteIfReferenced() throws JavaModelException {
        IPackageFragmentRoot root = this.getRoot();
        if (!root.isArchive() && !root.isExternal()) {
            return true;
        }
        if (this.fUpdateClasspathQuery == null) {
            return true;
        }
        IJavaProject[] referencingProjects = JavaElementUtil.getReferencingProjects(this.getRoot());
        if (referencingProjects.length <= 1) {
            return true;
        }
        return this.fUpdateClasspathQuery.confirmManipulation(this.getRoot(), referencingProjects);
    }
}

